/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.xml;

import dori.jasper.engine.JRBand;
import dori.jasper.engine.JRElement;
import dori.jasper.engine.JRElementGroup;
import dori.jasper.engine.JREllipse;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRField;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRGraphicElement;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRImage;
import dori.jasper.engine.JRLine;
import dori.jasper.engine.JRParameter;
import dori.jasper.engine.JRQuery;
import dori.jasper.engine.JRRectangle;
import dori.jasper.engine.JRReport;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JRRuntimeException;
import dori.jasper.engine.JRStaticText;
import dori.jasper.engine.JRSubreport;
import dori.jasper.engine.JRSubreportParameter;
import dori.jasper.engine.JRTextElement;
import dori.jasper.engine.JRTextField;
import dori.jasper.engine.JRVariable;
import dori.jasper.engine.util.JRStringUtil;
import dori.jasper.engine.xml.JRXmlConstants;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JRXmlWriter {
    private JRReport report = null;
    private String encoding = null;
    private StringBuffer sbuffer = null;
    private Map fontsMap = new HashMap();
    private static final int colorMask = Integer.parseInt("FFFFFF", 16);

    protected JRXmlWriter(JRReport report, String encoding) {
        this.report = report;
        this.encoding = encoding;
    }

    public static String writeReport(JRReport report, String encoding) throws JRException {
        JRXmlWriter writer = new JRXmlWriter(report, encoding);
        return writer.writeReport();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeReport(JRReport report, String destFileName, String encoding) throws JRException {
        String xmlString = JRXmlWriter.writeReport(report, encoding);
        FileOutputStream fos = null;
        try {
            try {
                byte[] bytes = xmlString.getBytes(encoding);
                fos = new FileOutputStream(destFileName);
                fos.write(bytes, 0, bytes.length);
                fos.flush();
            }
            catch (IOException e) {
                throw new JRException("Error writing to file : " + destFileName, e);
            }
            Object var7_7 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fos.close();
        return;
    }

    public static void writeReport(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        String xmlString = JRXmlWriter.writeReport(report, encoding);
        try {
            byte[] bytes = xmlString.getBytes(encoding);
            outputStream.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new JRException("Error writing to OutputStream : " + report.getName(), e);
        }
    }

    protected String writeReport() throws JRException {
        JRGroup[] groups;
        JRVariable[] variables;
        JRField[] fields;
        JRParameter[] parameters;
        JRReportFont[] fonts;
        this.sbuffer = new StringBuffer();
        this.sbuffer.append("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
        this.sbuffer.append("<!DOCTYPE jasperReport PUBLIC \"-//JasperReports//DTD Report Design//EN\" \"http://jasperreports.sourceforge.net/dtds/jasperreport.dtd\">\n");
        this.sbuffer.append("\n");
        this.sbuffer.append("<jasperReport name=\"");
        this.sbuffer.append(this.report.getName());
        this.sbuffer.append("\"");
        if (this.report.getColumnCount() != 1) {
            this.sbuffer.append(" columnCount=\"");
            this.sbuffer.append(this.report.getColumnCount());
            this.sbuffer.append("\"");
        }
        if (this.report.getPrintOrder() != 1) {
            this.sbuffer.append(" printOrder=\"");
            this.sbuffer.append((String)JRXmlConstants.getPrintOrderMap().get(new Byte(this.report.getPrintOrder())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(" pageWidth=\"");
        this.sbuffer.append(this.report.getPageWidth());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pageHeight=\"");
        this.sbuffer.append(this.report.getPageHeight());
        this.sbuffer.append("\"");
        if (this.report.getOrientation() != 1) {
            this.sbuffer.append(" orientation=\"");
            this.sbuffer.append((String)JRXmlConstants.getOrientationMap().get(new Byte(this.report.getOrientation())));
            this.sbuffer.append("\"");
        }
        if (this.report.getWhenNoDataType() != 1) {
            this.sbuffer.append(" whenNoDataType=\"");
            this.sbuffer.append((String)JRXmlConstants.getWhenNoDataTypeMap().get(new Byte(this.report.getWhenNoDataType())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(" columnWidth=\"");
        this.sbuffer.append(this.report.getColumnWidth());
        this.sbuffer.append("\"");
        if (this.report.getColumnSpacing() != 0) {
            this.sbuffer.append(" columnSpacing=\"");
            this.sbuffer.append(this.report.getColumnSpacing());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(" leftMargin=\"");
        this.sbuffer.append(this.report.getLeftMargin());
        this.sbuffer.append("\"");
        this.sbuffer.append(" rightMargin=\"");
        this.sbuffer.append(this.report.getRightMargin());
        this.sbuffer.append("\"");
        this.sbuffer.append(" topMargin=\"");
        this.sbuffer.append(this.report.getTopMargin());
        this.sbuffer.append("\"");
        this.sbuffer.append(" bottomMargin=\"");
        this.sbuffer.append(this.report.getBottomMargin());
        this.sbuffer.append("\"");
        if (this.report.isTitleNewPage()) {
            this.sbuffer.append(" isTitleNewPage=\"");
            this.sbuffer.append(this.report.isTitleNewPage());
            this.sbuffer.append("\"");
        }
        if (this.report.isSummaryNewPage()) {
            this.sbuffer.append(" isSummaryNewPage=\"");
            this.sbuffer.append(this.report.isSummaryNewPage());
            this.sbuffer.append("\"");
        }
        if (this.report.getScriptletClass() != null) {
            this.sbuffer.append(" scriptletClass=\"");
            this.sbuffer.append(this.report.getScriptletClass());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        String[] propertyNames = this.report.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            int i = 0;
            while (i < propertyNames.length) {
                String value = this.report.getProperty(propertyNames[i]);
                if (value != null) {
                    this.sbuffer.append("\t<property name=\"");
                    this.sbuffer.append(propertyNames[i]);
                    this.sbuffer.append("\" value=\"");
                    this.sbuffer.append(JRStringUtil.xmlEncode(value));
                    this.sbuffer.append("\"/>\n");
                }
                ++i;
            }
        }
        if ((fonts = this.report.getFonts()) != null && fonts.length > 0) {
            int i = 0;
            while (i < fonts.length) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.writeReportFont(fonts[i]);
                ++i;
            }
        }
        if ((parameters = this.report.getParameters()) != null && parameters.length > 0) {
            int i = 0;
            while (i < parameters.length) {
                if (!parameters[i].isSystemDefined()) {
                    this.writeParameter(parameters[i]);
                }
                ++i;
            }
        }
        if (this.report.getQuery() != null) {
            this.writeQuery(this.report.getQuery());
        }
        if ((fields = this.report.getFields()) != null && fields.length > 0) {
            int i = 0;
            while (i < fields.length) {
                this.writeField(fields[i]);
                ++i;
            }
        }
        if ((variables = this.report.getVariables()) != null && variables.length > 0) {
            int i = 0;
            while (i < variables.length) {
                if (!variables[i].isSystemDefined()) {
                    this.writeVariable(variables[i]);
                }
                ++i;
            }
        }
        if ((groups = this.report.getGroups()) != null && groups.length > 0) {
            int i = 0;
            while (i < groups.length) {
                this.writeGroup(groups[i]);
                ++i;
            }
        }
        if (this.report.getBackground() != null) {
            this.sbuffer.append("\t<background>\n");
            this.writeBand(this.report.getBackground());
            this.sbuffer.append("\t</background>\n");
        }
        if (this.report.getTitle() != null) {
            this.sbuffer.append("\t<title>\n");
            this.writeBand(this.report.getTitle());
            this.sbuffer.append("\t</title>\n");
        }
        if (this.report.getPageHeader() != null) {
            this.sbuffer.append("\t<pageHeader>\n");
            this.writeBand(this.report.getPageHeader());
            this.sbuffer.append("\t</pageHeader>\n");
        }
        if (this.report.getColumnHeader() != null) {
            this.sbuffer.append("\t<columnHeader>\n");
            this.writeBand(this.report.getColumnHeader());
            this.sbuffer.append("\t</columnHeader>\n");
        }
        if (this.report.getDetail() != null) {
            this.sbuffer.append("\t<detail>\n");
            this.writeBand(this.report.getDetail());
            this.sbuffer.append("\t</detail>\n");
        }
        if (this.report.getColumnFooter() != null) {
            this.sbuffer.append("\t<columnFooter>\n");
            this.writeBand(this.report.getColumnFooter());
            this.sbuffer.append("\t</columnFooter>\n");
        }
        if (this.report.getPageFooter() != null) {
            this.sbuffer.append("\t<pageFooter>\n");
            this.writeBand(this.report.getPageFooter());
            this.sbuffer.append("\t</pageFooter>\n");
        }
        if (this.report.getSummary() != null) {
            this.sbuffer.append("\t<summary>\n");
            this.writeBand(this.report.getSummary());
            this.sbuffer.append("\t</summary>\n");
        }
        this.sbuffer.append("</jasperReport>\n");
        return this.sbuffer.toString();
    }

    private void writeReportFont(JRReportFont font) {
        this.sbuffer.append("\t<reportFont");
        this.sbuffer.append(" name=\"");
        this.sbuffer.append(font.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isDefault=\"");
        this.sbuffer.append(font.isDefault());
        this.sbuffer.append("\"");
        this.sbuffer.append(" fontName=\"");
        this.sbuffer.append(font.getFontName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" size=\"");
        this.sbuffer.append(font.getSize());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isBold=\"");
        this.sbuffer.append(font.isBold());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isItalic=\"");
        this.sbuffer.append(font.isItalic());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isUnderline=\"");
        this.sbuffer.append(font.isUnderline());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isStrikeThrough=\"");
        this.sbuffer.append(font.isStrikeThrough());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pdfFontName=\"");
        this.sbuffer.append(font.getPdfFontName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pdfEncoding=\"");
        this.sbuffer.append(font.getPdfEncoding());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isPdfEmbedded=\"");
        this.sbuffer.append(font.isPdfEmbedded());
        this.sbuffer.append("\"");
        this.sbuffer.append("/>\n");
    }

    private void writeParameter(JRParameter parameter) {
        this.sbuffer.append("\t<parameter");
        this.sbuffer.append(" name=\"");
        this.sbuffer.append(parameter.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" class=\"");
        this.sbuffer.append(parameter.getValueClassName());
        this.sbuffer.append("\"");
        if (!parameter.isForPrompting()) {
            this.sbuffer.append(" isForPrompting=\"");
            this.sbuffer.append(parameter.isForPrompting());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        if (parameter.getDescription() != null) {
            this.sbuffer.append("\t\t<parameterDescription><![CDATA[");
            this.sbuffer.append(parameter.getDescription());
            this.sbuffer.append("]]></parameterDescription>\n");
        }
        if (parameter.getDefaultValueExpression() != null) {
            this.sbuffer.append("\t\t<defaultValueExpression><![CDATA[");
            this.sbuffer.append(parameter.getDefaultValueExpression().getText());
            this.sbuffer.append("]]></defaultValueExpression>\n");
        }
        this.sbuffer.append("\t</parameter>\n");
    }

    private void writeQuery(JRQuery query) {
        this.sbuffer.append("\t<queryString><![CDATA[");
        this.sbuffer.append(query.getText());
        this.sbuffer.append("]]></queryString>\n");
    }

    private void writeField(JRField field) {
        this.sbuffer.append("\t<field");
        this.sbuffer.append(" name=\"");
        this.sbuffer.append(field.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" class=\"");
        this.sbuffer.append(field.getValueClassName());
        this.sbuffer.append("\"");
        this.sbuffer.append(">\n");
        if (field.getDescription() != null) {
            this.sbuffer.append("\t\t<fieldDescription><![CDATA[");
            this.sbuffer.append(field.getDescription());
            this.sbuffer.append("]]></fieldDescription>\n");
        }
        this.sbuffer.append("\t</field>\n");
    }

    private void writeVariable(JRVariable variable) {
        this.sbuffer.append("\t<variable");
        this.sbuffer.append(" name=\"");
        this.sbuffer.append(variable.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" class=\"");
        this.sbuffer.append(variable.getValueClassName());
        this.sbuffer.append("\"");
        if (variable.getResetType() != 1) {
            this.sbuffer.append(" resetType=\"");
            this.sbuffer.append((String)JRXmlConstants.getResetTypeMap().get(new Byte(variable.getResetType())));
            this.sbuffer.append("\"");
        }
        if (variable.getResetGroup() != null) {
            this.sbuffer.append(" resetGroup=\"");
            this.sbuffer.append(variable.getResetGroup().getName());
            this.sbuffer.append("\"");
        }
        if (variable.getCalculation() != 0) {
            this.sbuffer.append(" calculation=\"");
            this.sbuffer.append((String)JRXmlConstants.getCalculationMap().get(new Byte(variable.getCalculation())));
            this.sbuffer.append("\"");
        }
        if (variable.getIncrementerFactoryClassName() != null) {
            this.sbuffer.append(" incrementerFactoryClass=\"");
            this.sbuffer.append(variable.getIncrementerFactoryClassName());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        if (variable.getExpression() != null) {
            this.sbuffer.append("\t\t<variableExpression><![CDATA[");
            this.sbuffer.append(variable.getExpression().getText());
            this.sbuffer.append("]]></variableExpression>\n");
        }
        if (variable.getInitialValueExpression() != null) {
            this.sbuffer.append("\t\t<initialValueExpression><![CDATA[");
            this.sbuffer.append(variable.getInitialValueExpression().getText());
            this.sbuffer.append("]]></initialValueExpression>\n");
        }
        this.sbuffer.append("\t</variable>\n");
    }

    private void writeGroup(JRGroup group) {
        this.sbuffer.append("\t<group");
        this.sbuffer.append(" name=\"");
        this.sbuffer.append(group.getName());
        this.sbuffer.append("\"");
        if (group.isStartNewColumn()) {
            this.sbuffer.append(" isStartNewColumn=\"");
            this.sbuffer.append(group.isStartNewColumn());
            this.sbuffer.append("\"");
        }
        if (group.isStartNewPage()) {
            this.sbuffer.append(" isStartNewPage=\"");
            this.sbuffer.append(group.isStartNewPage());
            this.sbuffer.append("\"");
        }
        if (group.isResetPageNumber()) {
            this.sbuffer.append(" isResetPageNumber=\"");
            this.sbuffer.append(group.isResetPageNumber());
            this.sbuffer.append("\"");
        }
        if (group.isReprintHeaderOnEachPage()) {
            this.sbuffer.append(" isReprintHeaderOnEachPage=\"");
            this.sbuffer.append(group.isReprintHeaderOnEachPage());
            this.sbuffer.append("\"");
        }
        if (group.getMinHeightToStartNewPage() > 0) {
            this.sbuffer.append(" minHeightToStartNewPage=\"");
            this.sbuffer.append(group.getMinHeightToStartNewPage());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        if (group.getExpression() != null) {
            this.sbuffer.append("\t\t<groupExpression><![CDATA[");
            this.sbuffer.append(group.getExpression().getText());
            this.sbuffer.append("]]></groupExpression>\n");
        }
        if (group.getGroupHeader() != null) {
            this.sbuffer.append("\t\t<groupHeader>\n");
            this.writeBand(group.getGroupHeader());
            this.sbuffer.append("\t\t</groupHeader>\n");
        }
        if (group.getGroupFooter() != null) {
            this.sbuffer.append("\t\t<groupFooter>\n");
            this.writeBand(group.getGroupFooter());
            this.sbuffer.append("\t\t</groupFooter>\n");
        }
        this.sbuffer.append("\t</group>\n");
    }

    private void writeBand(JRBand band) {
        List children;
        this.sbuffer.append("\t\t<band");
        if (band.getHeight() > 0) {
            this.sbuffer.append(" height=\"");
            this.sbuffer.append(band.getHeight());
            this.sbuffer.append("\"");
        }
        if (!band.isSplitAllowed()) {
            this.sbuffer.append(" isSplitAllowed=\"");
            this.sbuffer.append(band.isSplitAllowed());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        if (band.getPrintWhenExpression() != null) {
            this.sbuffer.append("\t\t\t<printWhenExpression><![CDATA[");
            this.sbuffer.append(band.getPrintWhenExpression().getText());
            this.sbuffer.append("]]></printWhenExpression>\n");
        }
        if ((children = band.getChildren()) != null && children.size() > 0) {
            Object child = null;
            int i = 0;
            while (i < children.size()) {
                child = children.get(i);
                if (child instanceof JRElementGroup) {
                    this.writeElementGroup(child);
                } else {
                    this.writeElement(child);
                }
                ++i;
            }
        }
        this.sbuffer.append("\t\t</band>\n");
    }

    private void writeElementGroup(JRElementGroup elementGroup) {
        this.sbuffer.append("\t\t\t<elementGroup>\n");
        List children = elementGroup.getChildren();
        if (children != null && children.size() > 0) {
            Object child = null;
            int i = 0;
            while (i < children.size()) {
                child = children.get(i);
                if (child instanceof JRElementGroup) {
                    this.writeElementGroup(child);
                } else {
                    this.writeElement(child);
                }
                ++i;
            }
        }
        this.sbuffer.append("\t\t\t</elementGroup>\n");
    }

    private void writeElement(JRElement element) {
        if (element instanceof JRLine) {
            this.writeLine((JRLine)element);
        } else if (element instanceof JRRectangle) {
            this.writeRectangle((JRRectangle)element);
        } else if (element instanceof JREllipse) {
            this.writeEllipse((JREllipse)element);
        } else if (element instanceof JRImage) {
            this.writeImage((JRImage)element);
        } else if (element instanceof JRStaticText) {
            this.writeStaticText((JRStaticText)element);
        } else if (element instanceof JRTextField) {
            this.writeTextField((JRTextField)element);
        } else if (element instanceof JRSubreport) {
            this.writeSubreport((JRSubreport)element);
        }
    }

    private void writeLine(JRLine line) {
        this.sbuffer.append("\t\t\t<line");
        if (line.getDirection() != 1) {
            this.sbuffer.append(" direction=\"");
            this.sbuffer.append((String)JRXmlConstants.getDirectionMap().get(new Byte(line.getDirection())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.writeReportElement(line);
        this.writeGraphicElement(line);
        this.sbuffer.append("\t\t\t</line>\n");
    }

    private void writeReportElement(JRElement element) {
        this.sbuffer.append("\t\t\t\t<reportElement");
        if (element.getKey() != null) {
            this.sbuffer.append(" key=\"");
            this.sbuffer.append(element.getKey());
            this.sbuffer.append("\"");
        }
        if (element.getPositionType() != 2) {
            this.sbuffer.append(" positionType=\"");
            this.sbuffer.append((String)JRXmlConstants.getPositionTypeMap().get(new Byte(element.getPositionType())));
            this.sbuffer.append("\"");
        }
        if (element.getStretchType() != 0) {
            this.sbuffer.append(" stretchType=\"");
            this.sbuffer.append((String)JRXmlConstants.getStretchTypeMap().get(new Byte(element.getStretchType())));
            this.sbuffer.append("\"");
        }
        if (!element.isPrintRepeatedValues()) {
            this.sbuffer.append(" isPrintRepeatedValues=\"");
            this.sbuffer.append(element.isPrintRepeatedValues());
            this.sbuffer.append("\"");
        }
        if (element instanceof JRLine && element.getMode() != 1 || element instanceof JRRectangle && element.getMode() != 1 || element instanceof JREllipse && element.getMode() != 1 || element instanceof JRImage && element.getMode() != 2 || element instanceof JRTextElement && element.getMode() != 2 || element instanceof JRSubreport && element.getMode() != 2) {
            this.sbuffer.append(" mode=\"");
            this.sbuffer.append((String)JRXmlConstants.getModeMap().get(new Byte(element.getMode())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(" x=\"");
        this.sbuffer.append(element.getX());
        this.sbuffer.append("\"");
        this.sbuffer.append(" y=\"");
        this.sbuffer.append(element.getY());
        this.sbuffer.append("\"");
        this.sbuffer.append(" width=\"");
        this.sbuffer.append(element.getWidth());
        this.sbuffer.append("\"");
        this.sbuffer.append(" height=\"");
        this.sbuffer.append(element.getHeight());
        this.sbuffer.append("\"");
        if (element.isRemoveLineWhenBlank()) {
            this.sbuffer.append(" isRemoveLineWhenBlank=\"");
            this.sbuffer.append(element.isRemoveLineWhenBlank());
            this.sbuffer.append("\"");
        }
        if (element.isPrintInFirstWholeBand()) {
            this.sbuffer.append(" isPrintInFirstWholeBand=\"");
            this.sbuffer.append(element.isPrintInFirstWholeBand());
            this.sbuffer.append("\"");
        }
        if (element.isPrintWhenDetailOverflows()) {
            this.sbuffer.append(" isPrintWhenDetailOverflows=\"");
            this.sbuffer.append(element.isPrintWhenDetailOverflows());
            this.sbuffer.append("\"");
        }
        if (element.getPrintWhenGroupChanges() != null) {
            this.sbuffer.append(" printWhenGroupChanges=\"");
            this.sbuffer.append(element.getPrintWhenGroupChanges().getName());
            this.sbuffer.append("\"");
        }
        if (element.getForecolor().getRGB() != Color.black.getRGB()) {
            this.sbuffer.append(" forecolor=\"#");
            this.sbuffer.append(Integer.toHexString(element.getForecolor().getRGB() & colorMask));
            this.sbuffer.append("\"");
        }
        if (element.getBackcolor().getRGB() != Color.white.getRGB()) {
            this.sbuffer.append(" backcolor=\"#");
            this.sbuffer.append(Integer.toHexString(element.getBackcolor().getRGB() & colorMask));
            this.sbuffer.append("\"");
        }
        if (element.getPrintWhenExpression() != null) {
            this.sbuffer.append(">\n");
            this.sbuffer.append("\t\t\t\t\t<printWhenExpression><![CDATA[");
            this.sbuffer.append(element.getPrintWhenExpression().getText());
            this.sbuffer.append("]]></printWhenExpression>\n");
            this.sbuffer.append("\t\t\t\t</reportElement>\n");
        } else {
            this.sbuffer.append("/>\n");
        }
    }

    private void writeGraphicElement(JRGraphicElement element) {
        this.sbuffer.append("\t\t\t\t<graphicElement");
        if (element instanceof JRLine && element.getPen() != 1 || element instanceof JRRectangle && element.getPen() != 1 || element instanceof JREllipse && element.getPen() != 1 || element instanceof JRImage && element.getPen() != 0) {
            this.sbuffer.append(" pen=\"");
            this.sbuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(element.getPen())));
            this.sbuffer.append("\"");
        }
        if (element.getFill() != 1) {
            this.sbuffer.append(" fill=\"");
            this.sbuffer.append((String)JRXmlConstants.getFillMap().get(new Byte(element.getFill())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append("/>\n");
    }

    private void writeRectangle(JRRectangle rectangle) {
        this.sbuffer.append("\t\t\t<rectangle");
        if (rectangle.getRadius() != 0) {
            this.sbuffer.append(" radius=\"");
            this.sbuffer.append(rectangle.getRadius());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.writeReportElement(rectangle);
        this.writeGraphicElement(rectangle);
        this.sbuffer.append("\t\t\t</rectangle>\n");
    }

    private void writeEllipse(JREllipse ellipse) {
        this.sbuffer.append("\t\t\t<ellipse>\n");
        this.writeReportElement(ellipse);
        this.writeGraphicElement(ellipse);
        this.sbuffer.append("\t\t\t</ellipse>\n");
    }

    private void writeImage(JRImage image) {
        this.sbuffer.append("\t\t\t<image");
        if (image.getScaleImage() != 3) {
            this.sbuffer.append(" scaleImage=\"");
            this.sbuffer.append((String)JRXmlConstants.getScaleImageMap().get(new Byte(image.getScaleImage())));
            this.sbuffer.append("\"");
        }
        if (image.getHorizontalAlignment() != 1) {
            this.sbuffer.append(" hAlign=\"");
            this.sbuffer.append((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(image.getHorizontalAlignment())));
            this.sbuffer.append("\"");
        }
        if (image.getVerticalAlignment() != 1) {
            this.sbuffer.append(" vAlign=\"");
            this.sbuffer.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(image.getVerticalAlignment())));
            this.sbuffer.append("\"");
        }
        if (!image.isUsingCache()) {
            this.sbuffer.append(" isUsingCache=\"");
            this.sbuffer.append(image.isUsingCache());
            this.sbuffer.append("\"");
        }
        if (image.getEvaluationTime() != 1) {
            this.sbuffer.append(" evaluationTime=\"");
            this.sbuffer.append((String)JRXmlConstants.getEvaluationTimeMap().get(new Byte(image.getEvaluationTime())));
            this.sbuffer.append("\"");
        }
        if (image.getEvaluationGroup() != null) {
            this.sbuffer.append(" evaluationGroup=\"");
            this.sbuffer.append(image.getEvaluationGroup().getName());
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkType() != 1) {
            this.sbuffer.append(" hyperlinkType=\"");
            this.sbuffer.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(image.getHyperlinkType())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.writeReportElement(image);
        this.writeGraphicElement(image);
        if (image.getExpression() != null) {
            this.sbuffer.append("\t\t\t\t<imageExpression");
            this.sbuffer.append(" class=\"");
            this.sbuffer.append(image.getExpression().getValueClassName());
            this.sbuffer.append("\"");
            this.sbuffer.append("><![CDATA[");
            this.sbuffer.append(image.getExpression().getText());
            this.sbuffer.append("]]></imageExpression>\n");
        }
        if (image.getAnchorNameExpression() != null) {
            this.sbuffer.append("\t\t\t\t<anchorNameExpression><![CDATA[");
            this.sbuffer.append(image.getAnchorNameExpression().getText());
            this.sbuffer.append("]]></anchorNameExpression>\n");
        }
        if (image.getHyperlinkReferenceExpression() != null) {
            this.sbuffer.append("\t\t\t\t<hyperlinkReferenceExpression><![CDATA[");
            this.sbuffer.append(image.getHyperlinkReferenceExpression().getText());
            this.sbuffer.append("]]></hyperlinkReferenceExpression>\n");
        }
        if (image.getHyperlinkAnchorExpression() != null) {
            this.sbuffer.append("\t\t\t\t<hyperlinkAnchorExpression><![CDATA[");
            this.sbuffer.append(image.getHyperlinkAnchorExpression().getText());
            this.sbuffer.append("]]></hyperlinkAnchorExpression>\n");
        }
        if (image.getHyperlinkPageExpression() != null) {
            this.sbuffer.append("\t\t\t\t<hyperlinkPageExpression><![CDATA[");
            this.sbuffer.append(image.getHyperlinkPageExpression().getText());
            this.sbuffer.append("]]></hyperlinkPageExpression>\n");
        }
        this.sbuffer.append("\t\t\t</image>\n");
    }

    private void writeStaticText(JRStaticText staticText) {
        this.sbuffer.append("\t\t\t<staticText>\n");
        this.writeReportElement(staticText);
        this.writeTextElement(staticText);
        if (staticText.getText() != null) {
            this.sbuffer.append("\t\t\t\t<text><![CDATA[");
            this.sbuffer.append(staticText.getText());
            this.sbuffer.append("]]></text>\n");
        }
        this.sbuffer.append("\t\t\t</staticText>\n");
    }

    private void writeTextElement(JRTextElement textElement) {
        String font;
        this.sbuffer.append("\t\t\t\t<textElement");
        if (textElement.getTextAlignment() != 1) {
            this.sbuffer.append(" textAlignment=\"");
            this.sbuffer.append((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(textElement.getTextAlignment())));
            this.sbuffer.append("\"");
        }
        if (textElement.getVerticalAlignment() != 1) {
            this.sbuffer.append(" verticalAlignment=\"");
            this.sbuffer.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(textElement.getVerticalAlignment())));
            this.sbuffer.append("\"");
        }
        if (textElement.getRotation() != 0) {
            this.sbuffer.append(" rotation=\"");
            this.sbuffer.append((String)JRXmlConstants.getRotationMap().get(new Byte(textElement.getRotation())));
            this.sbuffer.append("\"");
        }
        if (textElement.getLineSpacing() != 0) {
            this.sbuffer.append(" lineSpacing=\"");
            this.sbuffer.append((String)JRXmlConstants.getLineSpacingMap().get(new Byte(textElement.getLineSpacing())));
            this.sbuffer.append("\"");
        }
        if (textElement.isStyledText()) {
            this.sbuffer.append(" isStyledText=\"");
            this.sbuffer.append(textElement.isStyledText());
            this.sbuffer.append("\"");
        }
        if ((font = this.writeFont(textElement.getFont())) != null) {
            this.sbuffer.append(">\n");
            this.sbuffer.append("\t\t\t\t\t" + font + "\n");
            this.sbuffer.append("\t\t\t\t</textElement>\n");
        } else {
            this.sbuffer.append("/>\n");
        }
    }

    private String writeFont(JRFont font) {
        String fontChunk = null;
        if (font != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    tmpBuffer.append(" reportFont=\"");
                    tmpBuffer.append(font.getReportFont().getName());
                    tmpBuffer.append("\"");
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            if (font.getOwnFontName() != null) {
                tmpBuffer.append(" fontName=\"");
                tmpBuffer.append(font.getOwnFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnSize() != null) {
                tmpBuffer.append(" size=\"");
                tmpBuffer.append(font.getOwnSize());
                tmpBuffer.append("\"");
            }
            if (font.isOwnBold() != null) {
                tmpBuffer.append(" isBold=\"");
                tmpBuffer.append(font.isOwnBold());
                tmpBuffer.append("\"");
            }
            if (font.isOwnItalic() != null) {
                tmpBuffer.append(" isItalic=\"");
                tmpBuffer.append(font.isOwnItalic());
                tmpBuffer.append("\"");
            }
            if (font.isOwnUnderline() != null) {
                tmpBuffer.append(" isUnderline=\"");
                tmpBuffer.append(font.isOwnUnderline());
                tmpBuffer.append("\"");
            }
            if (font.isOwnStrikeThrough() != null) {
                tmpBuffer.append(" isStrikeThrough=\"");
                tmpBuffer.append(font.isOwnStrikeThrough());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfFontName() != null) {
                tmpBuffer.append(" pdfFontName=\"");
                tmpBuffer.append(font.getOwnPdfFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfEncoding() != null) {
                tmpBuffer.append(" pdfEncoding=\"");
                tmpBuffer.append(font.getOwnPdfEncoding());
                tmpBuffer.append("\"");
            }
            if (font.isOwnPdfEmbedded() != null) {
                tmpBuffer.append(" isPdfEmbedded=\"");
                tmpBuffer.append(font.isOwnPdfEmbedded());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                fontChunk = "<font" + tmpBuffer.toString() + "/>";
            }
        }
        return fontChunk;
    }

    private void writeTextField(JRTextField textField) {
        this.sbuffer.append("\t\t\t<textField");
        if (textField.isStretchWithOverflow()) {
            this.sbuffer.append(" isStretchWithOverflow=\"");
            this.sbuffer.append(textField.isStretchWithOverflow());
            this.sbuffer.append("\"");
        }
        if (textField.getEvaluationTime() != 1) {
            this.sbuffer.append(" evaluationTime=\"");
            this.sbuffer.append((String)JRXmlConstants.getEvaluationTimeMap().get(new Byte(textField.getEvaluationTime())));
            this.sbuffer.append("\"");
        }
        if (textField.getEvaluationGroup() != null) {
            this.sbuffer.append(" evaluationGroup=\"");
            this.sbuffer.append(textField.getEvaluationGroup().getName());
            this.sbuffer.append("\"");
        }
        if (textField.getPattern() != null) {
            this.sbuffer.append(" pattern=\"");
            this.sbuffer.append(textField.getPattern());
            this.sbuffer.append("\"");
        }
        if (textField.isBlankWhenNull()) {
            this.sbuffer.append(" isBlankWhenNull=\"");
            this.sbuffer.append(textField.isBlankWhenNull());
            this.sbuffer.append("\"");
        }
        if (textField.getHyperlinkType() != 1) {
            this.sbuffer.append(" hyperlinkType=\"");
            this.sbuffer.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(textField.getHyperlinkType())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.writeReportElement(textField);
        this.writeTextElement(textField);
        if (textField.getExpression() != null) {
            this.sbuffer.append("\t\t\t\t<textFieldExpression");
            this.sbuffer.append(" class=\"");
            this.sbuffer.append(textField.getExpression().getValueClassName());
            this.sbuffer.append("\"");
            this.sbuffer.append("><![CDATA[");
            this.sbuffer.append(textField.getExpression().getText());
            this.sbuffer.append("]]></textFieldExpression>\n");
        }
        if (textField.getAnchorNameExpression() != null) {
            this.sbuffer.append("\t\t\t\t<anchorNameExpression><![CDATA[");
            this.sbuffer.append(textField.getAnchorNameExpression().getText());
            this.sbuffer.append("]]></anchorNameExpression>\n");
        }
        if (textField.getHyperlinkReferenceExpression() != null) {
            this.sbuffer.append("\t\t\t\t<hyperlinkReferenceExpression><![CDATA[");
            this.sbuffer.append(textField.getHyperlinkReferenceExpression().getText());
            this.sbuffer.append("]]></hyperlinkReferenceExpression>\n");
        }
        if (textField.getHyperlinkAnchorExpression() != null) {
            this.sbuffer.append("\t\t\t\t<hyperlinkAnchorExpression><![CDATA[");
            this.sbuffer.append(textField.getHyperlinkAnchorExpression().getText());
            this.sbuffer.append("]]></hyperlinkAnchorExpression>\n");
        }
        if (textField.getHyperlinkPageExpression() != null) {
            this.sbuffer.append("\t\t\t\t<hyperlinkPageExpression><![CDATA[");
            this.sbuffer.append(textField.getHyperlinkPageExpression().getText());
            this.sbuffer.append("]]></hyperlinkPageExpression>\n");
        }
        this.sbuffer.append("\t\t\t</textField>\n");
    }

    private void writeSubreport(JRSubreport subreport) {
        JRSubreportParameter[] parameters;
        this.sbuffer.append("\t\t\t<subreport");
        if (!subreport.isUsingCache()) {
            this.sbuffer.append(" isUsingCache=\"");
            this.sbuffer.append(subreport.isUsingCache());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.writeReportElement(subreport);
        if (subreport.getParametersMapExpression() != null) {
            this.sbuffer.append("\t\t\t\t<parametersMapExpression><![CDATA[");
            this.sbuffer.append(subreport.getParametersMapExpression().getText());
            this.sbuffer.append("]]></parametersMapExpression>\n");
        }
        if ((parameters = subreport.getParameters()) != null && parameters.length > 0) {
            int i = 0;
            while (i < parameters.length) {
                this.writeSubreportParameter(parameters[i]);
                ++i;
            }
        }
        if (subreport.getConnectionExpression() != null) {
            this.sbuffer.append("\t\t\t\t<connectionExpression><![CDATA[");
            this.sbuffer.append(subreport.getConnectionExpression().getText());
            this.sbuffer.append("]]></connectionExpression>\n");
        }
        if (subreport.getDataSourceExpression() != null) {
            this.sbuffer.append("\t\t\t\t<dataSourceExpression><![CDATA[");
            this.sbuffer.append(subreport.getDataSourceExpression().getText());
            this.sbuffer.append("]]></dataSourceExpression>\n");
        }
        if (subreport.getExpression() != null) {
            this.sbuffer.append("\t\t\t\t<subreportExpression");
            this.sbuffer.append(" class=\"");
            this.sbuffer.append(subreport.getExpression().getValueClassName());
            this.sbuffer.append("\"");
            this.sbuffer.append("><![CDATA[");
            this.sbuffer.append(subreport.getExpression().getText());
            this.sbuffer.append("]]></subreportExpression>\n");
        }
        this.sbuffer.append("\t\t\t</subreport>\n");
    }

    private void writeSubreportParameter(JRSubreportParameter subreportParameter) {
        this.sbuffer.append("\t\t\t\t<subreportParameter");
        this.sbuffer.append(" name=\"");
        this.sbuffer.append(subreportParameter.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(">\n");
        if (subreportParameter.getExpression() != null) {
            this.sbuffer.append("\t\t\t\t\t<subreportParameterExpression><![CDATA[");
            this.sbuffer.append(subreportParameter.getExpression().getText());
            this.sbuffer.append("]]></subreportParameterExpression>\n");
        }
        this.sbuffer.append("\t\t\t\t</subreportParameter>\n");
    }
}

