/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.xml;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRVariable;
import dori.jasper.engine.design.JRDesignElement;
import dori.jasper.engine.design.JRDesignImage;
import dori.jasper.engine.design.JRDesignTextField;
import dori.jasper.engine.design.JRDesignVariable;
import dori.jasper.engine.design.JasperDesign;
import dori.jasper.engine.xml.JRXmlDigesterFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class JRXmlLoader {
    private JasperDesign jasperDesign = null;
    private Collection groupReprintedElements = new ArrayList();
    private Collection groupEvaluatedImages = new ArrayList();
    private Collection groupEvaluatedTextFields = new ArrayList();
    private List errors = new ArrayList();
    private int printWhenExpressionsCount = 0;
    private int anchorNameExpressionsCount = 0;
    private int hyperlinkReferenceExpressionsCount = 0;
    private int hyperlinkAnchorExpressionsCount = 0;
    private int hyperlinkPageExpressionsCount = 0;
    private int imagesCount = 0;
    private int textFieldsCount = 0;
    private int subreportsCount = 0;
    private int subreportParametersCount = 0;
    private Digester digester = null;

    public JRXmlLoader(Digester digester) {
        this.digester = digester;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public Collection getGroupReprintedElements() {
        return this.groupReprintedElements;
    }

    public Collection getGroupEvaluatedImages() {
        return this.groupEvaluatedImages;
    }

    public Collection getGroupEvaluatedTextFields() {
        return this.groupEvaluatedTextFields;
    }

    public int getPrintWhenExpressionsCount() {
        return this.printWhenExpressionsCount;
    }

    public void setPrintWhenExpressionsCount(int count) {
        this.printWhenExpressionsCount = count;
    }

    public int getAnchorNameExpressionsCount() {
        return this.anchorNameExpressionsCount;
    }

    public void setAnchorNameExpressionsCount(int count) {
        this.anchorNameExpressionsCount = count;
    }

    public int getHyperlinkReferenceExpressionsCount() {
        return this.hyperlinkReferenceExpressionsCount;
    }

    public void setHyperlinkReferenceExpressionsCount(int count) {
        this.hyperlinkReferenceExpressionsCount = count;
    }

    public int getHyperlinkAnchorExpressionsCount() {
        return this.hyperlinkAnchorExpressionsCount;
    }

    public void setHyperlinkAnchorExpressionsCount(int count) {
        this.hyperlinkAnchorExpressionsCount = count;
    }

    public int getHyperlinkPageExpressionsCount() {
        return this.hyperlinkPageExpressionsCount;
    }

    public void setHyperlinkPageExpressionsCount(int count) {
        this.hyperlinkPageExpressionsCount = count;
    }

    public int getImagesCount() {
        return this.imagesCount;
    }

    public void setImagesCount(int count) {
        this.imagesCount = count;
    }

    public int getTextFieldsCount() {
        return this.textFieldsCount;
    }

    public void setTextFieldsCount(int count) {
        this.textFieldsCount = count;
    }

    public int getSubreportsCount() {
        return this.subreportsCount;
    }

    public void setSubreportsCount(int count) {
        this.subreportsCount = count;
    }

    public int getSubreportParametersCount() {
        return this.subreportParametersCount;
    }

    public void setSubreportParametersCount(int count) {
        this.subreportParametersCount = count;
    }

    public static JasperDesign load(String sourceFileName) throws JRException {
        return JRXmlLoader.load(new File(sourceFileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JasperDesign load(File file) throws JRException {
        JasperDesign jasperDesign = null;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                jasperDesign = JRXmlLoader.load(fis);
            }
            catch (IOException e) {
                throw new JRException(e);
            }
            Object var5_3 = null;
            if (fis == null) return jasperDesign;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fis.close();
        return jasperDesign;
    }

    public static JasperDesign load(InputStream is) throws JRException {
        JasperDesign jasperDesign = null;
        JRXmlLoader xmlLoader = null;
        try {
            xmlLoader = new JRXmlLoader(JRXmlDigesterFactory.createDigester());
        }
        catch (ParserConfigurationException e) {
            throw new JRException(e);
        }
        catch (SAXException e) {
            throw new JRException(e);
        }
        jasperDesign = xmlLoader.loadXML(is);
        return jasperDesign;
    }

    public JasperDesign loadXML(InputStream is) throws JRException {
        try {
            try {
                this.digester.push((Object)this);
                this.digester.parse(is);
            }
            catch (SAXException e) {
                throw new JRException(e);
            }
            catch (IOException e) {
                throw new JRException(e);
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            this.digester.clear();
            throw throwable;
        }
        this.digester.clear();
        if (this.errors.size() > 0) {
            Exception e = (Exception)this.errors.get(0);
            if (e instanceof JRException) {
                throw (JRException)e;
            }
            throw new JRException(e);
        }
        this.assignGroupsToVariables();
        this.assignGroupsToElements();
        this.assignGroupsToImages();
        this.assignGroupsToTextFields();
        return this.jasperDesign;
    }

    private void assignGroupsToVariables() throws JRException {
        JRVariable[] variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            Map groupsMap = this.jasperDesign.getGroupsMap();
            JRDesignVariable variable = null;
            String groupName = null;
            JRGroup group = null;
            int i = 0;
            while (i < variables.length) {
                variable = (JRDesignVariable)variables[i];
                if (variable.getResetType() == 4) {
                    groupName = null;
                    group = variable.getResetGroup();
                    if (group != null) {
                        groupName = group.getName();
                        group = (JRGroup)groupsMap.get(groupName);
                    }
                    if (group == null) {
                        throw new JRException("Unknown reset group '" + groupName + "' for variable : " + variable.getName());
                    }
                    variable.setResetGroup(group);
                } else {
                    variable.setResetGroup(null);
                }
                ++i;
            }
        }
    }

    private void assignGroupsToElements() throws JRException {
        Map groupsMap = this.jasperDesign.getGroupsMap();
        JRDesignElement element = null;
        String groupName = null;
        JRGroup group = null;
        Iterator it = this.groupReprintedElements.iterator();
        while (it.hasNext()) {
            element = (JRDesignElement)it.next();
            groupName = null;
            group = element.getPrintWhenGroupChanges();
            if (group != null) {
                groupName = group.getName();
                group = (JRGroup)groupsMap.get(group.getName());
            }
            if (group == null) {
                throw new JRException("Unknown reprint group '" + groupName + "' for element.");
            }
            element.setPrintWhenGroupChanges(group);
        }
    }

    private void assignGroupsToImages() throws JRException {
        Map groupsMap = this.jasperDesign.getGroupsMap();
        JRDesignImage image = null;
        String groupName = null;
        JRGroup group = null;
        Iterator it = this.groupEvaluatedImages.iterator();
        while (it.hasNext()) {
            image = (JRDesignImage)it.next();
            groupName = null;
            group = image.getEvaluationGroup();
            if (group != null) {
                groupName = group.getName();
                group = (JRGroup)groupsMap.get(group.getName());
            }
            if (group == null) {
                throw new JRException("Unknown evaluation group '" + groupName + "' for image.");
            }
            image.setEvaluationGroup(group);
        }
    }

    private void assignGroupsToTextFields() throws JRException {
        Map groupsMap = this.jasperDesign.getGroupsMap();
        JRDesignTextField textField = null;
        String groupName = null;
        JRGroup group = null;
        Iterator it = this.groupEvaluatedTextFields.iterator();
        while (it.hasNext()) {
            textField = (JRDesignTextField)it.next();
            groupName = null;
            group = textField.getEvaluationGroup();
            if (group != null) {
                groupName = group.getName();
                group = (JRGroup)groupsMap.get(group.getName());
            }
            if (group == null) {
                throw new JRException("Unknown evaluation group '" + groupName + "' for text field.");
            }
            textField.setEvaluationGroup(group);
        }
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }
}

