/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.util;

import dori.jasper.engine.JRRuntimeException;
import dori.jasper.engine.util.JRStyledText;
import dori.jasper.engine.util.JRTextAttribute;
import dori.jasper.engine.xml.JRXmlConstants;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRStyledTextParser {
    private static final String ROOT_START = "<st>";
    private static final String ROOT_END = "</st>";
    private static final String NODE_style = "style";
    private static final String ATTRIBUTE_fontName = "fontName";
    private static final String ATTRIBUTE_size = "size";
    private static final String ATTRIBUTE_isBold = "isBold";
    private static final String ATTRIBUTE_isItalic = "isItalic";
    private static final String ATTRIBUTE_isUnderline = "isUnderline";
    private static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    private static final String ATTRIBUTE_forecolor = "forecolor";
    private static final String ATTRIBUTE_backcolor = "backcolor";
    private static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    private static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    private static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";
    private static final String SPACE = " ";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private static final String SHARP = "#";
    private static final String LESS = "<";
    private static final String LESS_SLASH = "</";
    private static final String GREATER = ">";
    private static final String SIX_ZEROS = "000000";
    private static final int colorMask = Integer.parseInt("FFFFFF", 16);
    private DocumentBuilder documentBuilder = null;

    public JRStyledTextParser() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JRRuntimeException(e);
        }
    }

    public JRStyledText parse(Map attributes, String text) throws SAXException {
        JRStyledText styledText = new JRStyledText();
        Document document = null;
        try {
            document = this.documentBuilder.parse(new InputSource(new StringReader(ROOT_START + text + ROOT_END)));
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        this.parseStyle(styledText, document.getDocumentElement());
        styledText.addRun(new JRStyledText.Run(attributes, 0, styledText.length()));
        return styledText;
    }

    public String write(Map parentAttrs, AttributedCharacterIterator iterator, String text) {
        StringBuffer sbuffer = new StringBuffer();
        int runLimit = 0;
        while (runLimit < iterator.getEndIndex() && (runLimit = iterator.getRunLimit()) <= iterator.getEndIndex()) {
            String chunk = text.substring(iterator.getIndex(), runLimit);
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
            StringBuffer styleBuffer = this.writeStyleAttributes(parentAttrs, attrs);
            if (styleBuffer.length() > 0) {
                sbuffer.append(LESS);
                sbuffer.append(NODE_style);
                sbuffer.append(styleBuffer);
                sbuffer.append(GREATER);
                sbuffer.append(chunk);
                sbuffer.append(LESS_SLASH);
                sbuffer.append(NODE_style);
                sbuffer.append(GREATER);
            } else {
                sbuffer.append(chunk);
            }
            iterator.setIndex(runLimit);
        }
        return sbuffer.toString();
    }

    private void parseStyle(JRStyledText styledText, Node parentNode) {
        NodeList nodeList = parentNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                styledText.append(node.getNodeValue());
            } else if (node.getNodeType() == 1 && NODE_style.equals(node.getNodeName())) {
                char firstChar;
                String colorStr;
                Color color;
                NamedNodeMap nodeAttrs = node.getAttributes();
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontName) != null) {
                    styleAttrs.put(TextAttribute.FAMILY, nodeAttrs.getNamedItem(ATTRIBUTE_fontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isBold) != null) {
                    styleAttrs.put(TextAttribute.WEIGHT, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isBold).getNodeValue()) != false ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isItalic) != null) {
                    styleAttrs.put(TextAttribute.POSTURE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isItalic).getNodeValue()) != false ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline) != null) {
                    styleAttrs.put(TextAttribute.UNDERLINE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline).getNodeValue()) != false ? TextAttribute.UNDERLINE_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough) != null) {
                    styleAttrs.put(TextAttribute.STRIKETHROUGH, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough).getNodeValue()) != false ? TextAttribute.STRIKETHROUGH_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    styleAttrs.put(TextAttribute.SIZE, new Float(nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_FONT_NAME, nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_ENCODING, nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded) != null) {
                    styleAttrs.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_forecolor) != null) {
                    color = null;
                    colorStr = nodeAttrs.getNamedItem(ATTRIBUTE_forecolor).getNodeValue();
                    if (colorStr != null && colorStr.length() > 0) {
                        firstChar = colorStr.charAt(0);
                        color = firstChar == '#' ? new Color(Integer.parseInt(colorStr.substring(1), 16)) : ('0' <= firstChar && firstChar <= '9' ? new Color(Integer.parseInt(colorStr)) : (JRXmlConstants.getColorMap().containsKey(colorStr) ? (Color)JRXmlConstants.getColorMap().get(colorStr) : Color.black));
                    }
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_backcolor) != null) {
                    color = null;
                    colorStr = nodeAttrs.getNamedItem(ATTRIBUTE_backcolor).getNodeValue();
                    if (colorStr != null && colorStr.length() > 0) {
                        firstChar = colorStr.charAt(0);
                        color = firstChar == '#' ? new Color(Integer.parseInt(colorStr.substring(1), 16)) : ('0' <= firstChar && firstChar <= '9' ? new Color(Integer.parseInt(colorStr)) : (JRXmlConstants.getColorMap().containsKey(colorStr) ? (Color)JRXmlConstants.getColorMap().get(colorStr) : Color.black));
                    }
                    styleAttrs.put(TextAttribute.BACKGROUND, color);
                }
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
            }
            ++i;
        }
    }

    private StringBuffer writeStyleAttributes(Map parentAttrs, Map attrs) {
        String hexa;
        StringBuffer sbuffer = new StringBuffer();
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_fontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isBold);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.WEIGHT_BOLD));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isItalic);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.POSTURE_OBLIQUE));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isUnderline);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isStrikeThrough);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_size);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(((Float)value).intValue());
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_FONT_NAME);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_FONT_NAME);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfFontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_ENCODING);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_ENCODING);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfEncoding);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        oldValue = parentAttrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isPdfEmbedded);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_forecolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            hexa = Integer.toHexString(((Color)value).getRGB() & colorMask).toUpperCase();
            sbuffer.append(SIX_ZEROS + hexa).substring(hexa.length());
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.BACKGROUND);
        oldValue = parentAttrs.get(TextAttribute.BACKGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_backcolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            hexa = Integer.toHexString(((Color)value).getRGB() & colorMask).toUpperCase();
            sbuffer.append(SIX_ZEROS + hexa).substring(hexa.length());
            sbuffer.append(QUOTE);
        }
        return sbuffer;
    }
}

