/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.fill.JRComparableIncrementerFactory;
import dori.jasper.engine.fill.JRDefaultIncrementerFactory;
import dori.jasper.engine.fill.JRIncrementer;
import dori.jasper.engine.fill.JRIncrementerFactory;
import dori.jasper.engine.fill.JRShortAverageIncrementer;
import dori.jasper.engine.fill.JRShortCountIncrementer;
import dori.jasper.engine.fill.JRShortStandardDeviationIncrementer;
import dori.jasper.engine.fill.JRShortSumIncrementer;
import dori.jasper.engine.fill.JRShortVarianceIncrementer;

public class JRShortIncrementerFactory
implements JRIncrementerFactory {
    protected static final Short ZERO = new Short(0);
    private static JRShortIncrementerFactory mainInstance = new JRShortIncrementerFactory();

    private JRShortIncrementerFactory() {
    }

    public static JRShortIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRShortCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRShortSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRShortAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRShortStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRShortVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

