/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.fill.JRBigDecimalAverageIncrementer;
import dori.jasper.engine.fill.JRBigDecimalCountIncrementer;
import dori.jasper.engine.fill.JRBigDecimalStandardDeviationIncrementer;
import dori.jasper.engine.fill.JRBigDecimalSumIncrementer;
import dori.jasper.engine.fill.JRBigDecimalVarianceIncrementer;
import dori.jasper.engine.fill.JRComparableIncrementerFactory;
import dori.jasper.engine.fill.JRDefaultIncrementerFactory;
import dori.jasper.engine.fill.JRIncrementer;
import dori.jasper.engine.fill.JRIncrementerFactory;
import java.math.BigDecimal;

public class JRBigDecimalIncrementerFactory
implements JRIncrementerFactory {
    protected static final BigDecimal ZERO = new BigDecimal(0.0);
    protected static final BigDecimal ONE = new BigDecimal(1.0);
    private static JRBigDecimalIncrementerFactory mainInstance = new JRBigDecimalIncrementerFactory();

    private JRBigDecimalIncrementerFactory() {
    }

    public static JRBigDecimalIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRBigDecimalCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRBigDecimalSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRBigDecimalAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRBigDecimalStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRBigDecimalVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

