/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.about;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jfree.ui.SortableTableModel;
import org.jfree.ui.about.SystemProperty;
import org.jfree.ui.about.SystemPropertyComparator;

public class SystemPropertiesTableModel
extends SortableTableModel {
    private List properties = new ArrayList();
    private String nameColumnLabel;
    private String valueColumnLabel;

    public SystemPropertiesTableModel() {
        Properties p = System.getProperties();
        Iterator<Object> iterator = p.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = System.getProperty(name);
            SystemProperty sp = new SystemProperty(name, value);
            this.properties.add(sp);
        }
        Collections.sort(this.properties, new SystemPropertyComparator(true));
        String baseName = "org.jfree.ui.about.resources.AboutResources";
        ResourceBundle resources = ResourceBundle.getBundle(baseName);
        this.nameColumnLabel = resources.getString("system-properties-table.column.name");
        this.valueColumnLabel = resources.getString("system-properties-table.column.value");
    }

    public boolean isSortable(int column) {
        return column == 0;
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return this.nameColumnLabel;
        }
        return this.valueColumnLabel;
    }

    public Object getValueAt(int row, int column) {
        SystemProperty sp = (SystemProperty)this.properties.get(row);
        if (column == 0) {
            return sp.getName();
        }
        if (column == 1) {
            return sp.getValue();
        }
        return null;
    }

    public void sortByColumn(int column, boolean ascending) {
        if (this.isSortable(column)) {
            super.sortByColumn(column, ascending);
            Collections.sort(this.properties, new SystemPropertyComparator(ascending));
        }
    }
}

