/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.MatrixSeries;
import org.jfree.data.XYZDataset;
import org.jfree.util.ObjectUtils;

public class MatrixSeriesCollection
extends AbstractSeriesDataset
implements XYZDataset,
Serializable {
    private List m_data = new ArrayList();

    public MatrixSeriesCollection() {
        this(null);
    }

    public MatrixSeriesCollection(MatrixSeries series) {
        if (series != null) {
            this.m_data.add(series);
            series.addChangeListener(this);
        }
    }

    public int getItemCount(int seriesIndex) {
        return this.getSeries(seriesIndex).getItemCount();
    }

    public MatrixSeries getSeries(int seriesIndex) {
        if (seriesIndex < 0 || seriesIndex > this.getSeriesCount()) {
            throw new IllegalArgumentException("MatrixSeriesCollection.getSeries(...): index outside valid range.");
        }
        MatrixSeries series = (MatrixSeries)this.m_data.get(seriesIndex);
        return series;
    }

    public int getSeriesCount() {
        return this.m_data.size();
    }

    public String getSeriesName(int seriesIndex) {
        return this.getSeries(seriesIndex).getName();
    }

    public Number getXValue(int seriesIndex, int itemIndex) {
        MatrixSeries series = (MatrixSeries)this.m_data.get(seriesIndex);
        int x = series.getItemColumn(itemIndex);
        return new Integer(x);
    }

    public Number getYValue(int seriesIndex, int itemIndex) {
        MatrixSeries series = (MatrixSeries)this.m_data.get(seriesIndex);
        int y = series.getItemRow(itemIndex);
        return new Integer(y);
    }

    public Number getZValue(int seriesIndex, int itemIndex) {
        MatrixSeries series = (MatrixSeries)this.m_data.get(seriesIndex);
        Number z = series.getItem(itemIndex);
        return z;
    }

    public void addSeries(MatrixSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("MatrixSeriesCollection.addSeries(...): cannot add null series.");
        }
        this.m_data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MatrixSeriesCollection) {
            MatrixSeriesCollection c = (MatrixSeriesCollection)obj;
            return ObjectUtils.equal((Object)this.m_data, (Object)c.m_data);
        }
        return false;
    }

    public int hashCode() {
        return this.m_data != null ? ((Object)this.m_data).hashCode() : 0;
    }

    public void removeAllSeries() {
        for (int i = 0; i < this.m_data.size(); ++i) {
            MatrixSeries series = (MatrixSeries)this.m_data.get(i);
            series.removeChangeListener(this);
        }
        this.m_data.clear();
        this.fireDatasetChanged();
    }

    public void removeSeries(MatrixSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("MatrixSeriesCollection.removeSeries(...): cannot remove null series.");
        }
        if (this.m_data.contains(series)) {
            series.removeChangeListener(this);
            this.m_data.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeSeries(int seriesIndex) {
        if (seriesIndex < 0 || seriesIndex > this.getSeriesCount()) {
            throw new IllegalArgumentException("MatrixSeriesCollection.removeSeries(...): index outside valid range.");
        }
        MatrixSeries series = (MatrixSeries)this.m_data.get(seriesIndex);
        series.removeChangeListener(this);
        this.m_data.remove(seriesIndex);
        this.fireDatasetChanged();
    }
}

