/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.util.ObjectUtils;

public class StandardCategoryURLGenerator
implements CategoryURLGenerator,
Cloneable,
Serializable {
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";

    public StandardCategoryURLGenerator() {
    }

    public StandardCategoryURLGenerator(String prefix) {
        this.prefix = prefix;
    }

    public StandardCategoryURLGenerator(String prefix, String seriesParameterName, String categoryParameterName) {
        this.prefix = prefix;
        this.seriesParameterName = seriesParameterName;
        this.categoryParameterName = categoryParameterName;
    }

    public String generateURL(CategoryDataset data, int series, int category) {
        String url = this.prefix;
        Comparable seriesKey = data.getRowKey(series);
        Comparable categoryKey = data.getColumnKey(category);
        boolean firstParameter = url.indexOf("?") == -1;
        url = url + (firstParameter ? "?" : "&");
        url = url + this.seriesParameterName + "=" + seriesKey.toString();
        url = url + "&" + this.categoryParameterName + "=" + categoryKey.toString();
        return url;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardCategoryURLGenerator)) {
            return false;
        }
        StandardCategoryURLGenerator generator = (StandardCategoryURLGenerator)o;
        if (!ObjectUtils.equal((Object)this.prefix, (Object)generator.prefix)) {
            return false;
        }
        if (!ObjectUtils.equal((Object)this.seriesParameterName, (Object)generator.seriesParameterName)) {
            return false;
        }
        return ObjectUtils.equal((Object)this.categoryParameterName, (Object)generator.categoryParameterName);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 29 * result + (this.seriesParameterName != null ? this.seriesParameterName.hashCode() : 0);
        result = 29 * result + (this.categoryParameterName != null ? this.categoryParameterName.hashCode() : 0);
        return result;
    }
}

