/*
 * Unit.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 8 febbraio 2003, 17.53
 */

package it.businesslogic.ireport.util;

/**
 *
 * @author  Administrator
 */
public class Unit {
    
    public static final double PIXEL = 1.0;
    public static final double INCHES = 72.0;
    public static final double CENTIMETERS = 28.3464;
    public static final double MILLIMETERS = 2.83464;
        
    /** Holds value of property unitName. */
    private String unitName;
    
    /** Holds value of property conversionValue. */
    private double conversionValue;
    
    /** Creates a new instance of Unit */
    public Unit(String unitName, double conversionValue) {
        this.unitName = unitName;
        this.conversionValue = conversionValue;
    }
    
    /** Getter for property unitName.
     * @return Value of property unitName.
     *
     */
    public String getUnitName() {
        return this.unitName;
    }
    
    /** Setter for property unitName.
     * @param unitName New value of property unitName.
     *
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    
    /** Getter for property conversionValue.
     * @return Value of property conversionValue.
     *
     */
    public double getConversionValue() {
        return this.conversionValue;
    }
    
    /** Setter for property conversionValue.
     * @param conversionValue New value of property conversionValue.
     *
     */
    public void setConversionValue(double conversionValue) {
        this.conversionValue = conversionValue;
    }
    
    public static Unit[] getStandardUnits()
    {
        Unit[] units = new Unit[4];
        
        units[0] = new Unit("pixels",Unit.PIXEL);
        units[1] = new Unit("inches",Unit.INCHES);
        units[2] = new Unit("cm",    Unit.CENTIMETERS);
        units[3] = new Unit("mm",    Unit.MILLIMETERS);
        
        return units;
    }
    
    public String toString()
    {
        return getUnitName();
    }
    
    static public double convertPixelsToInches(long pixels)
	{
		return ((double)pixels)/INCHES;
	}
	
	static public long convertInchesToPixels(double inches)
	{
		return (long)(inches*INCHES);
	}
	
	static public double convertPixelsToCentimeters(long pixels)
	{
		return ((double)pixels)/CENTIMETERS;
	}
	
	static public long convertCentimetersToPixels(double centimeters)
	{
		return (long)(centimeters*CENTIMETERS);
	}
	
	static public double convertPixelsToMillimeters(long pixels)
	{
		return ((double)pixels)/MILLIMETERS;
	}
	
	static public long convertMillimetersToPixels(double millimeters)
	{
		return (long)(millimeters*CENTIMETERS);
	}
	
	static public long convertToPixels(double value, double convert)
	{
		return (long)(value*convert);
	}
}
