/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;

import java.util.*;
/**
 *
 * @author  Administrator
 */
public class JRFontDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    private IReportFont iReportFont = null;
    public JRFontDialog(java.awt.Frame parent, boolean modal) {
        
        super(parent, modal);
        initComponents();
        this.setSize(320, 344);
        Misc.centerFrame(this);
        
        jNumberComboBoxSize.addEntry("3",3);
        jNumberComboBoxSize.addEntry("5",5);
        jNumberComboBoxSize.addEntry("8",8);
        jNumberComboBoxSize.addEntry("10",10);
        jNumberComboBoxSize.addEntry("12",12);
        jNumberComboBoxSize.addEntry("14",14);
        jNumberComboBoxSize.addEntry("18",18);
        jNumberComboBoxSize.addEntry("24",24);
        jNumberComboBoxSize.addEntry("36",36);
        jNumberComboBoxSize.addEntry("48",48);
        
        jNumberComboBoxSize.setSelectedIndex(3);
        
        // Image Horizontal Alignments...
        jComboBoxPDFFontName.addItem("Helvetica");
        jComboBoxPDFFontName.addItem("Helvetica-Bold");
        jComboBoxPDFFontName.addItem("Helvetica-BoldOblique");
        jComboBoxPDFFontName.addItem("Helvetica-Oblique");
        jComboBoxPDFFontName.addItem("Courier");
        jComboBoxPDFFontName.addItem("Courier-Bold");
        jComboBoxPDFFontName.addItem("Courier-BoldOblique");
        jComboBoxPDFFontName.addItem("Courier-Oblique");
        jComboBoxPDFFontName.addItem("Symbol");
        jComboBoxPDFFontName.addItem("Times-Roman");
        jComboBoxPDFFontName.addItem("Times-Bold");
        jComboBoxPDFFontName.addItem("Times-BoldItalic");
        jComboBoxPDFFontName.addItem("Times-Italic");
        jComboBoxPDFFontName.addItem("ZapfDingbats");
        jComboBoxPDFFontName.addItem("STSong-Light");
        jComboBoxPDFFontName.addItem("MHei-Medium");
        jComboBoxPDFFontName.addItem("MSung-Light");
        jComboBoxPDFFontName.addItem("HeiseiKakuGo-W5");
        jComboBoxPDFFontName.addItem("HeiseiMin-W3");
        jComboBoxPDFFontName.addItem("HYGoThic-Medium");
        jComboBoxPDFFontName.addItem("HYSMyeongJo-Medium");
        jComboBoxPDFFontName.addItem("External TTF font...");
        
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1250","CP1250 (Central European)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1251","CP1251 (Cyrillic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1252","CP1252 (Western European ANSI aka WinAnsi)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1253","CP1253 (Greek)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1254","CP1254 (Turkish)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1255","CP1255 (Hebrew)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1256","CP1256 (Arabic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1257","CP1257 (Baltic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1258","CP1258 (Vietnamese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-H","UniGB-UCS2-H (Chinese Simplified)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-V","UniGB-UCS2-V (Chinese Simplified)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-H","UniCNS-UCS2-H (Chinese traditional)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-V","UniCNS-UCS2-V (Chinese traditional)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-H","UniJIS-UCS2-H (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-V","UniJIS-UCS2-V (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-H","UniJIS-UCS2-HW-H (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-V","UniJIS-UCS2-HW-V (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-H","UniKS-UCS2-H (Korean)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-V","UniKS-UCS2-V (Korean)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-H","Identity-H (Unicode with horizontal writing)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-V","Identity-V (Unicode with vertical writing)"));
        
        // Load Fonts...
        String[] fontFamilies = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i=0; i<fontFamilies.length; ++i)
        {
            jComboBoxFontName.addItem(fontFamilies[i]); 
        }
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jButtonCancel = new javax.swing.JButton();
        jButtonOK = new javax.swing.JButton();
        jPanelFont = new javax.swing.JPanel();
        jLabel23 = new javax.swing.JLabel();
        jComboBoxPDFFontName = new javax.swing.JComboBox();
        jLabel24 = new javax.swing.JLabel();
        jLabel25 = new javax.swing.JLabel();
        jComboBoxFontName = new javax.swing.JComboBox();
        jNumberComboBoxSize = new it.businesslogic.ireport.gui.JNumberComboBox();
        jLabel27 = new javax.swing.JLabel();
        jLabelTTF = new javax.swing.JLabel();
        jComboBoxTTFFont = new javax.swing.JComboBox();
        jCheckBoxBold = new javax.swing.JCheckBox();
        jCheckBoxItalic = new javax.swing.JCheckBox();
        jCheckBoxUnderline = new javax.swing.JCheckBox();
        jCheckBoxStrokeTrough = new javax.swing.JCheckBox();
        jSeparator2 = new javax.swing.JSeparator();
        jCheckBoxPDFEmbedded = new javax.swing.JCheckBox();
        jComboBoxPdfEncoding = new javax.swing.JComboBox();
        jLabel32 = new javax.swing.JLabel();
        jTextFieldReportFont = new javax.swing.JTextField();
        jSeparator3 = new javax.swing.JSeparator();

        getContentPane().setLayout(null);

        setTitle("Add/modify parameter");
        setModal(true);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        getContentPane().add(jButtonCancel);
        jButtonCancel.setBounds(232, 274, 70, 25);

        jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        getContentPane().add(jButtonOK);
        jButtonOK.setBounds(152, 274, 70, 25);

        jPanelFont.setLayout(null);

        jLabel23.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel23.setText("Report font");
        jPanelFont.add(jLabel23);
        jLabel23.setBounds(8, 8, 142, 15);

        jComboBoxPDFFontName.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelFont.add(jComboBoxPDFFontName);
        jComboBoxPDFFontName.setBounds(6, 106, 300, 22);

        jLabel24.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel24.setText("Font name");
        jPanelFont.add(jLabel24);
        jLabel24.setBounds(8, 48, 220, 15);

        jLabel25.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel25.setText("PDF font name");
        jPanelFont.add(jLabel25);
        jLabel25.setBounds(8, 90, 74, 15);

        jComboBoxFontName.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelFont.add(jComboBoxFontName);
        jComboBoxFontName.setBounds(6, 64, 232, 22);

        jNumberComboBoxSize.setFont(new java.awt.Font("Dialog", 0, 12));
        jPanelFont.add(jNumberComboBoxSize);
        jNumberComboBoxSize.setBounds(242, 64, 62, 22);

        jLabel27.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel27.setText("Size");
        jPanelFont.add(jLabel27);
        jLabel27.setBounds(242, 48, 60, 15);

        jLabelTTF.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelTTF.setText("TrueType font");
        jLabelTTF.setEnabled(false);
        jPanelFont.add(jLabelTTF);
        jLabelTTF.setBounds(8, 134, 142, 15);

        jComboBoxTTFFont.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTTFFont.setEnabled(false);
        jPanelFont.add(jComboBoxTTFFont);
        jComboBoxTTFFont.setBounds(6, 150, 298, 22);

        jCheckBoxBold.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxBold.setText("Bold");
        jPanelFont.add(jCheckBoxBold);
        jCheckBoxBold.setBounds(8, 172, 100, 23);

        jCheckBoxItalic.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxItalic.setText("Italic");
        jPanelFont.add(jCheckBoxItalic);
        jCheckBoxItalic.setBounds(8, 192, 100, 23);

        jCheckBoxUnderline.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxUnderline.setText("Underline");
        jPanelFont.add(jCheckBoxUnderline);
        jCheckBoxUnderline.setBounds(120, 172, 100, 23);

        jCheckBoxStrokeTrough.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStrokeTrough.setText("Strike Trough");
        jPanelFont.add(jCheckBoxStrokeTrough);
        jCheckBoxStrokeTrough.setBounds(120, 192, 100, 23);

        jPanelFont.add(jSeparator2);
        jSeparator2.setBounds(8, 220, 294, 4);

        jCheckBoxPDFEmbedded.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPDFEmbedded.setText("PDF Embedded");
        jPanelFont.add(jCheckBoxPDFEmbedded);
        jCheckBoxPDFEmbedded.setBounds(8, 222, 100, 23);

        jComboBoxPdfEncoding.setEditable(true);
        jComboBoxPdfEncoding.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelFont.add(jComboBoxPdfEncoding);
        jComboBoxPdfEncoding.setBounds(126, 238, 178, 22);

        jLabel32.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel32.setText("PDF Encoding");
        jPanelFont.add(jLabel32);
        jLabel32.setBounds(126, 222, 110, 15);

        jPanelFont.add(jTextFieldReportFont);
        jTextFieldReportFont.setBounds(6, 24, 298, 20);

        getContentPane().add(jPanelFont);
        jPanelFont.setBounds(0, 0, 312, 264);

        getContentPane().add(jSeparator3);
        jSeparator3.setBounds(8, 266, 294, 2);

        pack();
    }//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        
        if (this.jTextFieldReportFont.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid report font name!","Invalid report font name!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        iReportFont = new IReportFont();
        iReportFont.setReportFont( this.jTextFieldReportFont.getText() );
        iReportFont.setBold( this.jCheckBoxBold.isSelected());
        iReportFont.setDefaultFont(false);
        iReportFont.setFontName(""+ this.jComboBoxFontName.getSelectedItem());
        iReportFont.setFontSize( (int)jNumberComboBoxSize.getValue());
        iReportFont.setItalic( this.jCheckBoxItalic.isSelected());        
        iReportFont.setPDFFontName( this.jComboBoxFontName.getSelectedItem()+"");
        
        //if (Misc.nvl( this.jComboBoxFontName.getSelectedItem(),"").indexOf("TTF") != 0)
        //{
        //    iReportFont.setPDFFontName( this.jComboBoxTTFFont.getSelectedItem()+"");
        //}
        iReportFont.setPDFFontName(this.jComboBoxPDFFontName.getSelectedItem()+"");
        
        
        iReportFont.setPdfEmbedded( this.jCheckBoxPDFEmbedded.isSelected());
        if (this.jComboBoxPdfEncoding.getSelectedItem() instanceof PdfEncoding)
            iReportFont.setPdfEncoding( ((PdfEncoding)this.jComboBoxPdfEncoding.getSelectedItem()).getEncoding());
        else
            iReportFont.setPdfEncoding( Misc.nvl(this.jComboBoxPdfEncoding.getSelectedItem(),"CP1251"));
        
        iReportFont.setStrikeTrought( this.jCheckBoxStrokeTrough.isSelected());
        iReportFont.setTTFFont( Misc.nvl(this.jComboBoxTTFFont.getSelectedItem(),"") );
        iReportFont.setUnderline( this.jCheckBoxUnderline.isSelected());
        /*
        tmpParameter = new JRParameter( this.jTextFieldName.getText(), "java.lang.String",
                                        this.jCheckBoxIsForPrompting.isSelected(),
                                        this.jTextAreaDescription.getText());
        if (this.jComboBoxType.getSelectedItem().toString().trim().length() != 0)
        {
            tmpParameter.setClassType( this.jComboBoxType.getSelectedItem().toString().trim() );
        }
        tmpParameter.setDefaultValueExpression( jRTextExpressionAreaDefaultExpression.getText());
*/
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new JRParameterDialog(new javax.swing.JFrame(), true).show();
    }
    
      
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property iReportFont.
     * @return Value of property iReportFont.
     *
     */
    public it.businesslogic.ireport.IReportFont getIReportFont() {
        return iReportFont;
    }
    
    /** Setter for property iReportFont.
     * @param iReportFont New value of property iReportFont.
     *
     */
    public void setIReportFont(it.businesslogic.ireport.IReportFont iReportFont) {
       
        this.jTextFieldReportFont.setText( new String(iReportFont.getReportFont()) );
        /* 
        jComboBoxFontName. ;
                        if (sameFontName) sameFontName = setComboBoxText(isTheFirstElement, tre.getFontName() , jComboBoxFontName);
                        if (samePDFFontName) 
                        {
                            if (tre.getPDFFontName().toUpperCase().endsWith(".TTF"))
                                samePDFFontName = this.setComboBoxText(isTheFirstElement, "External TTF font..." , jComboBoxPDFFontName );
                            else
                                samePDFFontName = this.setComboBoxText(isTheFirstElement, tre.getPDFFontName() , jComboBoxPDFFontName );
                        }
                        if (sameFontSize) sameFontSize = this.setElementComboNumber(isTheFirstElement, tre.getFontSize() , jNumberComboBoxSize );
                        if (sameIsBold) sameIsBold = this.setCheckBox(isTheFirstElement, tre.isBold(), jCheckBoxBold );
                        if (sameIsItalic) sameIsItalic = this.setCheckBox(isTheFirstElement, tre.isItalic(), jCheckBoxItalic );
                        if (sameIsUnderline) sameIsUnderline = this.setCheckBox(isTheFirstElement, tre.isUnderline(), jCheckBoxUnderline );
                        if (sameIsStrokeTrough) sameIsStrokeTrough = this.setCheckBox(isTheFirstElement, tre.isStrikeTrought(),  jCheckBoxStrokeTrough );
                        if (sameTextVAlign) sameTextVAlign = this.setComboBoxText(isTheFirstElement, tre.getVerticalAlign(), jComboBoxVAlign );
                        if (sameTextHAlign) sameTextHAlign = this.setComboBoxText(isTheFirstElement, tre.getAlign() , jComboBoxHAlign );
                        if (sameTextLineSpacing) sameTextHAlign = this.setComboBoxText(isTheFirstElement, tre.getLineSpacing() , jComboBoxLineSpacing );
                        if (sameIsPdfEmbedded) sameIsPdfEmbedded = this.setCheckBox(isTheFirstElement, tre.isPdfEmbedded(),  jCheckBoxPDFEmbedded );
                        if (samePdfEncoding) samePdfEncoding = this.setPdfEncodingComboBox(isTheFirstElement, tre.getPdfEncoding() , jComboBoxPdfEncoding );

                        if (samePDFFontName && tre.getPDFFontName().toUpperCase().endsWith(".TTF"))
                        {
                            jComboBoxTTFFont.setEnabled(true);
                            jLabelTTF.setEnabled(true);
                            if (sameTTFFont)  this.setFontComboBox(isTheFirstElement, tre.getPDFFontName() , jComboBoxTTFFont );
                        }
                        else
                        {
                            jComboBoxTTFFont.setEnabled(false);
                            jLabelTTF.setEnabled(false);
                        }
         */
    }
    
     public void updateFonts(Vector iRFonts)
    {

        Misc.updateComboBox( jComboBoxTTFFont, iRFonts, false);

    } 
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JComboBox jComboBoxTTFFont;
    private javax.swing.JCheckBox jCheckBoxPDFEmbedded;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JLabel jLabelTTF;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel24;
    private it.businesslogic.ireport.gui.JNumberComboBox jNumberComboBoxSize;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JCheckBox jCheckBoxBold;
    private javax.swing.JTextField jTextFieldReportFont;
    private javax.swing.JCheckBox jCheckBoxUnderline;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JCheckBox jCheckBoxStrokeTrough;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JComboBox jComboBoxPdfEncoding;
    private javax.swing.JComboBox jComboBoxPDFFontName;
    private javax.swing.JPanel jPanelFont;
    private javax.swing.JCheckBox jCheckBoxItalic;
    private javax.swing.JComboBox jComboBoxFontName;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JSeparator jSeparator3;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
}
