/*
 * JMDIFrame.java
 *
 *
 **  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 6 febbraio 2003, 0.31
 */

package it.businesslogic.ireport.gui;
import javax.swing.*;
/**
 * JMDIFrame is an evolution of the very trivial javax.swing.JInternalFrame.
 * This class implements an MDI window handling similar to Win32, with 
 * the maximized frame really maximized (without the title bar, and with the
 * minimize, maximize and close buttons on menu bar, that must be a JMDIMenuBar)
 *
 * @author  Administrator
 */
public class JMDIFrame extends javax.swing.JInternalFrame {
    
    javax.swing.border.Border borderNormal = null;
    javax.swing.JComponent northPane = null;
    java.awt.Rectangle northPaneBounds = null;
    it.businesslogic.ireport.gui.JMDIMenuBar menu = null;
    
    private boolean borderNone  = false;
    /** Creates new form JMDIFrame */
    public JMDIFrame() {
        initComponents();
        
        northPane = ((javax.swing.plaf.basic.BasicInternalFrameUI) this.getUI()).getNorthPane();
        northPaneBounds = northPane.getBounds();
        setNormalSize( this.getPreferredSize());
        borderNone  = false;
        jPanel1.setBackground(new java.awt.Color((int)( Math.random()* 0xffffff)));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel1 = new javax.swing.JPanel();

        setClosable(true);
        setIconifiable(true);
        setMaximizable(true);
        setResizable(true);
        setTitle("JMDIFrame");
        setPreferredSize(new java.awt.Dimension(400, 400));
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });

        addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {
            public void ancestorMoved(java.awt.event.HierarchyEvent evt) {
            }
            public void ancestorResized(java.awt.event.HierarchyEvent evt) {
                formAncestorResized(evt);
            }
        });

        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosing(evt);
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosed(evt);
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameActivated(evt);
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
        });

        addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                formPropertyChange(evt);
            }
        });

        jPanel1.setBackground(new java.awt.Color(255, 204, 204));
        jPanel1.addHierarchyBoundsListener(new java.awt.event.HierarchyBoundsListener() {
            public void ancestorMoved(java.awt.event.HierarchyEvent evt) {
            }
            public void ancestorResized(java.awt.event.HierarchyEvent evt) {
                jPanel1AncestorResized(evt);
            }
        });

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void formInternalFrameClosing(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosing
        // If there is no more frames, reset menu buttons...
       // javax.swing.JOptionPane.showMessageDialog(this,"Frames: "+this.getDesktopPane().getAllFrames().length);
       // if (this.getDesktopPane().getAllFrames().length  == 1)
       // {
       //     try {
       //         this.setIcon(true);
       //     } catch (Exception ex) {}
            //if (menu != null) menu.removeFrameButtons();
       // }
         if ( this.getDesktopPane() instanceof JMDIDesktopPane)
        {
            ((JMDIDesktopPane)this.getDesktopPane()).internalFrameClosed(this);
        }

    }//GEN-LAST:event_formInternalFrameClosing

    private void formInternalFrameClosed(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosed

    }//GEN-LAST:event_formInternalFrameClosed

    private void jPanel1AncestorResized(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_jPanel1AncestorResized

         
    }//GEN-LAST:event_jPanel1AncestorResized

    private void formInternalFrameActivated(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameActivated
        // We must notify the JMDIDesktopPane...
        if ( this.getDesktopPane() instanceof JMDIDesktopPane)
        {
            ((JMDIDesktopPane)this.getDesktopPane()).internalFrameActivated(this);
        }
       
    }//GEN-LAST:event_formInternalFrameActivated

    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
       

    }//GEN-LAST:event_formComponentResized


    private void formPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_formPropertyChange
        // Add your handling code here
            if (evt.getPropertyName().equals("maximum"))
                        onMaximizeMinimize();
            else if (evt.getPropertyName().equals("selected"))
                        onSelect();
    }//GEN-LAST:event_formPropertyChange

    private void onMaximizeMinimize()
    {
         if (borderNormal == null)
         {
            borderNormal = this.getBorder();
         }
         
         //javax.swing.JOptionPane.showMessageDialog(this,"xx2");
        if ( this.isMaximum)
        {
            if (!borderNone)
            {                 
                 javax.swing.JInternalFrame[] jfs = this.getDesktopPane().getAllFrames();
                 for (int i=0; i<jfs.length; ++i)
                 {
                    if (jfs[i] != this)
                    {
                        try {
                            jfs[i].setMaximum(true);
                        } catch (Exception ex){}
                    }
                }
                 
                 try {
                    this.setSelected(true);
                 } catch (Exception ex){}
                 
                this.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets( 0,0,0,0 )));
                borderNone = true;
                ((javax.swing.plaf.basic.BasicInternalFrameUI)getUI()).getNorthPane().setPreferredSize( new java.awt.Dimension(0,0) ); 
                //System.out.println( ((javax.swing.plaf.basic.BasicInternalFrameUI)getUI()).getNorthPane() );
                
                //northPane = ((javax.swing.plaf.basic.BasicInternalFrameUI) this.getUI()).getNorthPane();
                //((javax.swing.plaf.basic.BasicInternalFrameUI) this.getUI()).setNorthPane( null );
                if (menu != null) menu.setMaximizedFrame(this);
            }
       }
        else if ( !this.isMaximum && borderNone)
        {
         
            System.out.println("Set maximum: "+this.getSize());
            setNormalSize( this.getSize() );
               
            // set not maximum all frames...
            javax.swing.JInternalFrame[] jfs = this.getDesktopPane().getAllFrames();
            for (int i=0; i<jfs.length; ++i)
            {
                if (jfs[i] != this)
                {
                    try {
                    jfs[i].setMaximum(false);
                    } catch (Exception ex){}
                }
            }
            
            borderNone = false;
            
            
            
            ((javax.swing.plaf.basic.BasicInternalFrameUI)getUI()).getNorthPane().setPreferredSize( new java.awt.Dimension(this.getNormalSize().width ,23) );
            setPreferredSize(this.getNormalSize());
            setSize(this.getNormalSize());
                      
             this.setBorder(borderNormal);
             if (menu != null) menu.setMaximizedFrame(null);
             //this.getDesktopPane().getDesktopManager().activateFrame(this);
             try {
             this.setSelected(true);
             } catch (Exception ex){};
        } 
    }
    
    
    /**
     *  This method set the activeForm to the menu. It is useful when the user 
     *  maximize windows and then close one. The frame that will activated will
     *  set activeForm in JMDIMenuBar class trought this method. 
     * 
     */
    private void onSelect()
    {
        if ( this.isMaximum)
        {
            if (menu != null) menu.setMaximizedFrame(this);
        }
        
    }
    
    
    private void formAncestorResized(java.awt.event.HierarchyEvent evt) {//GEN-FIRST:event_formAncestorResized

    }//GEN-LAST:event_formAncestorResized

    /** Getter for property menu.
     * @return Value of property menu.
     *
     */
    public it.businesslogic.ireport.gui.JMDIMenuBar getMenu() {
        return menu;
    }    
    
    /** Setter for property menu.
     *  We need a JMDIMenuBar to add, if needed, buttons to resize, close, minimize this
     * window when maximized.
     * @param menu New value of property menu.
     *
     */
    public void setMenu(it.businesslogic.ireport.gui.JMDIMenuBar menu) {
        this.menu = menu;
    }    
    
    /** Getter for property normalSize.
     * @return Value of property normalSize.
     *
     */
    public java.awt.Dimension getNormalSize() {
        return normalSize;
    }
    
    /** Setter for property normalSize.
     * @param normalSize New value of property normalSize.
     *
     */
    public void setNormalSize(java.awt.Dimension normalSize) {
        this.normalSize = normalSize;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    private java.awt.Dimension normalSize;    
    
}
