/*
 * TextFieldReportElement.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 24 maggio 2003, 10.22
 */

package it.businesslogic.ireport;

/**
 *
 * @author  Administrator
 */
public class TextFieldReportElement extends it.businesslogic.ireport.TextReportElement  implements HyperLinkableReportElement {
    
    private String classExpression;
    
    private String group;
    
    private String evaluationTime;
    
    private boolean blankWhenNull;
    
    private boolean stretchWithOverflow;
    
    private String pattern;
    
    private String anchorNameExpression = "";
    
    private String hyperlinkAnchorExpression = "";
    
    private String hyperlinkPageExpression = "";
    
    private String hyperlinkReferenceExpression = "";
    
    private String hyperlinkType = "None";
    
    /** Creates a new instance of TextFieldReportElement */
    public TextFieldReportElement(int x, int y, int width, int height)
    {
		super(x,y,width,height);
                this.setText("$F{Field}");
                this.pattern = "";
                this.stretchWithOverflow = false;
                this.blankWhenNull = false;
                this.group = "";
                this.evaluationTime = "Now";
                this.classExpression = "java.lang.String";     
                this.hyperlinkType = "None";
                this.anchorNameExpression = "";
    }    
    
    /** Getter for property blankWhenNull.
     * @return Value of property blankWhenNull.
     *
     */
    public boolean isBlankWhenNull() {
        return blankWhenNull;
    }
    
    /** Setter for property blankWhenNull.
     * @param blankWhenNull New value of property blankWhenNull.
     *
     */
    public void setBlankWhenNull(boolean blankWhenNull) {
        this.blankWhenNull = blankWhenNull;
    }
    
    /** Getter for property classExpression.
     * @return Value of property classExpression.
     *
     */
    public java.lang.String getClassExpression() {
        return classExpression;
    }
    
    /** Setter for property classExpression.
     * @param classExpression New value of property classExpression.
     *
     */
    public void setClassExpression(java.lang.String classExpression) {
        this.classExpression = classExpression;
    }
    
    /** Getter for property evaluationTime.
     * @return Value of property evaluationTime.
     *
     */
    public java.lang.String getEvaluationTime() {
        return evaluationTime;
    }
    
    /** Setter for property evaluationTime.
     * @param evaluationTime New value of property evaluationTime.
     *
     */
    public void setEvaluationTime(java.lang.String evaluationTime) {
        this.evaluationTime = evaluationTime;
    }
    
    /** Getter for property group.
     * @return Value of property group.
     *
     */
    public java.lang.String getGroup() {
        return group;
    }
    
    /** Setter for property group.
     * @param group New value of property group.
     *
     */
    public void setGroup(java.lang.String group) {
        this.group = group;
    }
    
    /** Getter for property pattern.
     * @return Value of property pattern.
     *
     */
    public java.lang.String getPattern() {
        return pattern;
    }
    
    /** Setter for property pattern.
     * @param pattern New value of property pattern.
     *
     */
    public void setPattern(java.lang.String pattern) {
        this.pattern = pattern;
    }
    
    /** Getter for property stretchWithOverflow.
     * @return Value of property stretchWithOverflow.
     *
     */
    public boolean isStretchWithOverflow() {
        return stretchWithOverflow;
    }
    
    /** Setter for property stretchWithOverflow.
     * @param stretchWithOverflow New value of property stretchWithOverflow.
     *
     */
    public void setStretchWithOverflow(boolean stretchWithOverflow) {
        this.stretchWithOverflow = stretchWithOverflow;
    }
    
    /** Getter for property anchorNameExpression.
     * @return Value of property anchorNameExpression.
     *
     */
    public java.lang.String getAnchorNameExpression() {
        return anchorNameExpression;
    }
    
    /** Setter for property anchorNameExpression.
     * @param anchorNameExpression New value of property anchorNameExpression.
     *
     */
    public void setAnchorNameExpression(java.lang.String anchorNameExpression) {
        this.anchorNameExpression = anchorNameExpression;
    }
    
    /** Getter for property hyperlinkAnchorExpression.
     * @return Value of property hyperlinkAnchorExpression.
     *
     */
    public java.lang.String getHyperlinkAnchorExpression() {
        return hyperlinkAnchorExpression;
    }
    
    /** Setter for property hyperlinkAnchorExpression.
     * @param hyperlinkAnchorExpression New value of property hyperlinkAnchorExpression.
     *
     */
    public void setHyperlinkAnchorExpression(java.lang.String hyperlinkAnchorExpression) {
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
    }
    
    /** Getter for property hyperlinkPageExpression.
     * @return Value of property hyperlinkPageExpression.
     *
     */
    public java.lang.String getHyperlinkPageExpression() {
        return hyperlinkPageExpression;
    }
    
    /** Setter for property hyperlinkPageExpression.
     * @param hyperlinkPageExpression New value of property hyperlinkPageExpression.
     *
     */
    public void setHyperlinkPageExpression(java.lang.String hyperlinkPageExpression) {
        this.hyperlinkPageExpression = hyperlinkPageExpression;
    }
    
    /** Getter for property hyperlinkReferenceExpression.
     * @return Value of property hyperlinkReferenceExpression.
     *
     */
    public java.lang.String getHyperlinkReferenceExpression() {
        return hyperlinkReferenceExpression;
    }
    
    /** Setter for property hyperlinkReferenceExpression.
     * @param hyperlinkReferenceExpression New value of property hyperlinkReferenceExpression.
     *
     */
    public void setHyperlinkReferenceExpression(java.lang.String hyperlinkReferenceExpression) {
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
    }
    
    /** Getter for property hyperlinkType.
     * @return Value of property hyperlinkType.
     *
     */
    public java.lang.String getHyperlinkType() {
        return hyperlinkType;
    }
    
    /** Setter for property hyperlinkType.
     * @param hyperlinkType New value of property hyperlinkType.
     *
     */
    public void setHyperlinkType(java.lang.String hyperlinkType) {
        this.hyperlinkType = hyperlinkType;
    }
    
    public ReportElement cloneMe()
    {
	TextFieldReportElement newReportElement = new TextFieldReportElement(position.x, position.y, width, height);
	copyBaseReportElement(newReportElement, this);
	return newReportElement;
    }
        
    public void copyBaseReportElement(ReportElement destination, ReportElement source)
        {
                super.copyBaseReportElement(destination, source);
                
                if (destination instanceof TextFieldReportElement &&
                    source instanceof TextFieldReportElement )
                {
                    ((TextFieldReportElement)destination).setBlankWhenNull( ((TextFieldReportElement)source).isBlankWhenNull());
                    ((TextFieldReportElement)destination).setClassExpression(new String(  ((TextFieldReportElement)source).getClassExpression() ));
                    ((TextFieldReportElement)destination).setEvaluationTime(new String(  ((TextFieldReportElement)source).getEvaluationTime() ));
                    ((TextFieldReportElement)destination).setGroup(new String( ((TextFieldReportElement)source).getGroup()));
                    ((TextFieldReportElement)destination).setPattern(new String(  ((TextFieldReportElement)source).getPattern() ));
                    ((TextFieldReportElement)destination).setStretchWithOverflow(  ((TextFieldReportElement)source).isStretchWithOverflow() );
                    
                    ((HyperLinkableReportElement)destination).setAnchorNameExpression(new String(  ((HyperLinkableReportElement)source).getAnchorNameExpression() ));
                    ((HyperLinkableReportElement)destination).setHyperlinkAnchorExpression(new String(  ((HyperLinkableReportElement)source).getHyperlinkAnchorExpression() ));
                    ((HyperLinkableReportElement)destination).setHyperlinkPageExpression(new String(  ((HyperLinkableReportElement)source).getHyperlinkPageExpression() ));
                    ((HyperLinkableReportElement)destination).setHyperlinkReferenceExpression(new String(  ((HyperLinkableReportElement)source).getHyperlinkReferenceExpression() ));
                    ((HyperLinkableReportElement)destination).setHyperlinkType(new String(  ((HyperLinkableReportElement)source).getHyperlinkType() ));
                }
        }
}
