<?php
/***********************************
  Coppermine reCAPTCHA plugin v0.9
  **********************************
  $Revision: 13 $
  $Id: codebase.php 13 2009-01-05 22:21:40Z SaWey $
  $LastChangedBy: SaWey $
  $Date: 2009-01-05 23:21:40 +0100 (ma, 05 jan 2009) $
**********************************************/
if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add install & configure action
$thisplugin->add_action('plugin_install','sawey_recaptcha_install');
$thisplugin->add_action('plugin_configure','sawey_recaptcha_configure');
$thisplugin->add_action('plugin_uninstall','sawey_recaptcha_uninstall');

// Add filters & actions to display & validate CAPTCHA
$thisplugin->add_filter('captcha_comment_print', 'add_captcha_comment');
$thisplugin->add_filter('captcha_contact_print', 'add_captcha_contact');
$thisplugin->add_filter('captcha_register_print', 'add_captcha_register');

$thisplugin->add_filter('captcha_register_validate', 'validate_register');
$thisplugin->add_action('captcha_comment_validate', 'validate_comment');
$thisplugin->add_action('captcha_contact_validate', 'validate_contact');

define('RECAPTCHAPATH', $thisplugin->fullpath);


//print the captcha image
function add_captcha_comment($template){
	global $CONFIG;
	require_once(RECAPTCHAPATH . '/recaptchalib.php');
	$captcha_html = recaptcha_get_html($CONFIG['sawey_recaptcha_key']);
	
	$new_template = <<< EOT
	<tr>
		<td class="tableb tableb_alternate tableb tableb_alternate_alternate_compact" colspan="2">
		  {CONFIRM}
		</td>
		<td class="tableb tableb_alternate tableb tableb_alternate_alternate_compact" colspan="2">
		  {$captcha_html}
		</td>
	</tr>
EOT;
	
	$pattern = "#(<!-- BEGIN comment_captcha -->)(.*?)(<!-- END comment_captcha -->)#s";
	if ( !preg_match($pattern, $template, $matches)) {
			die('<strong>Template error<strong><br />Failed to find block \''.$block_name.'\'('.htmlspecialchars($pattern).') in :<br /><pre>'.htmlspecialchars($template).'</pre>');
	}
	
	$template = str_replace($matches[1].$matches[2].$matches[3], $new_template, $template);
	return $template;
}

function add_captcha_contact($captcha_print){
	global $CONFIG, $lang_common, $captcha_remark, $expand_array;
	require_once(RECAPTCHAPATH . '/recaptchalib.php');
	
	$visibility = isset($expand_array['captcha_remark']) ? 'block' : 'none';
	$captcha_html = recaptcha_get_html($CONFIG['sawey_recaptcha_key']);
	
	$captcha_print = <<< EOT
    <tr>
      <td class="tableb" valign="top" align="right">
        {$lang_common['confirm']}
      </td>
      <td class="tableb" valign="top">
        {$captcha_html}
      </td>
	  <td class="tableb">
        <span id="captcha_remark" style="display:{$visibility}">{$captcha_remark}</span>
      </td>
    </tr>
EOT;
	return $captcha_print;
}

function add_captcha_register($captcha_print){
	global $CONFIG, $lang_common;
	require_once(RECAPTCHAPATH . '/recaptchalib.php');
	
	$captcha_html = recaptcha_get_html($CONFIG['sawey_recaptcha_key']);
	$captcha_print = <<< EOT
    <tr>
      <td class="tableb" valign="center">
        {$lang_common['confirm']}
      </td>
      <td class="tableb" valign="top">
        {$captcha_html}
      </td>
    </tr>
EOT;
	return $captcha_print;
}

//validate captcha entry
function validate_contact(){
	global $CONFIG;
	$superCage = Inspekt::makeSuperCage();
	require_once(RECAPTCHAPATH . '/recaptchalib.php');
	
	$resp = recaptcha_check_answer ($CONFIG['sawey_recaptcha_privkey'], $superCage->server->getEscaped('REMOTE_ADDR'), $superCage->post->getRaw('recaptcha_challenge_field'), $superCage->post->getRaw('recaptcha_response_field'));

	if (!$resp->is_valid) {
		//load language
		$file_lang = RECAPTCHAPATH . '/lang/' . $CONFIG['lang'] . '.php';
		include(file_exists($file_lang) ? $file_lang : RECAPTCHAPATH . '/lang/english.php');
		$GLOBALS['captcha_remark'] = $recap_lang[$resp->error];
		$GLOBALS['expand_array'] = 'captcha_remark';
		$GLOBALS['error']++;
	}
}

function validate_register($error){
	global $CONFIG;
	$superCage = Inspekt::makeSuperCage();
	require_once(RECAPTCHAPATH . '/recaptchalib.php');
	
	$resp = recaptcha_check_answer ($CONFIG['sawey_recaptcha_privkey'], $superCage->server->getEscaped('REMOTE_ADDR'), $superCage->post->getRaw('recaptcha_challenge_field'), $superCage->post->getRaw('recaptcha_response_field'));

	if (!$resp->is_valid) {
		//load language
		$file_lang = RECAPTCHAPATH . '/lang/' . $CONFIG['lang'] . '.php';
		include(file_exists($file_lang) ? $file_lang : RECAPTCHAPATH . '/lang/english.php');
		$error .= '<li style="list-style-image:url(images/icons/stop.png)">' . $recap_lang[$resp->error] . '</li>';
	}
	return $error;
}

function validate_comment(){
	global $CONFIG;
	$superCage = Inspekt::makeSuperCage();
	require_once(RECAPTCHAPATH . '/recaptchalib.php');
	
	$resp = recaptcha_check_answer ($CONFIG['sawey_recaptcha_privkey'], $superCage->server->getEscaped('REMOTE_ADDR'), $superCage->post->getRaw('recaptcha_challenge_field'), $superCage->post->getRaw('recaptcha_response_field'));

	if (!$resp->is_valid) {
		//load language
		$file_lang = RECAPTCHAPATH . '/lang/' . $CONFIG['lang'] . '.php';
		include(file_exists($file_lang) ? $file_lang : RECAPTCHAPATH . '/lang/english.php');
		cpg_die(ERROR, $recap_lang[$resp->error], __FILE__, __LINE__);
	}	
}


// Install function
// Checks if uid is 'foo' and pwd is 'bar'; If so, then install the plugin
function sawey_recaptcha_install() {
	global $CONFIG;
	// Create the super cage
	$superCage = Inspekt::makeSuperCage();
	if (!$superCage->post->keyExists('rc_submit')) {
		return 1;
	}else{
		//create a new entry in the configuration table
		$rc_key = $superCage->post->getRaw('rc_key'); //needs sanitisation, but I don't know which chars are currently allowed in the key
		$rc_privkey = $superCage->post->getRaw('rc_privkey');
		if(strlen($rc_key) < 35){
			return 1;
		}
		$sql = "INSERT INTO {$CONFIG['TABLE_CONFIG']} VALUES('sawey_recaptcha_key', '$rc_key'), ('sawey_recaptcha_privkey', '$rc_privkey')";
		cpg_db_query($sql);
		return true;
	}
	
}

// Configure function
// Displays the form
function sawey_recaptcha_configure() {
	global $CONFIG, $lang_common;
	// Create the super cage
	$superCage = Inspekt::makeSuperCage();
	
	//load language
	$file_lang = RECAPTCHAPATH . '/lang/' . $CONFIG['lang'] . '.php';
	include(file_exists($file_lang) ? $file_lang : RECAPTCHAPATH . '/lang/english.php');
	include_once(RECAPTCHAPATH . '/recaptchalib.php');
	$superCage = Inspekt::makeSuperCage();
	$url = recaptcha_get_signup_url($superCage->server->getRaw('HTTP_HOST'), 'Coppermine Photo Gallery');

    echo <<< EOT
    <form name="cpgform" id="cpgform" action="{$superCage->server->getEscaped('REQUEST_URI')}" method="post">
            <table border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr>
                <td class="tableh2" colspan="2">
                  <h2>{$recap_lang['install_explain']}</h2><a href="{$url}" rel="external">{$recap_lang['install_click']}</a>
                </td>
              </tr>
              <tr>
                <td class="tableb">
                  {$recap_lang['recaptcha_key']}:
                </td>
			  </tr>
			  <tr>
                <td class="tableb">
                  <input type="text" name="rc_key" class="textinput" size="55"/>
                </td>
              </tr>
			  <tr>
                <td class="tableb">
                  {$recap_lang['recaptcha_privkey']}:
                </td>
			  </tr>
			  <tr>
                <td class="tableb">
                  <input type="text" name="rc_privkey" class="textinput" size="55"/>
                </td>
              </tr>
              <tr>
                <td class="tablef" colspan="2">
                  <input type="submit" name="rc_submit" value="{$lang_common['go']}" class="button" />
                </td>
              </tr>
            </table>
    </form>
EOT;
}

function sawey_recaptcha_uninstall(){
	global $CONFIG;
	//remove the record from config
	$sql = "DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name LIKE '%sawey_recaptcha%'";
	cpg_db_query($sql);
	return true;
}