<?php
/*
 * $RCSfile: $
 *
 * SnapGalaxy4CPG - a plugin for Coppermine gallery to create photo prints, and print product gift items
 * Copyright (C) 2007 SnapGalaxy, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
/**
 * @version $Revision: $ $Date: $
 * @package SnapGalaxy4CPG
 * @author Bhavin Suthar <service@snapgalaxy.com> for SnapGalaxy, Inc. http://www.snapgalaxy.com/
 */

  @session_start();

  // We want to always send the right header
  header("Content-type: application/xml");

 // If we send an add action then add the image to the cart.
  if($_REQUEST['action']=='Add'){

    // Check to see if the full image path doesn't exist
    if(!array_key_exists($_REQUEST['rawurl'],$_SESSION['snapgalaxy']['cart'])){
      $_SESSION['snapgalaxy']['cart'][$_REQUEST['rawimage']] = array(
        'thumbwidth' => $_REQUEST['tWidth'],
        'thumbheight' => $_REQUEST['tHeight'],
        'thumbnail' => $_REQUEST['thumbnail'],
        'rawwidth' => $_REQUEST['rWidth'],
        'rawheight' => $_REQUEST['rHeight']
        );
    }

  }else

  // If we send a remove action then remove the image from the cart.
  if($_REQUEST['action']=='Remove'){
    // Check to see if it's already in the cart
    if(array_key_exists($_REQUEST['rawimage'],$_SESSION['snapgalaxy']['cart'])){
      $new_cart = array();
      // If in the cart run through the array.
      foreach($_SESSION['snapgalaxy']['cart'] as $key => $val){

        // put everything in the new cart except the specified item
        if($key != $_REQUEST['rawimage']){
          $new_cart[$key]=$val;
        }
      }

      // save the new cart as the session cart.
      $_SESSION['snapgalaxy']['cart'] = $new_cart;
    }
  }else
  if($_REQUEST['action'] == "clear"){
      $_SESSION['snapgalaxy']['cart'] = null;
  }


  // Create global variables that we may need.
  $return_xml='<?xml version="1.0"?>';
?>
<snapgalaxyresponse>
<?php
  if($_REQUEST['action'] == "Add" || $_REQUEST['action'] == "Remove"){
?>
    <responsedata success="true" action="<?php echo $_REQUEST['action']; ?>" processedimage="<?php echo $_REQUEST['rawimage']?>"  reason="null" message="null"/>
<?php
  }else{
?>
    <responsedata success="true" action="<?php echo $_REQUEST['action']; ?>" reason="null" message="null"/>
<?php
  }
?>
    <cartdata>
<?php
    foreach ($_SESSION['snapgalaxy']['cart'] as $key => $val){
      print '       <imagedata thumbnail="'.$val['thumbnail'].'" thumbwidth="'.$val['thumbwidth'].'" thumbheight="'.$val['thumbheight'].'" rawimage="'.$key.'" rawwidth="'.$val['rawwidth'].'" rawheight="'.$val['rawheight'].'"/>'."\n";
    }
?>
    </cartdata>
</snapgalaxyresponse>


