<?php
/**************************************************
  Backup Plugin for Coppermine Photo Gallery
/**********************************************
  based on the XT Dump script with the agreement of the author
  Modified by Frantz for Backup plugin
  2007/01/20
**********************************************/

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...'); }
if (!GALLERY_ADMIN_MODE) {
  cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
}

if (!ereg("^([0-9a-zA-Z_\-\.]+)\.sql(\.gz)?$", rawurldecode($_POST['FileName'])) || !file_exists('./plugins/backup/dumps/'.rawurldecode($_POST['FileName'])))
{
        PrintError($lang_plugin_backup['ERROR_INVALID_FILENAME']);
}

$aParams = array(
'act' => 'dorestore',
'dbhost' => $XTCONFIG['dbhost'],
'dbbase' => $XTCONFIG['dbbase'],
'dbuser' => $XTCONFIG['dbuser'],
'dbpass' => $XTCONFIG['dbpass'],
'FileName' => rawurldecode($_POST['FileName']),
'LastFilePos' => ((isset($_POST['LastFilePos'])) ? intval($_POST['LastFilePos']) : 0),
'InvalidDump' => ((isset($_POST['InvalidDump'])) ? intval($_POST['InvalidDump']) : 0),
);

if (eregi('^(.*)\.gz$', $aParams['FileName']))
{
        $aParams['zlib'] = 1;
        if (!extension_loaded('zlib'))
        {
                PrintError($lang_plugin_backup['ERROR_ZLIB_NOT_AVAILABLE']);
        }
        define ('USE_ZLIB', true);
}
else
{
        define ('USE_ZLIB', false);
}

include ('./plugins/backup/include/functions.files.inc.php');

if (!($iFd = FileOpen('./plugins/backup/dumps/'.$aParams['FileName'], "rb")))
{
        PrintError($lang_plugin_backup['ERROR_INVALID_FILENAME']);
}

if ($aParams['LastFilePos'] > 0 && FileSeek($iFd, $aParams['LastFilePos']) == -1)
{
        PrintError($lang_plugin_backup['ERROR_INVALID_FILENAME']);
}

$aParams['TotalFilePos'] = (isset($_POST['TotalFilePos'])) ? intval($_POST['TotalFilePos']) : 1;
$aParams['CurrentFileLine'] = (isset($_POST['CurrentFileLine'])) ? intval($_POST['CurrentFileLine']) : 0;

$sUpdateBar = ($aParams['TotalFilePos'] == 1 && $aParams['CurrentFileLine'] == 0) ? 0 : ceil(($aParams['CurrentFileLine'] * 100 ) / $aParams['TotalFilePos']);

echo <<<EOF


  <tr>
    <td class="tableb">
      <form action="" method="post" id="frmProgress" name="frmProgress">
        <input id="txtProgress" name="txtProgress" value="Restore" readonly="readonly" style="border:none;background:none;" />
        <div id="divProgressBarTxt">0%</div>
      </form>
    </td>
  </tr>
  <tr>
    <td class="tableb">
      <table align="center" cellspacing="0" cellpadding="0">
        <tr id="tblProgressBar">
          <td id="tdProgressBarLeft"></td>
          <td id="tdProgressBarRight"></td>
        </tr>
      </table>
    </td>
  </tr>


        <script type="text/javascript">
        <!--
        function        MyGetById(id)
        {
                itm = null;
                if (document.getElementById)
                        itm = document.getElementById(id);
                else if (document.all)
                        itm = document.all[id];
                else if (document.layers)
                        itm = document.layers[id];
                return itm;
        }

        function        UpdateBar(percent)
        {
                var itm = MyGetById('tdProgressBarLeft');
                var itm2 = MyGetById('tdProgressBarRight');
                var txt = MyGetById('divProgressBarTxt');
                itm.width =  (percent * 4);
                itm2.width =  (400 - itm.width);
                txt.innerHTML = percent + '%';
        }
        UpdateBar({$sUpdateBar});
        -->
        </script>
EOF;


if ($aParams['InvalidDump'] == 1)
{
        echo <<<EOF
        <div  align="center" id="divIncompatible">{$lang_plugin_backup['RESTORE_ADVERT']}</div>
        <script type="text/javascript">
        <!--
        MyGetById('divProgressBarTxt').style.display = "none";
        MyGetById('tblProgressBar').style.display = "none";
        //-->
        </script>
EOF;
}

flush();

$nNbQuery = 0;
$nNumberLines = 0;
$sNextPageUrl = '';
$nNbErrors = 0;

while (!FileEOF($iFd))
{
        if ($nNbErrors > 5)
        {
                echo '<strong>Too many errors</strong>';
                break;
        }
        $sBuf = FileGets($iFd, 100000);
        $nNumberLines++;
        $aParams['CurrentFileLine']++;
        $sQuery = trim($sBuf);

        if (!empty($sQuery) && ($sQuery{0} != '#') && ($sQuery{0} != '-'))
        {
                $nNbQuery++;
                if (mysql_query($sQuery) == false)
                {
                        echo 'Query Error Line <strong>'.$aParams['CurrentFileLine'].'</strong><br />';
                        echo 'Error :'.mysql_error().'<br /><pre>'.$sQuery.'</pre>';
                        $nNbErrors++;
                }
        }
        if (!empty($sQuery) && $aParams['CurrentFileLine'] == 3 && $sQuery{0} == '-' && $aParams['TotalFilePos'] == 1 && ereg("-- Rows: ([0-9]+)", $sQuery, $aRegs))
        {
                $aParams['TotalFilePos'] = $aRegs[1];
        }

        if ($aParams['InvalidDump'] == 0 && $aParams['TotalFilePos'] == 1 && $aParams['CurrentFileLine'] == 3)
        {
                echo <<<EOF
                <div align="center" id="divIncompatible">{$lang_plugin_backup['RESTORE_ADVERT']}</div>
                <script type="text/javascript">
                <!--
                MyGetById('divProgressBarTxt').style.display = "none";
                MyGetById('tblProgressBar').style.display = "none";
                //-->
                </script>
EOF;
                $aParams['InvalidDump'] = 1;
        }



        $aParams['LastFilePos'] = FileTell($iFd);
        if (($nNbQuery > 0) && ((($nNbQuery) % 500) == 0))
        {
                ProgressUpdate($lang_plugin_backup['QUERIES_EXECUTED'].': ' . $aParams['CurrentFileLine'] .  ' (' .  number_format((MicrotimeFloat() - $iStartTime), 2, '.', '') . 's)',
                                                ceil(($aParams['CurrentFileLine'] * 100 ) / $aParams['TotalFilePos']));
        }

        if ((MicrotimeFloat() - $iStartTime) > MAX_EXECUTION_TIME)
        {
                $sNextPageUrl = NextPageForm($aParams, $lang_plugin_backup['RESUME_RESTORE']);
                break;
        }
}
@mysql_close();
FileClose($iFd);

if (trim($sNextPageUrl)!="")
{
        ProgressUpdate($lang_plugin_backup['PLEASE_WAIT']);
        echo <<<EOF
        <tr>
        <td class="tableb">
        <div align="center" id="divAdvertise" >
        <h3>{$lang_plugin_backup['RESTORE_WAIT_RESUME']}</h3>
        <h4>{$lang_plugin_backup['RESTORE_WAIT_RESUME2']}:</h4>
        {$sNextPageUrl}
        <script type="text/javascript">
        <!--
        function GoNow()   { document.frmNextPage.submit(); }
        setTimeout('GoNow()', 5000);
        //-->
        </script>
        </div></td></tr>
EOF;
}
else
{
        ProgressUpdate($lang_plugin_backup['RESTORE_COMPLETE'].' - '.$lang_plugin_backup['QUERIES_EXECUTED'].': '.$aParams['CurrentFileLine'].  ' (' .  number_format((MicrotimeFloat() - $iStartTime), 2, '.', '') . 's)', 100);
        echo <<<EOF
        <tr><td class="tableb">{$lang_plugin_backup['RESTORE_COMPLETE']}</td></tr>
        <tr><td class="tablef"><a href="index.php?file=backup/backup" class="admin_menu">{$lang_plugin_backup['return']}</a></td></tr>
EOF;
}


?>