<?php 
/**
* Utility code to benchmark CpmFetch.  
*
* This is a small framework mostly for my own use, but here if you need it.
*
* @access private
* @author vuud
* @package cpmfetch
* @since 1.6.4
*/

/**
* Set this to true to allow it to run
*/
$ENABLE_BENCHMARK_RUN = false;

if (! $ENABLE_BENCHMARK_RUN) {
	exit;
}


	error_reporting(E_ALL);
	ini_set('display_errors',1);  // 0 is off, 1 is on
	include "./cpmfetch.php";
	$objCpm = new cpm();
	$objCpm->sqlPostSelect = "SQL_NO_CACHE";
	// You can comment this out to test rendering time also
	$objCpm->cpm_setReturnType("resultset");
	//$objCpm->cpm_debugMode(true);
?>
<?php


$results = array();

// Leave this call in.  It forces cpmFetch to create a database connection.  Otherwise it will throw off the first result.
$objCpm->dbConnect();

for ($x = 0; $x < 101; $x++) {
	$starttime = explode(' ', microtime());
	$starttime = $starttime[1] + $starttime[0];
	//$objCpm->cpm_viewRandomMedia(1,5, array('alttag' => '{{aTitle}}, {{pFilename}}'));
	//$objCpm->cpm_formatStats("%v");
	
	$objCpm->cpm_showAlbumsUpdatedOverLastDays(10, array('alttag' => '%a %w', 'subtitle' => '%a, %f', 'imagelink' => 'album'));
	//$objCpm->cpm_getAlbumListFrom("",1,3);
	$mtime = explode(' ', microtime());
	$totaltime = $mtime[0] + $mtime[1] - $starttime;
	array_push($results,$totaltime);
}

$x = 0;
foreach($results as $entry) {
	//printf('Iteration ' . $x . ': Page loaded in %.3f seconds.<br>', $entry);
	printf(' %.3f ', $entry);
	$x++;
}


sort($results);

print "<p>Max is: {$results[100]}<br />";
print "Min is: {$results[0]}<br />";
print "Mean is: {$results[50]}<br />";
print "Average is: " . array_sum($results)/sizeof($results) . "</p>";


$objCpm->cpm_close(); ?>

