/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

public final class BooleanConversionUtil {
    private BooleanConversionUtil() {
    }

    public static Boolean toBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            int num = ((Number)o).intValue();
            return num != 0;
        }
        if (o instanceof String) {
            String s = (String)o;
            if ("true".equalsIgnoreCase(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s)) {
                return Boolean.FALSE;
            }
            if (s.equals("0")) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public static boolean toPrimitiveBoolean(Object o) {
        Boolean b = BooleanConversionUtil.toBoolean(o);
        if (b != null) {
            return b;
        }
        return false;
    }
}

