/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.navigation;

import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import net.sourceforge.myfaces.component.html.ext.HtmlCommandLink;
import net.sourceforge.myfaces.custom.navigation.HtmlPanelNavigation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlCommandNavigation
extends HtmlCommandLink {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$custom$navigation$HtmlCommandNavigation == null ? (class$net$sourceforge$myfaces$custom$navigation$HtmlCommandNavigation = HtmlCommandNavigation.class$("net.sourceforge.myfaces.custom.navigation.HtmlCommandNavigation")) : class$net$sourceforge$myfaces$custom$navigation$HtmlCommandNavigation));
    private boolean _open = false;
    private boolean _active = false;
    public static final String COMPONENT_TYPE = "net.sourceforge.myfaces.HtmlCommandNavigation";
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    private static final String DEFAULT_RENDERER_TYPE = "javax.faces.Link";
    static /* synthetic */ Class class$net$sourceforge$myfaces$custom$navigation$HtmlCommandNavigation;

    public boolean isImmediate() {
        return true;
    }

    public void setImmediate(boolean immediate) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Immediate property of HtmlCommandNavigation cannot be set --> ignored.");
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        this._open = open;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public boolean isRendered() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof HtmlCommandNavigation && !((HtmlCommandNavigation)parent).isOpen()) {
                return false;
            }
            if (parent instanceof HtmlPanelNavigation) break;
        }
        return true;
    }

    public void setRendered(boolean rendered) {
    }

    public void toggleOpen() {
        if (this.isOpen()) {
            if (this.getChildCount() > 0) {
                this.setOpen(false);
            }
        } else {
            UIComponent p;
            UIComponent parent = this.getParent();
            HtmlCommandNavigation.closeAllChildren(parent.getChildren().iterator());
            for (p = parent; p != null && !(p instanceof HtmlPanelNavigation); p = p.getParent()) {
                if (!(p instanceof HtmlCommandNavigation)) continue;
                ((HtmlCommandNavigation)p).setOpen(true);
            }
            if (this.getChildCount() == 0) {
                if (!(p instanceof HtmlPanelNavigation)) {
                    log.error((Object)"HtmlCommandNavigation without parent HtmlPanelNavigation ?!");
                } else {
                    HtmlCommandNavigation.deactivateAllChildren(p.getChildren().iterator());
                }
                this.setActive(true);
            } else {
                this.setOpen(true);
            }
        }
    }

    private static void deactivateAllChildren(Iterator children) {
        while (children.hasNext()) {
            UIComponent ni = (UIComponent)children.next();
            if (!(ni instanceof HtmlCommandNavigation)) continue;
            ((HtmlCommandNavigation)ni).setActive(false);
            if (ni.getChildCount() <= 0) continue;
            HtmlCommandNavigation.deactivateAllChildren(ni.getChildren().iterator());
        }
    }

    private static void closeAllChildren(Iterator children) {
        while (children.hasNext()) {
            UIComponent ni = (UIComponent)children.next();
            if (!(ni instanceof HtmlCommandNavigation)) continue;
            ((HtmlCommandNavigation)ni).setOpen(false);
            if (ni.getChildCount() <= 0) continue;
            HtmlCommandNavigation.closeAllChildren(ni.getChildren().iterator());
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        ActionEvent actionEvent;
        if (event instanceof ActionEvent && (actionEvent = (ActionEvent)event).getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
            HtmlCommandNavigation navItem = (HtmlCommandNavigation)actionEvent.getComponent();
            navItem.toggleOpen();
            FacesContext.getCurrentInstance().renderResponse();
        }
        super.broadcast(event);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._open, this._active};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._open = (Boolean)values[1];
        this._active = (Boolean)values[2];
    }

    public HtmlCommandNavigation() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

