/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.mock.servlet;

import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.seasar.extension.mock.servlet.MockHttpServletRequest;
import org.seasar.extension.mock.servlet.MockRequestDispatcher;
import org.seasar.framework.util.EnumerationAdapter;
import org.seasar.framework.util.ResourceUtil;

public class MockServletContext
implements ServletContext,
Serializable {
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 4;
    public static final String SERVER_INFO = "seasar/2.0";
    private String path_;
    private Map mimeTypes_ = new HashMap();
    private Map initParameters_ = new HashMap();
    private Map attributes_ = new HashMap();

    public MockServletContext(String path) {
        if (path == null) {
            path = "/";
        }
        this.path_ = path.charAt(0) == '/' ? path : "/" + path;
    }

    public ServletContext getContext(String path) {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String file) {
        return (String)this.mimeTypes_.get(file);
    }

    public void addMimeType(String file, String type) {
        this.mimeTypes_.put(file, type);
    }

    public Set getResourcePaths(String arg0) {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String path) throws MalformedURLException {
        return ResourceUtil.getResource((String)path);
    }

    public InputStream getResourceAsStream(String path) {
        return ResourceUtil.getResourceAsStream((String)path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException();
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(Exception ex, String message) {
        System.out.println(message);
        ex.printStackTrace();
    }

    public void log(String message, Throwable t) {
        System.out.println(message);
        t.printStackTrace();
    }

    public String getRealPath(String path) {
        return ResourceUtil.getResource((String)path).getFile();
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters_.get(name);
    }

    public Enumeration getInitParameterNames() {
        return new EnumerationAdapter(this.initParameters_.keySet().iterator());
    }

    public void setInitParameter(String name, String value) {
        this.initParameters_.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes_.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes_.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes_.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes_.remove(name);
    }

    public String getServletContextName() {
        return this.path_;
    }

    public MockHttpServletRequest createRequest(String path) {
        String queryString = null;
        int question = path.indexOf(63);
        if (question >= 0) {
            queryString = path.substring(question + 1);
            path = path.substring(0, question);
        }
        MockHttpServletRequest request = new MockHttpServletRequest(this, path);
        request.setQueryString(queryString);
        return request;
    }
}

