/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Type LAZY_LOADER = TypeUtils.parseType("net.sf.cglib.proxy.LazyLoader");

    LazyLoaderGenerator() {
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context) {
        int index;
        HashSet<Integer> indexes = new HashSet<Integer>();
        Iterator it = context.getMethods();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            if (Modifier.isProtected(method.getModifiers())) continue;
            index = context.getIndex(method);
            indexes.add(new Integer(index));
            CodeEmitter e = ce.begin_method(context.getModifiers(method), ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            e.load_this();
            e.dup();
            e.invoke_virtual_this(this.loadMethod(index));
            e.checkcast(Type.getType(method.getDeclaringClass()));
            e.load_args();
            e.invoke(method);
            e.return_value();
            e.end_method();
        }
        Iterator it2 = indexes.iterator();
        while (it2.hasNext()) {
            index = (Integer)it2.next();
            String delegate = "CGLIB$LAZY_LOADER_" + index;
            ce.declare_field(2, delegate, Constants.TYPE_OBJECT, null, null);
            CodeEmitter e = ce.begin_method(50, this.loadMethod(index), null, null);
            e.load_this();
            e.getfield(delegate);
            e.dup();
            Label end = e.make_label();
            e.ifnonnull(end);
            e.pop();
            e.load_this();
            context.emitCallback(e, index);
            e.invoke_interface(LAZY_LOADER, LOAD_OBJECT);
            e.dup_x1();
            e.putfield(delegate);
            e.mark(end);
            e.return_value();
            e.end_method();
        }
    }

    private Signature loadMethod(int index) {
        return new Signature("CGLIB$LOAD_PRIVATE_" + index, Constants.TYPE_OBJECT, Constants.TYPES_EMPTY);
    }

    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context) {
    }
}

