/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import javassist.bytecode.AlignmentException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.Opcode;

public class CodeIterator
implements Opcode {
    protected CodeAttribute codeAttr;
    protected byte[] bytecode;
    protected int endPos;
    protected int currentPos;
    private static final int[] opcodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 0, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5};

    CodeIterator(CodeAttribute ca) {
        this.codeAttr = ca;
        this.bytecode = ca.getCode();
        this.begin();
    }

    public void begin() {
        this.currentPos = 0;
        this.endPos = this.getCodeLength();
    }

    public void move(int index) {
        this.currentPos = index;
    }

    public CodeAttribute get() {
        return this.codeAttr;
    }

    public int getCodeLength() {
        return this.bytecode.length;
    }

    public int byteAt(int index) {
        return this.bytecode[index] & 0xFF;
    }

    public void writeByte(int value, int index) {
        this.bytecode[index] = (byte)value;
    }

    public int u16bitAt(int index) {
        return ByteArray.readU16bit(this.bytecode, index);
    }

    public int s16bitAt(int index) {
        return ByteArray.readS16bit(this.bytecode, index);
    }

    public void write16bit(int value, int index) {
        ByteArray.write16bit(value, this.bytecode, index);
    }

    public int s32bitAt(int index) {
        return ByteArray.read32bit(this.bytecode, index);
    }

    public void write32bit(int value, int index) {
        ByteArray.write32bit(value, this.bytecode, index);
    }

    public void write(byte[] code, int index) {
        int len = code.length;
        int j = 0;
        while (j < len) {
            this.bytecode[index++] = code[j];
            ++j;
        }
    }

    public boolean hasNext() {
        return this.currentPos < this.endPos;
    }

    public int next() throws BadBytecode {
        int pos = this.currentPos;
        this.currentPos = CodeIterator.nextOpcode(this.bytecode, pos);
        return pos;
    }

    public int skipConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(-1);
    }

    public int skipSuperConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(0);
    }

    public int skipThisConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(1);
    }

    private int skipSuperConstructor0(int skipThis) throws BadBytecode {
        this.begin();
        ConstPool cp = this.codeAttr.getConstPool();
        String thisClassName = this.codeAttr.getDeclaringClass();
        int nested = 0;
        while (this.hasNext()) {
            int mref;
            int index = this.next();
            int c = this.byteAt(index);
            if (c == 187) {
                ++nested;
                continue;
            }
            if (c != 183 || !cp.getMethodrefName(mref = ByteArray.readU16bit(this.bytecode, index + 1)).equals("<init>") || --nested >= 0) continue;
            if (skipThis < 0) {
                return index;
            }
            String cname = cp.getMethodrefClassName(mref);
            if (cname.equals(thisClassName) != skipThis > 0) break;
            return index;
        }
        this.begin();
        return -1;
    }

    public int insert(byte[] code) throws BadBytecode {
        int pos = this.currentPos;
        this.insert0(this.currentPos, code, false);
        return pos;
    }

    public void insert(int pos, byte[] code) throws BadBytecode {
        this.insert0(pos, code, false);
    }

    public int insertEx(byte[] code) throws BadBytecode {
        int pos = this.currentPos;
        this.insert0(this.currentPos, code, true);
        return pos;
    }

    public void insertEx(int pos, byte[] code) throws BadBytecode {
        this.insert0(pos, code, true);
    }

    private void insert0(int pos, byte[] code, boolean exclusive) throws BadBytecode {
        int len = code.length;
        if (len <= 0) {
            return;
        }
        this.insertGapCore(pos, len, exclusive);
        int j = 0;
        while (j < len) {
            this.bytecode[pos++] = code[j];
            ++j;
        }
    }

    public int insertGap(int length) throws BadBytecode {
        int pos = this.currentPos;
        this.insertGapCore(this.currentPos, length, false);
        return pos;
    }

    public int insertGap(int pos, int length) throws BadBytecode {
        return this.insertGapCore(pos, length, false);
    }

    public int insertExGap(int length) throws BadBytecode {
        int pos = this.currentPos;
        this.insertGapCore(this.currentPos, length, true);
        return pos;
    }

    public int insertExGap(int pos, int length) throws BadBytecode {
        return this.insertGapCore(pos, length, true);
    }

    private int insertGapCore(int pos, int length, boolean exclusive) throws BadBytecode {
        if (length <= 0) {
            return 0;
        }
        int cur = this.currentPos;
        byte[] c = CodeIterator.insertGap(this.bytecode, pos, length, exclusive, this.get().getExceptionTable());
        int length2 = c.length - this.bytecode.length;
        if (cur >= pos) {
            this.currentPos = cur + length2;
        }
        this.codeAttr.setCode(c);
        this.bytecode = c;
        this.endPos = this.getCodeLength();
        return length2;
    }

    public void insert(ExceptionTable et, int offset) {
        this.codeAttr.getExceptionTable().add(0, et, offset);
    }

    public int append(byte[] code) {
        int size = this.getCodeLength();
        int len = code.length;
        if (len <= 0) {
            return size;
        }
        this.appendGap(len);
        byte[] dest = this.bytecode;
        int i = 0;
        while (i < len) {
            dest[i + size] = code[i];
            ++i;
        }
        return size;
    }

    public void appendGap(int gapLength) {
        byte[] code = this.bytecode;
        int codeLength = code.length;
        byte[] newcode = new byte[codeLength + gapLength];
        int i = 0;
        while (i < codeLength) {
            newcode[i] = code[i];
            ++i;
        }
        i = codeLength;
        while (i < codeLength + gapLength) {
            newcode[i] = 0;
            ++i;
        }
        this.codeAttr.setCode(newcode);
        this.bytecode = newcode;
        this.endPos = this.getCodeLength();
    }

    public void append(ExceptionTable et, int offset) {
        ExceptionTable table = this.codeAttr.getExceptionTable();
        table.add(table.size(), et, offset);
    }

    static int nextOpcode(byte[] code, int index) throws BadBytecode {
        int opcode;
        try {
            opcode = code[index] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new BadBytecode("invalid opcode address");
        }
        try {
            int len = opcodeLength[opcode];
            if (len > 0) {
                return index + len;
            }
            if (opcode == 196) {
                if (code[index + 1] == -124) {
                    return index + 6;
                }
                return index + 4;
            }
            int index2 = (index & 0xFFFFFFFC) + 8;
            if (opcode == 171) {
                int npairs = ByteArray.read32bit(code, index2);
                return index2 + npairs * 8 + 4;
            }
            if (opcode == 170) {
                int low = ByteArray.read32bit(code, index2);
                int high = ByteArray.read32bit(code, index2 + 4);
                return index2 + (high - low + 1) * 4 + 8;
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        throw new BadBytecode(opcode);
    }

    static byte[] insertGap(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable) throws BadBytecode {
        if (gapLength <= 0) {
            return code;
        }
        try {
            return CodeIterator.insertGap0(code, where, gapLength, exclusive, etable);
        }
        catch (AlignmentException e) {
            try {
                return CodeIterator.insertGap0(code, where, gapLength + 3 & 0xFFFFFFFC, exclusive, etable);
            }
            catch (AlignmentException e2) {
                throw new RuntimeException("fatal error?");
            }
        }
    }

    private static byte[] insertGap0(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable) throws BadBytecode, AlignmentException {
        int codeLength = code.length;
        byte[] newcode = new byte[codeLength + gapLength];
        CodeIterator.insertGap2(code, where, gapLength, codeLength, newcode, exclusive);
        etable.shiftPc(where, gapLength, exclusive);
        return newcode;
    }

    /*
     * Unable to fully structure code
     */
    private static void insertGap2(byte[] code, int where, int gapLength, int endPos, byte[] newcode, boolean exclusive) throws BadBytecode, AlignmentException {
        i = 0;
        j = 0;
        while (i < endPos) {
            block11: {
                block13: {
                    block12: {
                        block10: {
                            if (i == where) {
                                j2 = j + gapLength;
                                while (j < j2) {
                                    newcode[j++] = 0;
                                }
                            }
                            nextPos = CodeIterator.nextOpcode(code, i);
                            inst = code[i] & 255;
                            if ((153 > inst || inst > 168) && inst != 198 && inst != 199) break block10;
                            offset = code[i + 1] << 8 | code[i + 2] & 255;
                            offset = CodeIterator.newOffset(i, offset, where, gapLength, exclusive);
                            newcode[j] = code[i];
                            ByteArray.write16bit(offset, newcode, j + 1);
                            j += 3;
                            break block11;
                        }
                        if (inst != 200 && inst != 201) break block12;
                        offset = ByteArray.read32bit(code, i + 1);
                        offset = CodeIterator.newOffset(i, offset, where, gapLength, exclusive);
                        newcode[j++] = code[i];
                        ByteArray.write32bit(offset, newcode, j);
                        j += 4;
                        break block11;
                    }
                    if (inst != 170) break block13;
                    if (i != j && (gapLength & 3) != 0) {
                        throw new AlignmentException();
                    }
                    i0 = i;
                    i2 = (i & -4) + 4;
                    while (i0 < i2) {
                        newcode[j++] = code[i0++];
                    }
                    defaultbyte = CodeIterator.newOffset(i, ByteArray.read32bit(code, i2), where, gapLength, exclusive);
                    ByteArray.write32bit(defaultbyte, newcode, j);
                    lowbyte = ByteArray.read32bit(code, i2 + 4);
                    ByteArray.write32bit(lowbyte, newcode, j + 4);
                    highbyte = ByteArray.read32bit(code, i2 + 8);
                    ByteArray.write32bit(highbyte, newcode, j + 8);
                    j += 12;
                    i0 = i2 + 12;
                    i2 = i0 + (highbyte - lowbyte + 1) * 4;
                    while (i0 < i2) {
                        offset = CodeIterator.newOffset(i, ByteArray.read32bit(code, i0), where, gapLength, exclusive);
                        ByteArray.write32bit(offset, newcode, j);
                        j += 4;
                        i0 += 4;
                    }
                    break block11;
                }
                if (inst != 171) ** GOTO lbl76
                if (i != j && (gapLength & 3) != 0) {
                    throw new AlignmentException();
                }
                i0 = i;
                i2 = (i & -4) + 4;
                while (i0 < i2) {
                    newcode[j++] = code[i0++];
                }
                defaultbyte = CodeIterator.newOffset(i, ByteArray.read32bit(code, i2), where, gapLength, exclusive);
                ByteArray.write32bit(defaultbyte, newcode, j);
                npairs = ByteArray.read32bit(code, i2 + 4);
                ByteArray.write32bit(npairs, newcode, j + 4);
                j += 8;
                i0 = i2 + 8;
                i2 = i0 + npairs * 8;
                while (i0 < i2) {
                    ByteArray.copy32bit(code, i0, newcode, j);
                    offset = CodeIterator.newOffset(i, ByteArray.read32bit(code, i0 + 4), where, gapLength, exclusive);
                    ByteArray.write32bit(offset, newcode, j + 4);
                    j += 8;
                    i0 += 8;
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    newcode[j++] = code[i++];
lbl76:
                    // 2 sources

                    ** while (i < nextPos)
                }
            }
            i = nextPos;
        }
    }

    private static int newOffset(int i, int offset, int where, int gapLength, boolean exclusive) {
        int target = i + offset;
        if (i < where) {
            if (where < target || exclusive && where == target) {
                offset += gapLength;
            }
        } else if (target < where || !exclusive && where == target) {
            offset -= gapLength;
        }
        return offset;
    }
}

