/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.FieldTracking;
import org.apache.tapestry.valid.IFieldTracking;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.IValidator;
import org.apache.tapestry.valid.RenderString;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class ValidationDelegate
implements IValidationDelegate {
    private IFormComponent _currentComponent;
    private List _trackings;
    private Map _trackingMap;

    public void clear() {
        this._currentComponent = null;
        this._trackings = null;
        this._trackingMap = null;
    }

    public void writeLabelPrefix(IFormComponent component, IMarkupWriter writer, IRequestCycle cycle) {
        if (this.isInError(component)) {
            writer.begin("font");
            writer.attribute("color", "red");
        }
    }

    public void writeLabelSuffix(IFormComponent component, IMarkupWriter writer, IRequestCycle cycle) {
        if (this.isInError(component)) {
            writer.end();
        }
    }

    protected FieldTracking getComponentTracking() {
        if (this._trackingMap == null) {
            return null;
        }
        String formName = this._currentComponent.getForm().getName();
        Map formMap = (Map)this._trackingMap.get(formName);
        if (formMap == null) {
            return null;
        }
        return (FieldTracking)formMap.get(this._currentComponent.getName());
    }

    public void setFormComponent(IFormComponent component) {
        this._currentComponent = component;
    }

    public boolean isInError() {
        FieldTracking tracking = this.getComponentTracking();
        return tracking != null && tracking.isInError();
    }

    public String getFieldInputValue() {
        FieldTracking tracking = this.getComponentTracking();
        return tracking == null ? null : tracking.getInput();
    }

    public List getFieldTracking() {
        if (Tapestry.size(this._trackings) == 0) {
            return null;
        }
        return Collections.unmodifiableList(this._trackings);
    }

    public void reset() {
        FieldTracking tracking = this.getComponentTracking();
        if (tracking != null) {
            this._trackings.remove(tracking);
            String formName = tracking.getComponent().getForm().getName();
            Map formMap = (Map)this._trackingMap.get(formName);
            if (formMap != null) {
                formMap.remove(tracking.getFieldName());
            }
        }
    }

    public void record(ValidatorException ex) {
        IRender errorRenderer = ex.getErrorRenderer();
        if (errorRenderer == null) {
            this.record(ex.getMessage(), ex.getConstraint());
        } else {
            this.record(errorRenderer, ex.getConstraint());
        }
    }

    public void record(String message, ValidationConstraint constraint) {
        this.record(new RenderString(message), constraint);
    }

    public void record(IRender errorRenderer, ValidationConstraint constraint) {
        FieldTracking tracking = this.findCurrentTracking();
        tracking.setErrorRenderer(errorRenderer);
        tracking.setConstraint(constraint);
    }

    public void recordFieldInputValue(String input) {
        FieldTracking tracking = this.findCurrentTracking();
        tracking.setInput(input);
    }

    protected FieldTracking findCurrentTracking() {
        FieldTracking result = null;
        if (this._trackings == null) {
            this._trackings = new ArrayList();
        }
        if (this._trackingMap == null) {
            this._trackingMap = new HashMap();
        }
        if (this._currentComponent == null) {
            result = new FieldTracking();
            this._trackings.add(result);
        } else {
            result = this.getComponentTracking();
            if (result == null) {
                String formName = this._currentComponent.getForm().getName();
                HashMap<String, FieldTracking> formMap = (HashMap<String, FieldTracking>)this._trackingMap.get(formName);
                if (formMap == null) {
                    formMap = new HashMap<String, FieldTracking>();
                    this._trackingMap.put(formName, formMap);
                }
                String fieldName = this._currentComponent.getName();
                result = new FieldTracking(fieldName, this._currentComponent);
                this._trackings.add(result);
                formMap.put(fieldName, result);
            }
        }
        return result;
    }

    public void writePrefix(IMarkupWriter writer, IRequestCycle cycle, IFormComponent component, IValidator validator) {
    }

    public void writeAttributes(IMarkupWriter writer, IRequestCycle cycle, IFormComponent component, IValidator validator) {
    }

    public void writeSuffix(IMarkupWriter writer, IRequestCycle cycle, IFormComponent component, IValidator validator) {
        if (this.isInError()) {
            writer.printRaw("&nbsp;");
            writer.begin("font");
            writer.attribute("color", "red");
            writer.print("**");
            writer.end();
        }
    }

    public boolean getHasErrors() {
        return this.getFirstError() != null;
    }

    public IRender getFirstError() {
        if (Tapestry.size(this._trackings) == 0) {
            return null;
        }
        Iterator i = this._trackings.iterator();
        while (i.hasNext()) {
            IFieldTracking tracking = (IFieldTracking)i.next();
            if (!tracking.isInError()) continue;
            return tracking.getErrorRenderer();
        }
        return null;
    }

    protected boolean isInError(IFormComponent component) {
        if (this._trackingMap == null) {
            return false;
        }
        IForm form = component.getForm();
        if (form == null) {
            return false;
        }
        String formName = form.getName();
        Map formMap = (Map)this._trackingMap.get(formName);
        if (formMap == null) {
            return false;
        }
        IFieldTracking tracking = (IFieldTracking)formMap.get(component.getName());
        return tracking != null && tracking.isInError();
    }

    public List getAssociatedTrackings() {
        int count = Tapestry.size(this._trackings);
        if (count == 0) {
            return null;
        }
        ArrayList<IFieldTracking> result = new ArrayList<IFieldTracking>(count);
        int i = 0;
        while (i < count) {
            IFieldTracking tracking = (IFieldTracking)this._trackings.get(i);
            if (tracking.getFieldName() != null) {
                result.add(tracking);
            }
            ++i;
        }
        return result;
    }

    public List getUnassociatedTrackings() {
        int count = Tapestry.size(this._trackings);
        if (count == 0) {
            return null;
        }
        ArrayList<IFieldTracking> result = new ArrayList<IFieldTracking>(count);
        int i = 0;
        while (i < count) {
            IFieldTracking tracking = (IFieldTracking)this._trackings.get(i);
            if (tracking.getFieldName() == null) {
                result.add(tracking);
            }
            ++i;
        }
        return result;
    }
}

