/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.pageload;

import java.util.Iterator;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.binding.ExpressionBinding;
import org.apache.tapestry.pageload.IComponentVisitor;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IParameterSpecification;

public class EstablishDefaultParameterValuesVisitor
implements IComponentVisitor {
    private IResourceResolver _resolver;

    public EstablishDefaultParameterValuesVisitor(IResourceResolver resolver) {
        this._resolver = resolver;
    }

    public void visitComponent(IComponent component) {
        IComponentSpecification spec = component.getSpecification();
        Iterator i = spec.getParameterNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            IParameterSpecification parameterSpec = spec.getParameter(name);
            String defaultValue = parameterSpec.getDefaultValue();
            if (defaultValue == null) continue;
            if (parameterSpec.isRequired()) {
                throw new ApplicationRuntimeException(Tapestry.format("EstablishDefaultParameterValuesVisitor.parameter-must-have-no-default-value", component.getExtendedId(), name), component, parameterSpec.getLocation(), null);
            }
            if (component.getBinding(name) != null) continue;
            ExpressionBinding binding = new ExpressionBinding(this._resolver, component, defaultValue, parameterSpec.getLocation());
            component.setBinding(name, binding);
        }
    }
}

