/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.StaleSessionException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.AbstractService;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.request.ResponseOutputStream;

public class DirectService
extends AbstractService {
    private static final String STATEFUL_ON = "1";
    private static final String STATEFUL_OFF = "0";

    public ILink getLink(IRequestCycle cycle, IComponent component, Object[] parameters) {
        IPage componentPage;
        IPage renderPage = cycle.getPage();
        boolean complex = renderPage != (componentPage = component.getPage());
        String[] context = complex ? new String[4] : new String[3];
        int i = 0;
        String stateful = cycle.getEngine().isStateful() ? STATEFUL_ON : STATEFUL_OFF;
        context[i++] = stateful;
        if (complex) {
            context[i++] = renderPage.getPageName();
        }
        context[i++] = componentPage.getPageName();
        context[i++] = component.getIdPath();
        return this.constructLink(cycle, "direct", context, parameters, true);
    }

    public void service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws ServletException, IOException {
        HttpSession session;
        IDirect direct;
        int count = 0;
        RequestContext requestContext = cycle.getRequestContext();
        String[] serviceContext = this.getServiceContext(requestContext);
        if (serviceContext != null) {
            count = serviceContext.length;
        }
        if (count != 3 && count != 4) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("DirectService.context-parameters"));
        }
        boolean complex = count == 4;
        int i = 0;
        String stateful = serviceContext[i++];
        String pageName = serviceContext[i++];
        String componentPageName = complex ? serviceContext[i++] : pageName;
        String componentPath = serviceContext[i++];
        IPage page = cycle.getPage(pageName);
        cycle.activate(page);
        IPage componentPage = complex ? cycle.getPage(componentPageName) : page;
        IComponent component = componentPage.getNestedComponent(componentPath);
        try {
            direct = (IDirect)component;
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("DirectService.component-wrong-type", component.getExtendedId()), component, null, ex);
        }
        if (stateful.equals(STATEFUL_ON) && direct.isStateful() && ((session = cycle.getRequestContext().getSession()) == null || session.isNew())) {
            throw new StaleSessionException(Tapestry.format("DirectService.stale-session-exception", direct.getExtendedId()), direct.getPage());
        }
        Object[] parameters = this.getParameters(cycle);
        cycle.setServiceParameters(parameters);
        direct.trigger(cycle);
        engine.renderResponse(cycle, output);
    }

    public String getName() {
        return "direct";
    }
}

