/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorResult;

public class ValidatorResults
implements Serializable {
    protected Map hResults = new HashMap();

    public void merge(ValidatorResults res) {
        this.hResults.putAll(res.hResults);
    }

    public void add(Field field, String validatorName, boolean bResult) {
        this.add(field, validatorName, bResult, null);
    }

    public void add(Field field, String validatorName, boolean bResult, Object value) {
        ValidatorResult result = null;
        result = this.hResults.containsKey(field.getKey()) ? (ValidatorResult)this.hResults.get(field.getKey()) : new ValidatorResult(field);
        result.add(validatorName, bResult, value);
        this.hResults.put(field.getKey(), result);
    }

    public void clear() {
        this.hResults.clear();
    }

    public boolean empty() {
        return this.hResults.size() == 0;
    }

    public ValidatorResult getValidatorResult(String key) {
        return this.hResults.containsKey(key) ? (ValidatorResult)this.hResults.get(key) : null;
    }

    public Iterator get() {
        if (this.hResults.size() == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.hResults.keySet().iterator();
    }

    public Iterator properties() {
        return this.hResults.keySet().iterator();
    }

    public Map getResultValueMap() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Iterator i = this.hResults.keySet().iterator();
        while (i.hasNext()) {
            String propertyKey = (String)i.next();
            ValidatorResult vr = (ValidatorResult)this.hResults.get(propertyKey);
            Map hActions = vr.getActionMap();
            Iterator x = hActions.keySet().iterator();
            while (x.hasNext()) {
                Object result;
                String actionKey = (String)x.next();
                ValidatorResult.ResultStatus rs = (ValidatorResult.ResultStatus)hActions.get(actionKey);
                if (rs == null || (result = rs.getResult()) == null || result instanceof Boolean) continue;
                results.put(propertyKey, result);
            }
        }
        return results;
    }
}

