/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.unit;

import java.util.Iterator;
import java.util.Map;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.DataSetImpl;
import org.seasar.extension.dataset.states.RowStates;
import org.seasar.extension.dataset.types.ColumnTypes;

public class MapReader
implements DataReader {
    private DataSet dataSet_ = new DataSetImpl();
    private DataTable table_ = this.dataSet_.addTable("Map");

    protected MapReader() {
    }

    public MapReader(Map map) {
        this.setupColumns(map);
        this.setupRow(map);
    }

    protected void setupColumns(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.table_.addColumn(key);
        }
    }

    protected void setupRow(Map map) {
        DataRow row = this.table_.addRow();
        int i = 0;
        while (i < this.table_.getColumnSize()) {
            DataColumn column = this.table_.getColumn(i);
            Object value = map.get(column.getColumnName());
            if (value != null) {
                ColumnType ct = ColumnTypes.getColumnType(value.getClass());
                row.setValue(column.getColumnName(), ct.convert(value, null));
            }
            ++i;
        }
        row.setState(RowStates.UNCHANGED);
    }

    public DataSet read() {
        return this.dataSet_;
    }
}

