/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class FloatConversionUtil {
    private FloatConversionUtil() {
    }

    public static Float toFloat(Object o) {
        return FloatConversionUtil.toFloat(o, null);
    }

    public static Float toFloat(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return new Float(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return Float.valueOf((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Float(new SimpleDateFormat(pattern).format(o));
            }
            return new Float(((Date)o).getTime());
        }
        return new Float(o.toString());
    }

    public static float toPrimitiveFloat(Object o) {
        return FloatConversionUtil.toPrimitiveFloat(o, null);
    }

    public static float toPrimitiveFloat(Object o, String pattern) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof String) {
            return Float.parseFloat((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Float.parseFloat(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        return Float.parseFloat(o.toString());
    }
}

