/*
 * Decompiled with CFR 0.152.
 */
package jp.thaniwa.scriptdirector.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class RuntimeExecutor {
    private static RuntimeExecutor executor = null;
    private AbstractList<String> stdout;
    private AbstractList<String> stderr;
    private int exitValue;
    private boolean windowsFlag = false;
    private boolean jisAutoDetectFlag = false;

    private RuntimeExecutor() {
    }

    public static RuntimeExecutor getExecutor() {
        if (executor == null) {
            executor = new RuntimeExecutor();
        }
        executor.initialize();
        return executor;
    }

    public void initialize() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            this.windowsFlag = true;
            this.jisAutoDetectFlag = true;
        } else {
            this.windowsFlag = false;
            String encoding = System.getProperty("file.encoding");
            this.jisAutoDetectFlag = encoding.startsWith("EUC-JP");
        }
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public int execute(AbstractList<String> args) {
        try {
            String line;
            ProcessBuilder pBuilder = new ProcessBuilder(args);
            Process process = pBuilder.start();
            InputStream out = process.getInputStream();
            InputStream err = process.getErrorStream();
            BufferedReader outReader = null;
            outReader = this.jisAutoDetectFlag ? new BufferedReader(new InputStreamReader(out, "JISAutoDetect")) : new BufferedReader(new InputStreamReader(out));
            this.stdout = new ArrayList<String>();
            while (outReader != null && (line = outReader.readLine()) != null) {
                this.stdout.add(line);
            }
            BufferedReader errReader = null;
            errReader = this.jisAutoDetectFlag ? new BufferedReader(new InputStreamReader(err, "JISAutoDetect")) : new BufferedReader(new InputStreamReader(err));
            this.stderr = new ArrayList<String>();
            while (errReader != null && (line = errReader.readLine()) != null) {
                this.stderr.add(line);
                System.err.println(line);
            }
            process.waitFor();
            outReader.close();
            errReader.close();
            out.close();
            err.close();
            process.getOutputStream().close();
            this.exitValue = process.exitValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return this.exitValue;
    }

    public AbstractList<String> getStdOut() {
        return this.stdout;
    }

    public AbstractList<String> getStdErr() {
        return this.stderr;
    }

    public void printCommand(AbstractList<String> list) {
        String command = null;
        if (list != null) {
            Iterator<String> i = list.iterator();
            while (i.hasNext()) {
                if (command == null) {
                    command = i.next();
                    continue;
                }
                command = command + " " + i.next();
            }
        }
        System.out.println(command);
    }

    public void printOutput(AbstractList<String> list) {
        if (list != null) {
            Iterator<String> i = list.iterator();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        }
    }

    public void printExitValue() {
        System.out.println("Exit Value : " + this.exitValue);
    }

    public static void main(String[] args) {
        RuntimeExecutor rexec = RuntimeExecutor.getExecutor();
    }
}

