#ifndef __UBOOT_MB9BFXXX_H
#define __UBOOT_MB9BFXXX_H

#undef MB9BFXXX_DEBUG

#ifdef MB9BFXXX_DEBUG
	#define PDEBUG(level, fmt, args...) \
		if (debug >= (level)) printf("[%s:%d] " fmt, \
		__PRETTY_FUNCTION__, __LINE__ , ## args)
#else
	#define PDEBUG(level, fmt, args...) do {} while(0)
#endif

#define UECLK_USBEN0	0x40036030
#define UECLK_USBEN1	0x40036034

#define HCNT	(CONFIG_FM3_USB_HOST + 0x2100)
#define HIRQ	(CONFIG_FM3_USB_HOST + 0x2104)
#define HERR	(CONFIG_FM3_USB_HOST + 0x2105)
#define HSTATE	(CONFIG_FM3_USB_HOST + 0x2108)
#define HCOMP	(CONFIG_FM3_USB_HOST + 0x2109)
#define HRTIMER	(CONFIG_FM3_USB_HOST + 0x210c)
#define HRTIMER2	(CONFIG_FM3_USB_HOST + 0x2110)
#define HADDR	(CONFIG_FM3_USB_HOST + 0x2111)
#define HEOF	(CONFIG_FM3_USB_HOST + 0x2114)
#define HFRAME	(CONFIG_FM3_USB_HOST + 0x2118)
#define HTOKEN	(CONFIG_FM3_USB_HOST + 0x211c)
#define UDCC	(CONFIG_FM3_USB_HOST + 0x2120)
#define EP0C	(CONFIG_FM3_USB_HOST + 0x2124)
#define EP1C	(CONFIG_FM3_USB_HOST + 0x2128)
#define EP2C	(CONFIG_FM3_USB_HOST + 0x212c)
#define EP3C	(CONFIG_FM3_USB_HOST + 0x2130)
#define EP4C	(CONFIG_FM3_USB_HOST + 0x2134)
#define EP5C	(CONFIG_FM3_USB_HOST + 0x2138)
#define TMSP	(CONFIG_FM3_USB_HOST + 0x213c)
#define UDCS	(CONFIG_FM3_USB_HOST + 0x2140)
#define UDCIE	(CONFIG_FM3_USB_HOST + 0x2141)
#define EP0IS	(CONFIG_FM3_USB_HOST + 0x2144)
#define EP0OS	(CONFIG_FM3_USB_HOST + 0x2148)
#define EP1S	(CONFIG_FM3_USB_HOST + 0x214c)
#define EP2S	(CONFIG_FM3_USB_HOST + 0x2150)
#define EP3S	(CONFIG_FM3_USB_HOST + 0x2154)
#define EP4S	(CONFIG_FM3_USB_HOST + 0x2158)
#define EP5S	(CONFIG_FM3_USB_HOST + 0x215c)
#define EP0DTL	(CONFIG_FM3_USB_HOST + 0x2160)
#define EP0DTH	(CONFIG_FM3_USB_HOST + 0x2161)
#define EP1DTL	(CONFIG_FM3_USB_HOST + 0x2164)
#define EP1DTH	(CONFIG_FM3_USB_HOST + 0x2165)
#define EP2DTL	(CONFIG_FM3_USB_HOST + 0x2168)
#define EP2DTH	(CONFIG_FM3_USB_HOST + 0x2169)
#define EP3DTL	(CONFIG_FM3_USB_HOST + 0x216c)
#define EP3DTH	(CONFIG_FM3_USB_HOST + 0x216d)
#define EP4DTL	(CONFIG_FM3_USB_HOST + 0x2170)
#define EP4DTH	(CONFIG_FM3_USB_HOST + 0x2171)
#define EP5DTL	(CONFIG_FM3_USB_HOST + 0x2174)
#define EP5DTH	(CONFIG_FM3_USB_HOST + 0x2175)

#define HIRQ_TCAN	(1 << 7)
#define HIRQ_RWKIRQ	(1 << 5)
#define HIRQ_URIRQ	(1 << 4)
#define HIRQ_CMPIRQ	(1 << 3)
#define HIRQ_CNNIRQ	(1 << 2)
#define HIRQ_DIRQ	(1 << 1)
#define HIRQ_SOFIRQ	(1 << 0)

#define HERR_LSTSOF	(1 << 7)
#define HERR_RERR	(1 << 7)
#define HERR_TOUT	(1 << 7)
#define HERR_CRC	(1 << 7)
#define HERR_TGERR	(1 << 7)
#define HERR_STUFF	(1 << 7)
#define HERR_HS		((1 << 1) | (1 << 0))
#define HERR_ERR	(HERR_LSTSOF | HERR_RERR | HERR_TOUT | HERR_CRC | HERR_STUFF)
#define HERR_HS_ACK	0
#define HERR_HS_NAK	1
#define HERR_HS_STALL	2
#define HERR_HS_NULL	3

#define CTRL_EPEN	(1 << 15)
#define CTRL_TYPE_ISO	(1 << 13)
#define CTRL_TYPE_BULK	(2 << 13)
#define CTRL_TYPE_INTERRUPT	(3 << 13)
#define CTRL_DIR	(1 << 12)
#define CTRL_DMAE	(1 << 11)
#define CTRL_NULL	(1 << 10)
#define CTRL_STALL	(1 << 9)
#define CTRL_DIR_OUT	CTRL_DIR
#define CTRL_DIR_IN	0

#define TOKEN_TGGE	(1 << 7)
#define TOKEN_NONE	(0 << 4)
#define TOKEN_SETUP	(1 << 4)
#define TOKEN_IN	(2 << 4)
#define TOKEN_OUT	(3 << 4)
#define TOKEN_SOF	(4 << 4)
#define TOKEN_ISO_IN	(5 << 4)
#define TOKEN_ISO_OUT	(6 << 4)
#define TOKEN_RSV	(7 << 4)

#define HCNT_SOFSTEP	(1 << 10)
#define HCNT_CANCEL	(1 << 9)
#define HCNT_RETRY	(1 << 8)
#define HCNT_RWKIRE	(1 << 7)
#define HCNT_URIRE	(1 << 6)
#define HCNT_CMPIRE	(1 << 5)
#define HCNT_CNNIRE	(1 << 4)
#define HCNT_DIRE	(1 << 3)
#define HCNT_SOFIRE	(1 << 2)
#define HCNT_URST	(1 << 1)
#define HCNT_HOST	(1 << 0)

#define HSTATE_ALIVE	(1 << 5)
#define HSTATE_CLKSEL	(1 << 4)
#define HSTATE_SOFBUSY	(1 << 3)
#define HSTATE_SUSP	(1 << 2)
#define HSTATE_TMODE	(1 << 1)
#define HSTATE_CSTAT	(1 << 0)

/* Requests: bRequest << 8 | bmRequestType */
#define RH_GET_STATUS           0x0080
#define RH_CLEAR_FEATURE        0x0100
#define RH_SET_FEATURE          0x0300
#define RH_SET_ADDRESS		0x0500
#define RH_GET_DESCRIPTOR	0x0680
#define RH_SET_DESCRIPTOR       0x0700
#define RH_GET_CONFIGURATION	0x0880
#define RH_SET_CONFIGURATION	0x0900
#define RH_GET_STATE            0x0280
#define RH_GET_INTERFACE        0x0A80
#define RH_SET_INTERFACE        0x0B00
#define RH_SYNC_FRAME           0x0C80

#endif	/* __UBOOT_MB9BFXXX_H */
