/*
 * fm3_eth.h - Driver for Fujitsu FM3 Ethernet controller
 *
 * Copyright (C) 2012 Yoshinori Sato <ysato@users.sourceforge.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <netdev.h>
#include <asm/types.h>

#define ETHER_NAME "fm3_eth"

/* Number of supported ports */
#define MAX_PORT_NUM	2

#define FM3_MAC_BASE	0x40064000

#define GMAC_MCR	0x0000
#define GMAC_MFFR	0x0004
#define GMAC_MTHRH	0x0008
#define GMAC_MTHRL	0x000c
#define GMAC_GAR	0x0010
#define GMAC_GDR	0x0014
#define GMAC_FCR	0x0018
#define GMAC_VTR	0x001c
#define GMAC_RWFFR	0x0028
#define GMAC_PMTR	0x002c
#define GMAC_LPICSR	0x0030
#define GMAC_LPITCR	0x0034
#define GMAC_ISR	0x0038
#define GMAC_IMR	0x003c
#define GMAC_MAR0H	0x0040
#define GMAC_MAR0L	0x0044
#define GMAC_MAR1H	0x0048
#define GMAC_MAR1L	0x004c
#define GMAC_MAR2H	0x0050
#define GMAC_MAR2L	0x0054
#define GMAC_MAR3H	0x0058
#define GMAC_MAR3L	0x005c
#define GMAC_MAR4H	0x0060
#define GMAC_MAR4L	0x0064
#define GMAC_MAR5H	0x0068
#define GMAC_MAR5L	0x006c
#define GMAC_MAR6H	0x0070
#define GMAC_MAR6L	0x0074
#define GMAC_MAR7H	0x0078
#define GMAC_MAR7L	0x007c
#define GMAC_MAR8H	0x0080
#define GMAC_MAR8L	0x0084
#define GMAC_MAR9H	0x0088
#define GMAC_MAR9L	0x008c
#define GMAC_MAR10H	0x0090
#define GMAC_MAR10L	0x0094
#define GMAC_MAR11H	0x0098
#define GMAC_MAR11L	0x009c
#define GMAC_MAR12H	0x00a0
#define GMAC_MAR12L	0x00a4
#define GMAC_MAR13H	0x00a8
#define GMAC_MAR13L	0x00ac
#define GMAC_MAR14H	0x00b0
#define GMAC_MAR14L	0x00b4
#define GMAC_MAR15H	0x00b8
#define GMAC_MAR15L	0x00bc
#define GMAC_MAR16H	0x0800
#define GMAC_MAR16L	0x0804
#define GMAC_MAR17H	0x0808
#define GMAC_MAR17L	0x080c
#define GMAC_MAR18H	0x0810
#define GMAC_MAR18L	0x0814
#define GMAC_MAR19H	0x0818
#define GMAC_MAR19L	0x081c
#define GMAC_MAR20H	0x0820
#define GMAC_MAR20L	0x0824
#define GMAC_MAR21H	0x0828
#define GMAC_MAR21L	0x082c
#define GMAC_MAR22H	0x0830
#define GMAC_MAR22L	0x0834
#define GMAC_MAR23H	0x0838
#define GMAC_MAR23L	0x083c
#define GMAC_MAR24H	0x0840
#define GMAC_MAR24L	0x0844
#define GMAC_MAR25H	0x0848
#define GMAC_MAR25L	0x084c
#define GMAC_MAR26H	0x0850
#define GMAC_MAR26L	0x0854
#define GMAC_MAR27H	0x0858
#define GMAC_MAR27L	0x085c
#define GMAC_MAR28H	0x0860
#define GMAC_MAR28L	0x0864
#define GMAC_MAR29H	0x0868
#define GMAC_MAR29L	0x086c
#define GMAC_MAR30H	0x0870
#define GMAC_MAR30L	0x0874
#define GMAC_MAR31H	0x0878
#define GMAC_MAR31L	0x087c
#define GMAC_RGSR	0x00d8
#define GMAC_TSCR	0x0700
#define GMAC_SSIR	0x0704
#define GMAC_STSR	0x0708
#define GMAC_STNR	0x070c
#define GMAC_STSUR	0x0710
#define GMAC_STNUR	0x0714
#define GMAC_TSAR	0x0718
#define GMAC_TTSR	0x071c
#define GMAC_TTNR	0x0720
#define GMAC_STHWSR	0x0724
#define GMAC_TSR	0x0728
#define GMAC_PPSCR	0x072c
#define GMAC_ATNR	0x0730
#define GMAC_ATSR	0x0734
#define DMAC_BMR	0x1000
#define DMAC_TPDR	0x1004
#define DMAC_RPDR	0x1008
#define DMAC_RDLAR	0x100c
#define DMAC_TDLAR	0x1010
#define DMAC_SR		0x1014
#define DMAC_OMR	0x1018
#define DMAC_IER	0x101c
#define DMAC_MFBOCR	0x1020
#define DMAC_RIWTR	0x1024
#define DMAC_AHBSR	0x102c
#define DMAC_CHTDR	0x1048
#define DMAC_CHRDR	0x104c
#define DMAC_CHTBAR	0x1050
#define DMAC_CHRBAR	0x1054
#define MMC_CTRL	0x0100
#define MMC_INTR_RX	0x0104
#define MMC_INTR_TX	0x0108
#define MMC_INTR_MASK_RX	0x010c
#define MMC_INTR_MASK_TX	0x0110
#define MMC_IPC_INTR_MASK_RX	0x0200
#define MMC_IPC_INTR_RX		0x0208

#define NR_TX_DESC (4)
#define NR_RX_DESC (8)

struct tx_desc {
	unsigned long tdes0;
	unsigned short tbs[2];
	void *buf[2];
} __attribute__((packed));

struct rx_desc {
	unsigned long rdes0;
	unsigned short rbs[2];
	void *buf[2];

} __attribute__((packed));

struct fm3_desc {
	struct tx_desc tx[NR_TX_DESC];
	struct rx_desc rx[NR_RX_DESC];
	struct tx_desc *cur_tx;
	struct rx_desc *cur_rx;
};
