;; Faraday FA626TE Pipeline Description
;; Copyright (C) 2010-2015 Free Software Foundation, Inc.
;; Written by Mingfeng Wu, based on ARM926EJ-S Pipeline Description.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.  */

;; These descriptions are based on the information contained in the
;; FMP626 Core Design Note, Copyright (c) 2010 Faraday Technology Corp.

;; Pipeline architecture
;;	S	E	M	W(Q1)	Q2
;;   ___________________________________________
;;    shifter alu
;;    mul1    mul2    mul3
;;    ld/st1  ld/st2  ld/st3  ld/st4  ld/st5

;; This automaton provides a pipeline description for the Faraday
;; FMP626 core.
;;
;; The model given here assumes that the condition for all conditional
;; instructions is "true", i.e., that all of the instructions are
;; actually executed.

(define_automaton "fmp626")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Pipelines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; There is a single pipeline
;;
;;   The ALU pipeline has fetch, decode, execute, memory, and
;;   write stages.  We only need to model the execute, memory and write
;;   stages.

(define_cpu_unit "fmp626_core" "fmp626")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ALU Instructions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ALU instructions require two cycles to execute, and use the ALU
;; pipeline in each of the three stages.  The results are available
;; after the execute stage has finished.
;;
;; If the destination register is the PC, the pipelines are stalled
;; for several cycles.  That case is not modeled here.

;; ALU operations
(define_insn_reservation "mp626_alu_op" 1
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "alu_imm,alus_imm,alu_sreg,alus_sreg,\
                       logic_imm,logics_imm,logic_reg,logics_reg,\
                       adc_imm,adcs_imm,adc_reg,adcs_reg,\
                       adr,bfm,rev,\
                       shift_imm,shift_reg,\
                       mov_imm,mov_reg,mvn_imm,mvn_reg"))
 "fmp626_core")

(define_insn_reservation "mp626_alu_shift_op" 2
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "alu_shift_imm,logic_shift_imm,alus_shift_imm,logics_shift_imm,\
                       alu_shift_reg,logic_shift_reg,alus_shift_reg,logics_shift_reg,\
                       extend,\
                       mov_shift,mov_shift_reg,\
                       mvn_shift,mvn_shift_reg"))
 "fmp626_core")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Multiplication Instructions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn_reservation "mp626_mult1" 2
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "smulwy,smlawy,smulxy,smlaxy"))
 "fmp626_core")

(define_insn_reservation "mp626_mult2" 2
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "mul,mla"))
 "fmp626_core")

(define_insn_reservation "mp626_mult3" 3
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "muls,mlas,smull,smlal,umull,umlal,smlalxy,smlawx"))
 "fmp626_core*2")

(define_insn_reservation "mp626_mult4" 4
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "smulls,smlals,umulls,umlals"))
 "fmp626_core*3")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Load/Store Instructions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; The models for load/store instructions do not accurately describe
;; the difference between operations with a base register writeback
;; (such as "ldm!").  These models assume that all memory references
;; hit in dcache.

(define_insn_reservation "mp626_load1_op" 5
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "load1,load_byte"))
 "fmp626_core")

(define_insn_reservation "mp626_load2_op" 6
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "load2,load3"))
 "fmp626_core*2")

(define_insn_reservation "mp626_load3_op" 7
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "load4"))
 "fmp626_core*3")

(define_insn_reservation "mp626_store1_op" 0
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "store1"))
 "fmp626_core")

(define_insn_reservation "mp626_store2_op" 1
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "store2,store3"))
 "fmp626_core*2")

(define_insn_reservation "mp626_store3_op" 2
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "store4"))
 "fmp626_core*3")

(define_bypass 1 "mp626_load1_op,mp626_load2_op,mp626_load3_op"
                 "mp626_store1_op,mp626_store2_op,mp626_store3_op"
                 "arm_no_early_store_addr_dep")
(define_bypass 1 "mp626_alu_op,mp626_alu_shift_op,mp626_mult1,mp626_mult2,\
                  mp626_mult3,mp626_mult4" "mp626_store1_op"
                 "arm_no_early_store_addr_dep")
(define_bypass 1 "mp626_alu_shift_op" "mp626_alu_op")
(define_bypass 1 "mp626_alu_shift_op" "mp626_alu_shift_op"
                 "arm_no_early_alu_shift_dep")
(define_bypass 1 "mp626_mult1,mp626_mult2" "mp626_alu_shift_op"
                 "arm_no_early_alu_shift_dep")
(define_bypass 2 "mp626_mult3" "mp626_alu_shift_op"
                 "arm_no_early_alu_shift_dep")
(define_bypass 3 "mp626_mult4" "mp626_alu_shift_op"
                 "arm_no_early_alu_shift_dep")
(define_bypass 1 "mp626_mult1,mp626_mult2" "mp626_alu_op")
(define_bypass 2 "mp626_mult3" "mp626_alu_op")
(define_bypass 3 "mp626_mult4" "mp626_alu_op")
(define_bypass 4 "mp626_load1_op" "mp626_alu_op")
(define_bypass 5 "mp626_load2_op" "mp626_alu_op")
(define_bypass 6 "mp626_load3_op" "mp626_alu_op")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Branch and Call Instructions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Branch instructions are difficult to model accurately.  The FMP626
;; core can predict most branches.  If the branch is predicted
;; correctly, and predicted early enough, the branch can be completely
;; eliminated from the instruction stream.  Some branches can
;; therefore appear to require zero cycle to execute.  We assume that
;; all branches are predicted correctly, and that the latency is
;; therefore the minimum value.

(define_insn_reservation "mp626_branch_op" 0
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "branch"))
 "fmp626_core")

;; The latency for a call is actually the latency when the result is available.
;; i.e. R0 ready for int return value.
(define_insn_reservation "mp626_call_op" 1
 (and (eq_attr "tune" "fmp626")
      (eq_attr "type" "call"))
 "fmp626_core")

