/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2015 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-asm.h"


const aarch64_opcode *
aarch64_find_real_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the real opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3:	/* ngc */
    case 2:	/* sbc */
      value = 2;	/* --> sbc.  */
      break;
    case 5:	/* ngcs */
    case 4:	/* sbcs */
      value = 4;	/* --> sbcs.  */
      break;
    case 8:	/* cmn */
    case 7:	/* adds */
      value = 7;	/* --> adds.  */
      break;
    case 11:	/* cmp */
    case 10:	/* subs */
      value = 10;	/* --> subs.  */
      break;
    case 13:	/* mov */
    case 12:	/* add */
      value = 12;	/* --> add.  */
      break;
    case 15:	/* cmn */
    case 14:	/* adds */
      value = 14;	/* --> adds.  */
      break;
    case 18:	/* cmp */
    case 17:	/* subs */
      value = 17;	/* --> subs.  */
      break;
    case 21:	/* cmn */
    case 20:	/* adds */
      value = 20;	/* --> adds.  */
      break;
    case 23:	/* neg */
    case 22:	/* sub */
      value = 22;	/* --> sub.  */
      break;
    case 26:	/* negs */
    case 25:	/* cmp */
    case 24:	/* subs */
      value = 24;	/* --> subs.  */
      break;
    case 141:	/* mov */
    case 140:	/* umov */
      value = 140;	/* --> umov.  */
      break;
    case 143:	/* mov */
    case 142:	/* ins */
      value = 142;	/* --> ins.  */
      break;
    case 145:	/* mov */
    case 144:	/* ins */
      value = 144;	/* --> ins.  */
      break;
    case 206:	/* mvn */
    case 205:	/* not */
      value = 205;	/* --> not.  */
      break;
    case 261:	/* mov */
    case 260:	/* orr */
      value = 260;	/* --> orr.  */
      break;
    case 318:	/* sxtl */
    case 317:	/* sshll */
      value = 317;	/* --> sshll.  */
      break;
    case 320:	/* sxtl2 */
    case 319:	/* sshll2 */
      value = 319;	/* --> sshll2.  */
      break;
    case 340:	/* uxtl */
    case 339:	/* ushll */
      value = 339;	/* --> ushll.  */
      break;
    case 342:	/* uxtl2 */
    case 341:	/* ushll2 */
      value = 341;	/* --> ushll2.  */
      break;
    case 437:	/* mov */
    case 436:	/* dup */
      value = 436;	/* --> dup.  */
      break;
    case 506:	/* sxtw */
    case 505:	/* sxth */
    case 504:	/* sxtb */
    case 507:	/* asr */
    case 503:	/* sbfx */
    case 502:	/* sbfiz */
    case 501:	/* sbfm */
      value = 501;	/* --> sbfm.  */
      break;
    case 510:	/* bfc */
    case 511:	/* bfxil */
    case 509:	/* bfi */
    case 508:	/* bfm */
      value = 508;	/* --> bfm.  */
      break;
    case 516:	/* uxth */
    case 515:	/* uxtb */
    case 518:	/* lsr */
    case 517:	/* lsl */
    case 514:	/* ubfx */
    case 513:	/* ubfiz */
    case 512:	/* ubfm */
      value = 512;	/* --> ubfm.  */
      break;
    case 536:	/* cset */
    case 535:	/* cinc */
    case 534:	/* csinc */
      value = 534;	/* --> csinc.  */
      break;
    case 539:	/* csetm */
    case 538:	/* cinv */
    case 537:	/* csinv */
      value = 537;	/* --> csinv.  */
      break;
    case 541:	/* cneg */
    case 540:	/* csneg */
      value = 540;	/* --> csneg.  */
      break;
    case 559:	/* rev */
    case 560:	/* rev64 */
      value = 559;	/* --> rev.  */
      break;
    case 567:	/* lsl */
    case 566:	/* lslv */
      value = 566;	/* --> lslv.  */
      break;
    case 569:	/* lsr */
    case 568:	/* lsrv */
      value = 568;	/* --> lsrv.  */
      break;
    case 571:	/* asr */
    case 570:	/* asrv */
      value = 570;	/* --> asrv.  */
      break;
    case 573:	/* ror */
    case 572:	/* rorv */
      value = 572;	/* --> rorv.  */
      break;
    case 583:	/* mul */
    case 582:	/* madd */
      value = 582;	/* --> madd.  */
      break;
    case 585:	/* mneg */
    case 584:	/* msub */
      value = 584;	/* --> msub.  */
      break;
    case 587:	/* smull */
    case 586:	/* smaddl */
      value = 586;	/* --> smaddl.  */
      break;
    case 589:	/* smnegl */
    case 588:	/* smsubl */
      value = 588;	/* --> smsubl.  */
      break;
    case 592:	/* umull */
    case 591:	/* umaddl */
      value = 591;	/* --> umaddl.  */
      break;
    case 594:	/* umnegl */
    case 593:	/* umsubl */
      value = 593;	/* --> umsubl.  */
      break;
    case 605:	/* ror */
    case 604:	/* extr */
      value = 604;	/* --> extr.  */
      break;
    case 812:	/* bic */
    case 811:	/* and */
      value = 811;	/* --> and.  */
      break;
    case 814:	/* mov */
    case 813:	/* orr */
      value = 813;	/* --> orr.  */
      break;
    case 817:	/* tst */
    case 816:	/* ands */
      value = 816;	/* --> ands.  */
      break;
    case 822:	/* uxtw */
    case 821:	/* mov */
    case 820:	/* orr */
      value = 820;	/* --> orr.  */
      break;
    case 824:	/* mvn */
    case 823:	/* orn */
      value = 823;	/* --> orn.  */
      break;
    case 828:	/* tst */
    case 827:	/* ands */
      value = 827;	/* --> ands.  */
      break;
    case 954:	/* staddb */
    case 858:	/* ldaddb */
      value = 858;	/* --> ldaddb.  */
      break;
    case 955:	/* staddh */
    case 859:	/* ldaddh */
      value = 859;	/* --> ldaddh.  */
      break;
    case 956:	/* stadd */
    case 860:	/* ldadd */
      value = 860;	/* --> ldadd.  */
      break;
    case 957:	/* staddlb */
    case 862:	/* ldaddlb */
      value = 862;	/* --> ldaddlb.  */
      break;
    case 958:	/* staddlh */
    case 865:	/* ldaddlh */
      value = 865;	/* --> ldaddlh.  */
      break;
    case 959:	/* staddl */
    case 868:	/* ldaddl */
      value = 868;	/* --> ldaddl.  */
      break;
    case 960:	/* stclrb */
    case 870:	/* ldclrb */
      value = 870;	/* --> ldclrb.  */
      break;
    case 961:	/* stclrh */
    case 871:	/* ldclrh */
      value = 871;	/* --> ldclrh.  */
      break;
    case 962:	/* stclr */
    case 872:	/* ldclr */
      value = 872;	/* --> ldclr.  */
      break;
    case 963:	/* stclrlb */
    case 874:	/* ldclrlb */
      value = 874;	/* --> ldclrlb.  */
      break;
    case 964:	/* stclrlh */
    case 877:	/* ldclrlh */
      value = 877;	/* --> ldclrlh.  */
      break;
    case 965:	/* stclrl */
    case 880:	/* ldclrl */
      value = 880;	/* --> ldclrl.  */
      break;
    case 966:	/* steorb */
    case 882:	/* ldeorb */
      value = 882;	/* --> ldeorb.  */
      break;
    case 967:	/* steorh */
    case 883:	/* ldeorh */
      value = 883;	/* --> ldeorh.  */
      break;
    case 968:	/* steor */
    case 884:	/* ldeor */
      value = 884;	/* --> ldeor.  */
      break;
    case 969:	/* steorlb */
    case 886:	/* ldeorlb */
      value = 886;	/* --> ldeorlb.  */
      break;
    case 970:	/* steorlh */
    case 889:	/* ldeorlh */
      value = 889;	/* --> ldeorlh.  */
      break;
    case 971:	/* steorl */
    case 892:	/* ldeorl */
      value = 892;	/* --> ldeorl.  */
      break;
    case 972:	/* stsetb */
    case 894:	/* ldsetb */
      value = 894;	/* --> ldsetb.  */
      break;
    case 973:	/* stseth */
    case 895:	/* ldseth */
      value = 895;	/* --> ldseth.  */
      break;
    case 974:	/* stset */
    case 896:	/* ldset */
      value = 896;	/* --> ldset.  */
      break;
    case 975:	/* stsetlb */
    case 898:	/* ldsetlb */
      value = 898;	/* --> ldsetlb.  */
      break;
    case 976:	/* stsetlh */
    case 901:	/* ldsetlh */
      value = 901;	/* --> ldsetlh.  */
      break;
    case 977:	/* stsetl */
    case 904:	/* ldsetl */
      value = 904;	/* --> ldsetl.  */
      break;
    case 978:	/* stsmaxb */
    case 906:	/* ldsmaxb */
      value = 906;	/* --> ldsmaxb.  */
      break;
    case 979:	/* stsmaxh */
    case 907:	/* ldsmaxh */
      value = 907;	/* --> ldsmaxh.  */
      break;
    case 980:	/* stsmax */
    case 908:	/* ldsmax */
      value = 908;	/* --> ldsmax.  */
      break;
    case 981:	/* stsmaxlb */
    case 910:	/* ldsmaxlb */
      value = 910;	/* --> ldsmaxlb.  */
      break;
    case 982:	/* stsmaxlh */
    case 913:	/* ldsmaxlh */
      value = 913;	/* --> ldsmaxlh.  */
      break;
    case 983:	/* stsmaxl */
    case 916:	/* ldsmaxl */
      value = 916;	/* --> ldsmaxl.  */
      break;
    case 984:	/* stsminb */
    case 918:	/* ldsminb */
      value = 918;	/* --> ldsminb.  */
      break;
    case 985:	/* stsminh */
    case 919:	/* ldsminh */
      value = 919;	/* --> ldsminh.  */
      break;
    case 986:	/* stsmin */
    case 920:	/* ldsmin */
      value = 920;	/* --> ldsmin.  */
      break;
    case 987:	/* stsminlb */
    case 922:	/* ldsminlb */
      value = 922;	/* --> ldsminlb.  */
      break;
    case 988:	/* stsminlh */
    case 925:	/* ldsminlh */
      value = 925;	/* --> ldsminlh.  */
      break;
    case 989:	/* stsminl */
    case 928:	/* ldsminl */
      value = 928;	/* --> ldsminl.  */
      break;
    case 990:	/* stumaxb */
    case 930:	/* ldumaxb */
      value = 930;	/* --> ldumaxb.  */
      break;
    case 991:	/* stumaxh */
    case 931:	/* ldumaxh */
      value = 931;	/* --> ldumaxh.  */
      break;
    case 992:	/* stumax */
    case 932:	/* ldumax */
      value = 932;	/* --> ldumax.  */
      break;
    case 993:	/* stumaxlb */
    case 934:	/* ldumaxlb */
      value = 934;	/* --> ldumaxlb.  */
      break;
    case 994:	/* stumaxlh */
    case 937:	/* ldumaxlh */
      value = 937;	/* --> ldumaxlh.  */
      break;
    case 995:	/* stumaxl */
    case 940:	/* ldumaxl */
      value = 940;	/* --> ldumaxl.  */
      break;
    case 996:	/* stuminb */
    case 942:	/* lduminb */
      value = 942;	/* --> lduminb.  */
      break;
    case 997:	/* stuminh */
    case 943:	/* lduminh */
      value = 943;	/* --> lduminh.  */
      break;
    case 998:	/* stumin */
    case 944:	/* ldumin */
      value = 944;	/* --> ldumin.  */
      break;
    case 999:	/* stuminlb */
    case 946:	/* lduminlb */
      value = 946;	/* --> lduminlb.  */
      break;
    case 1000:	/* stuminlh */
    case 949:	/* lduminlh */
      value = 949;	/* --> lduminlh.  */
      break;
    case 1001:	/* stuminl */
    case 952:	/* lduminl */
      value = 952;	/* --> lduminl.  */
      break;
    case 1003:	/* mov */
    case 1002:	/* movn */
      value = 1002;	/* --> movn.  */
      break;
    case 1005:	/* mov */
    case 1004:	/* movz */
      value = 1004;	/* --> movz.  */
      break;
    case 1016:	/* sevl */
    case 1015:	/* sev */
    case 1014:	/* wfi */
    case 1013:	/* wfe */
    case 1012:	/* yield */
    case 1011:	/* nop */
    case 1010:	/* hint */
      value = 1010;	/* --> hint.  */
      break;
    case 1025:	/* tlbi */
    case 1024:	/* ic */
    case 1023:	/* dc */
    case 1022:	/* at */
    case 1021:	/* sys */
      value = 1021;	/* --> sys.  */
      break;
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const char*
aarch64_insert_operand (const aarch64_operand *self,
			   const aarch64_opnd_info *info,
			   aarch64_insn *code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 14:
    case 15:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 35:
    case 36:
      return aarch64_ins_regno (self, info, code, inst);
    case 12:
      return aarch64_ins_reg_extended (self, info, code, inst);
    case 13:
      return aarch64_ins_reg_shifted (self, info, code, inst);
    case 18:
      return aarch64_ins_ft (self, info, code, inst);
    case 28:
    case 29:
    case 30:
      return aarch64_ins_reglane (self, info, code, inst);
    case 31:
      return aarch64_ins_reglist (self, info, code, inst);
    case 32:
      return aarch64_ins_ldst_reglist (self, info, code, inst);
    case 33:
      return aarch64_ins_ldst_reglist_r (self, info, code, inst);
    case 34:
      return aarch64_ins_ldst_elemlist (self, info, code, inst);
    case 37:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 67:
    case 68:
    case 69:
    case 70:
      return aarch64_ins_imm (self, info, code, inst);
    case 38:
    case 39:
      return aarch64_ins_advsimd_imm_shift (self, info, code, inst);
    case 40:
    case 41:
    case 42:
      return aarch64_ins_advsimd_imm_modified (self, info, code, inst);
    case 59:
      return aarch64_ins_limm (self, info, code, inst);
    case 60:
      return aarch64_ins_aimm (self, info, code, inst);
    case 61:
      return aarch64_ins_imm_half (self, info, code, inst);
    case 62:
      return aarch64_ins_fbits (self, info, code, inst);
    case 64:
    case 65:
      return aarch64_ins_cond (self, info, code, inst);
    case 71:
    case 77:
      return aarch64_ins_addr_simple (self, info, code, inst);
    case 72:
      return aarch64_ins_addr_regoff (self, info, code, inst);
    case 73:
    case 74:
    case 75:
      return aarch64_ins_addr_simm (self, info, code, inst);
    case 76:
      return aarch64_ins_addr_uimm12 (self, info, code, inst);
    case 78:
      return aarch64_ins_simd_addr_post (self, info, code, inst);
    case 79:
      return aarch64_ins_sysreg (self, info, code, inst);
    case 80:
      return aarch64_ins_pstatefield (self, info, code, inst);
    case 81:
    case 82:
    case 83:
    case 84:
      return aarch64_ins_sysins_op (self, info, code, inst);
    case 85:
    case 86:
      return aarch64_ins_barrier (self, info, code, inst);
    case 87:
      return aarch64_ins_prfop (self, info, code, inst);
    default: assert (0); abort ();
    }
}
