// Oo̓NXwb_[
// Compiler : Visual Studio/C++ 2008

#pragma once
#include <Windows.h>
#include <tchar.h>

#define LOG_BUFSIZE	(200)
#define LOG_FILENAME	(_T("debug.log"))

class CLogManager
{
protected:
	TCHAR m_sLogPath[MAX_PATH];	// Ot@CpX
	HANDLE m_hLogFile;			// Ot@Cnh
	CRITICAL_SECTION m_cs;		// NeBJZNV

public:
	CLogManager();
	virtual ~CLogManager();
	// Ot@C쐬
	DWORD MakeLogFile();
	// Oo
	DWORD PrintLog(LPCTSTR sText);
	// tOo
	DWORD PrintLogF(LPCTSTR sFormat, ...);
	// g[XOo
	DWORD PrintTraceLog(LPCTSTR sFile, int nLine, LPCTSTR sText);
	// tg[XOo
	DWORD PrintTraceLogF(LPCTSTR sFile, int nLine, LPCTSTR sFormat, ...);
	// WinG[bZ[WOo
	DWORD PrintWinError(LPCTSTR sText, DWORD code);
};

// 쐬ςCLogManagerIuWFNg
extern CLogManager LogMng;

// Oo̓}N
#if defined(_DEBUG) || defined(DEBUG)
#define LOG_DEBUG(a)	LogMng.PrintTraceLog(_T(__FILE__), __LINE__, (a))
#define LOGF_DEBUG(fmt, ...)	LogMng.PrintTraceLogF(_T(__FILE__), __LINE__, fmt, __VA_ARGS__)
#else
#define LOG_DEBUG(a)
#define LOGF_DEBUG(fmt, ...)
#endif
#define LOG_ERROR(a)	LogMng.PrintLog((a))
#define LOGF_ERROR(fmt, ...)	LogMng.PrintLogF(fmt, __VA_ARGS__)
#define LOG_WIN_ERROR(a)	LogMng.PrintWinError(a, ::GetLastError())