#pragma once


// WNXev[g
template <typename Type> class CISize;
template <typename Type> class CIPoint
{
public:
	Type x;
	Type y;
public:
	// RXgN^
	CIPoint();
	CIPoint(Type dx, Type dy);
	CIPoint(const CIPoint& dp);
	// 
	bool operator==(CIPoint dp) const;
	bool operator!=(CIPoint dp) const;
	CIPoint operator+=(CISize<Type> ds);
	CIPoint operator-=(CISize<Type> ds);
	CIPoint operator+(CISize<Type> ds);
	CIPoint operator-(CISize<Type> ds);
	CIPoint operator-();
	CISize<Type> operator-(CIPoint dp);
};

/* TCYNXev[g */
template <typename Type> class CISize
{
public:
	Type cx;
	Type cy;
public:
	// RXgN^
	CISize();
	CISize(Type dcx, Type dcy);
	CISize(const CISize& ds);
	// 
	bool operator==(CISize ds) const;
	bool operator!=(CISize ds) const;
	CISize operator+=(CISize ds);
	CISize operator-=(CISize ds);
	CISize operator+(CISize ds);
	CISize operator-(CISize ds);
	CISize operator-();
};

/* NbsO֐ev[g */
template <typename Type>
bool cross_point(CIPoint<Type> a1, CIPoint<Type> a2, CIPoint<Type> b1, CIPoint<Type> b2, CIPoint<Type>& q);
template <typename Type>
bool cripping(CIPoint<Type> c1, CIPoint<Type> c2, CIPoint<Type>& q1, CIPoint<Type>& q2);
template <typename Type>
bool cripping(CIPoint<Type> a, CIPoint<Type> b, CIPoint<Type> c, CIPoint<Type>& q1, CIPoint<Type>& q2);
template <typename Type>
bool is_in(CIPoint<Type> a, CIPoint<Type> b, CIPoint<Type> c, CIPoint<Type> d);
