#pragma once
#include <windows.h>
#include <memory>
#include "IGraph.h"

// chaf[^
//   32bit/pixelf[^݈̂
class CDIBData
{
public:
	enum eMergeOption : DWORD
	{
		MOP_NONE	= 0x00000000,
		MOP_LOGICAL	= 0x00000001,
		MOP_TRANS	= 0x00000002,
	} m_mop;
	DWORD m_logic;
	DWORD m_transcolor;

protected:
	BITMAPINFO m_info;
	LPDWORD m_pbits;
	int m_numbits;

public:
	CDIBData();
	CDIBData(int width, int height);
	CDIBData(const CDIBData& src);
	virtual ~CDIBData();
	void Create(int width, int height);
	void Clear(DWORD col=0);
	int GetDIBits(HDC hdc, HBITMAP hbmp);
	int SetDIBits(HDC hdc, HBITMAP hbmp);
	DWORD SetPixcel(int x, int y, DWORD col);
	DWORD GetPixcel(int x, int y);
	void FillRect(int x1, int y1, int x2, int y2, DWORD col);
	void DrawDot(int x, int y, int size, DWORD col);
	void DrawLine(int x1, int y1, int x2, int y2, int size, DWORD col);
	void DrawDotS(double x, double y, double size, DWORD col);
	void DrawLineS(double x1, double y1, double x2, double y2, DWORD col);
	void DrawLineS(double x1, double y1, double x2, double y2, double size, DWORD col);
	int Copy(HWND hwnd);
	int Merge(const CDIBData& dib);

	CDIBData& operator=(const CDIBData src);

	static DWORD _RGB(DWORD r, DWORD g, DWORD b)
	{
		return ((BYTE)b) | ((WORD)((BYTE)g) << 8) | ((DWORD)((BYTE)r) << 16);
	}
	static DWORD _GetRValue(DWORD rgb)
	{
		return LOBYTE(rgb >> 16);
	}
	static DWORD _GetGValue(DWORD rgb)
	{
		return LOBYTE(((WORD)rgb) >> 8);
	}
	static DWORD _GetBValue(DWORD rgb)
	{
		return LOBYTE(rgb);
	}
	static DWORD _RGB2DIB(COLORREF rgb)
	{
		return _RGB(GetRValue(rgb), GetGValue(rgb), GetBValue(rgb));
	}
	static DWORD _RGB2DDB(DWORD rgb)
	{
		return RGB(_GetRValue(rgb), _GetGValue(rgb), _GetBValue(rgb));
	}
	static DWORD _AColor(DWORD rgb, double a);
	static DWORD _MColor(DWORD rgb1, DWORD rgb2, double a);
};
