#pragma once
#include <initializer_list>

/* sNX */
template <typename Type2> class CMatrix;
template <typename Type2> CMatrix<Type2> operator*(Type2, const CMatrix<Type2>&);
template <typename Type> class CMatrix
{
protected:
	int m_rows;
	int m_cols;
	Type* m_element;

protected:
	// ftHgRXgN^
	CMatrix();

public:
	// RXgN^
	CMatrix(int arg1, int arg2);
	CMatrix(int arg1, int arg2, std::initializer_list<Type> init);
	CMatrix(std::initializer_list< std::initializer_list<Type> > init);
	// Rs[RXgN^
	CMatrix(const CMatrix<Type>& src);
	// fXgN^
	virtual ~CMatrix();
	// 
	virtual void Initialize(void);
	// vpeB
	int Rows(void) const;
	int Cols(void) const;
	// vf̎o
	Type Get(int row, int col) const;
	// vf̐ݒ
	void Set(int row, int col, Type data);
	// Zq
	CMatrix<Type> operator=(const CMatrix<Type>& m);
	// Zq
	bool operator==(const CMatrix<Type>& m) const;
	// XJ{
	CMatrix<Type> operator*(Type a) const;
	template <typename Type2>
	friend CMatrix<Type2> operator*(Type2 a, const CMatrix<Type2>& m);
	// 
	CMatrix<Type> operator+() const;
	// 
	CMatrix<Type> operator-() const;
	// a
	CMatrix<Type> operator+(const CMatrix<Type>& m) const;
	CMatrix<Type> operator+=(const CMatrix<Type>& m);
	// 
	CMatrix<Type> operator-(const CMatrix<Type>& m) const;
	CMatrix<Type> operator-=(const CMatrix<Type>& m);
	// Os
	CMatrix Zero(void) const;
	// 
	CMatrix operator*(const CMatrix& m) const;
	CMatrix operator*=(const CMatrix& m);
};

