// Clock.cpp : AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "Clock.h"
#include "LogManager.h"
#include "DIBData.h"
#include <WindowsX.h>
#define _USE_MATH_DEFINES
#include <math.h>

#define MAX_LOADSTRING 100

// O[oϐ:
HINSTANCE hInst;                                // ݂̃C^[tFCX
WCHAR szTitle[MAX_LOADSTRING];                  // ^Cg o[̃eLXg
WCHAR szWindowClass[MAX_LOADSTRING];            // C EBhE NX
#define VIEW_SIZE	320
#define POINT_COUNT	64

COLORREF colFrame = RGB(191, 191, 191);
COLORREF colFace = RGB(31, 31, 127);
COLORREF colText = RGB(255, 255, 255);
COLORREF colHour = RGB(175, 255, 143);
COLORREF colMin = RGB(223, 239, 143);
COLORREF colSec = RGB(255, 255, 255);
COLORREF colZiku = RGB(95, 31, 255);
TCHAR szMessage[] = _T("hbOňړ\n\nENbNŏI");
CDIBData dibFace;								// Ղchaf[^
CDIBData dibHand;								// Ձ{jchaf[^
CDIBData dibMessage;							// bZ[Wchaf[^
POINT aPoint[POINT_COUNT];
INT aPolyCounts[1];
HRGN hRgn;
int nTimerID = 10001;
int nInterval = 64;

// ̃R[h W[Ɋ܂܂֐̐錾]܂:
ATOM                MyRegisterClass(HINSTANCE hInstance);
BOOL                InitInstance(HINSTANCE, int);
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK		TimerProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
void DrawClock();
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
                     _In_opt_ HINSTANCE hPrevInstance,
                     _In_ LPWSTR    lpCmdLine,
                     _In_ int       nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // TODO: ɃR[h}ĂB
	LOGF_DEBUG(_T("***** Application starting."));

    // O[oĂ܂B
    LoadStringW(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
    LoadStringW(hInstance, IDC_CLOCK, szWindowClass, MAX_LOADSTRING);
    MyRegisterClass(hInstance);

    // AvP[V̏s܂:
    if (!InitInstance (hInstance, nCmdShow))
    {
        return FALSE;
    }

    HACCEL hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_CLOCK));

    MSG msg;

    // C bZ[W [v:
    while (GetMessage(&msg, nullptr, 0, 0))
    {
        if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }
	LOGF_DEBUG(_T("***** Application end."));

    return (int) msg.wParam;
}



//
//  ֐: MyRegisterClass()
//
//  ړI: EBhE NXo^܂B
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
    WNDCLASSEXW wcex;

    wcex.cbSize = sizeof(WNDCLASSEX);

    wcex.style          = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = WndProc;
    wcex.cbClsExtra     = 0;
    wcex.cbWndExtra     = 0;
    wcex.hInstance      = hInstance;
    wcex.hIcon          = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_CLOCK));
    wcex.hCursor        = NULL;
    wcex.hbrBackground  = (HBRUSH)(COLOR_WINDOW+1);
    wcex.lpszMenuName   = MAKEINTRESOURCEW(IDC_CLOCK);
    wcex.lpszClassName  = szWindowClass;
    wcex.hIconSm        = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

    return RegisterClassExW(&wcex);
}

//
//   ֐: InitInstance(HINSTANCE, int)
//
//   ړI: CX^X nhۑāAC EBhE쐬܂B
//
//   Rg:
//
//        ̊֐ŁAO[oϐŃCX^X nhۑA
//        C vO EBhE쐬ѕ\܂B
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   hInst = hInstance; // O[oϐɃCX^Xi[܂B

   HWND hWnd = CreateWindowW(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  ֐: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ړI:    C EBhẼbZ[W܂B
//
//  WM_COMMAND  - AvP[V j[̏
//  WM_PAINT    - C EBhE̕`
//  WM_DESTROY  - ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static SIZE sizeFrame;
	static bool bDrag = false;
	static POINT ptDrag = { 0, 0 };

    switch (message)
    {
	case WM_CREATE:
		{
			LOG_DEBUG(_T("WM_CREATE"));
			dibFace.Create(VIEW_SIZE, VIEW_SIZE);
			dibHand.Create(VIEW_SIZE, VIEW_SIZE);
			dibHand.m_mop = CDIBData::MOP_TRANS;
			dibHand.m_transcolor = CDIBData::_RGB2DIB(colFace);
			dibMessage.Create(VIEW_SIZE, VIEW_SIZE);
			dibMessage.m_mop = CDIBData::MOP_TRANS;
			dibMessage.m_transcolor = 0;
			RECT rectw, rectc;
			::GetWindowRect(hWnd, &rectw);
			::GetClientRect(hWnd, &rectc);
			::MoveWindow(hWnd, rectw.left, rectw.top,
				rectw.right - rectw.left - rectc.right + rectc.left + VIEW_SIZE,
				rectw.bottom - rectw.top - rectc.bottom + rectc.top + VIEW_SIZE,
				FALSE);
			sizeFrame.cx = (rectw.right - rectw.left - rectc.right + rectc.left) / 2;
			sizeFrame.cy = (rectw.bottom - rectw.top - rectc.bottom + rectc.top
				- ::GetSystemMetrics(SM_CYCAPTION) - ::GetSystemMetrics(SM_CYMENU)) / 2;
			LOGF_DEBUG(_T("sizeFrame cx=%d cy=%d"), sizeFrame.cx, sizeFrame.cy);
			HCURSOR hcsr = ::LoadCursor(NULL, IDC_ARROW);
			::SetCursor(hcsr);
			::SetTimer(hWnd, nTimerID, nInterval, (TIMERPROC)TimerProc);
		}
		break;
	case WM_SHOWWINDOW:
		{
			LOG_DEBUG(_T("WM_SHOWWINDOW"));
			for (int i = 0; i < POINT_COUNT; ++i)
			{
				aPoint[i].x = (int)(VIEW_SIZE * cos(2.0*M_PI*i / POINT_COUNT) + VIEW_SIZE) / 2
					+ sizeFrame.cx;
				aPoint[i].y = (int)(VIEW_SIZE * sin(2.0*M_PI*i / POINT_COUNT) + VIEW_SIZE) / 2
					+ ::GetSystemMetrics(SM_CYCAPTION) + ::GetSystemMetrics(SM_CYMENU) + sizeFrame.cy;
			}
			aPolyCounts[0] = POINT_COUNT;
			hRgn = ::CreatePolyPolygonRgn(aPoint, aPolyCounts, 1, WINDING);
			::SetWindowRgn(hWnd, hRgn, false);
			if (::SetWindowPos(
				hWnd,
				HWND_TOPMOST,
				0, 0, 0, 0,
				SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW
				) == 0)
			{
				LOG_WIN_ERROR(_T("SetWindowPos"));
			}
		}
		break;
	case WM_COMMAND:
        {
            int wmId = LOWORD(wParam);
            // Iꂽj[̉:
            switch (wmId)
            {
            case IDM_ABOUT:
				LOG_DEBUG(_T("IDM_ABOUT"));
				DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
                break;
            case IDM_EXIT:
				LOG_DEBUG(_T("IDM_EXIT"));
				DestroyWindow(hWnd);
                break;
            default:
                return DefWindowProc(hWnd, message, wParam, lParam);
            }
        }
        break;
	case WM_ERASEBKGND:
		{
			LOG_DEBUG(_T("WM_ERASEBKGND"));
			HDC hdc = (HDC)wParam;
			HDC hdcWork = ::CreateCompatibleDC(hdc);
			HBITMAP hbmpWork = ::CreateCompatibleBitmap(hdc, VIEW_SIZE, VIEW_SIZE);
			HBITMAP hbmpOld = (HBITMAP)::SelectObject(hdcWork, hbmpWork);
			// g`
			dibFace.Clear(CDIBData::_RGB2DIB(colFrame));
			dibFace.DrawDotS(VIEW_SIZE / 2, VIEW_SIZE / 2, VIEW_SIZE - sizeFrame.cx, CDIBData::_RGB2DIB(colFace));
			dibFace.SetDIBits(hdcWork, hbmpWork);
			// `
			::SetTextColor(hdcWork, colHour);
			::SetBkColor(hdcWork, colFace);
			RECT rect;
			for (int i = 1; i <= 24; ++i)
			{
				TCHAR text[8];
				_stprintf_s(text, sizeof(text)/sizeof(TCHAR), _T("%d"), i);
				ZeroMemory(&rect, sizeof(rect));
				double r = M_PI * 2 * (i + 6) / 24;
				int x = (int)(cos(r) * 100);
				int y = (int)(sin(r) * 100);
				::DrawText(hdcWork, text, _tcslen(text), &rect, DT_CALCRECT | DT_CENTER | DT_EDITCONTROL);
				rect.left = (VIEW_SIZE - rect.right) / 2 + x;
				rect.right += rect.left;
				rect.top = (VIEW_SIZE - rect.bottom) / 2 + y;
				rect.bottom += rect.top;
				::DrawText(hdcWork, text, _tcslen(text), &rect, DT_CENTER | DT_EDITCONTROL);
			}
			// `
			::SetTextColor(hdcWork, colMin);
			::SetBkColor(hdcWork, colFace);
			for (int i = 0; i < 60; i+=5)
			{
				TCHAR text[8];
				_stprintf_s(text, sizeof(text) / sizeof(TCHAR), _T("%d"), i);
				ZeroMemory(&rect, sizeof(rect));
				double r = M_PI * 2 * (i - 15) / 60;
				int x = (int)(cos(r) * 130);
				int y = (int)(sin(r) * 130);
				::DrawText(hdcWork, text, _tcslen(text), &rect, DT_CALCRECT | DT_CENTER | DT_EDITCONTROL);
				rect.left = (VIEW_SIZE - rect.right) / 2 + x;
				rect.right += rect.left;
				rect.top = (VIEW_SIZE - rect.bottom) / 2 + y;
				rect.bottom += rect.top;
				::DrawText(hdcWork, text, _tcslen(text), &rect, DT_CENTER | DT_EDITCONTROL);
			}
			// ŉ摜擾
			dibFace.GetDIBits(hdcWork, hbmpWork);
			// EbwW`
			for (int i = 0; i < 60; ++i)
			{
				double r = M_PI * 2 * i / 60;
				int x = (int)(cos(r) * 150) + VIEW_SIZE / 2;
				int y = (int)(sin(r) * 150) + VIEW_SIZE / 2;
				if (i % 5 == 0)
				{
					dibFace.DrawDotS(x, y, 6.0, CDIBData::_RGB2DIB(colSec));
				}
				else
				{
					dibFace.DrawDotS(x, y, 4.0, CDIBData::_RGB2DIB(colSec));
				}
			}
			// bZ[W`
			::GetClientRect(hWnd, &rect);
			HBRUSH hbrs = ::CreateSolidBrush(0);
			::FillRect(hdcWork, &rect, hbrs);
			::DeleteObject(hbrs);
			::SetTextColor(hdcWork, colText);
			::SetBkColor(hdcWork, 0);
			ZeroMemory(&rect, sizeof(rect));
			::DrawText(hdcWork, szMessage, _tcslen(szMessage), &rect, DT_CALCRECT | DT_CENTER | DT_EDITCONTROL);
			rect.left = (VIEW_SIZE - rect.right) / 2;
			rect.right += rect.left;
			rect.top = (VIEW_SIZE - rect.bottom) / 2;
			rect.bottom += rect.top;
			::DrawText(hdcWork, szMessage, _tcslen(szMessage), &rect, DT_CENTER | DT_EDITCONTROL);
			// bZ[W摜擾
			dibMessage.GetDIBits(hdcWork, hbmpWork);
			// IuWFNg폜
			::DeleteObject(::SelectObject(hdcWork, ::GetStockObject(BLACK_PEN)));
			::DeleteObject(::SelectObject(hdcWork, ::GetStockObject(WHITE_BRUSH)));
			::DeleteObject(::SelectObject(hdcWork, hbmpOld));
			::DeleteDC(hdcWork);

			return 1;
		}
		break;
    case WM_PAINT:
		{
 			//LOG_DEBUG(_T("WM_PAINT"));
			PAINTSTRUCT ps;
            HDC hdc = BeginPaint(hWnd, &ps);
            // TODO: HDC gp`R[hɒǉĂ...
			HDC hdcWork = ::CreateCompatibleDC(hdc);
			HBITMAP hbmpWork = ::CreateCompatibleBitmap(hdc, VIEW_SIZE, VIEW_SIZE);
			HBITMAP hbmpOld = (HBITMAP)::SelectObject(hdcWork, hbmpWork);
			POINT pt;
			::GetCursorPos(&pt);
			::ScreenToClient(hWnd, &pt);
			if ((pt.x - (VIEW_SIZE / 2)) * (pt.x - (VIEW_SIZE / 2)) + (pt.y - (VIEW_SIZE / 2)) * (pt.y - (VIEW_SIZE / 2))
				<= (VIEW_SIZE / 2) * (VIEW_SIZE / 2))
			{
				dibHand.Merge(dibMessage);
			}
			dibHand.SetDIBits(hdcWork, hbmpWork);
			::BitBlt(hdc, 0, 0, VIEW_SIZE, VIEW_SIZE, hdcWork, 0, 0, SRCCOPY);
			::DeleteObject(::SelectObject(hdcWork, hbmpOld));
			::DeleteDC(hdcWork);
			EndPaint(hWnd, &ps);
		}
        break;
	case WM_LBUTTONDOWN:
		{
			POINT pt;
			GetCursorPos(&pt);
			LOGF_DEBUG(_T("WM_LBUTTONDOWN  x=%d y=%d"), pt.x, pt.y);
			if (::DragDetect(hWnd, ptDrag))
			{
				TRACKMOUSEEVENT tme;
				ZeroMemory(&tme, sizeof(tme));
				tme.cbSize = sizeof(tme);
				tme.dwFlags = TME_LEAVE;
				tme.hwndTrack = hWnd;
				::TrackMouseEvent(&tme);
				bDrag = true;
				HCURSOR hcsr = ::LoadCursor(NULL, IDC_HAND);
				::SetCursor(hcsr);
				ptDrag = pt;
			}
		}
		break;
	case WM_LBUTTONUP:
		{
			POINT pt;
			GetCursorPos(&pt);
			LOGF_DEBUG(_T("WM_LBUTTONUP  x=%d y=%d"), pt.x, pt.y);
			bDrag = false;
			HCURSOR hcsr = ::LoadCursor(NULL, IDC_ARROW);
			::SetCursor(hcsr);
		}
		break;
	case WM_MOUSEMOVE:
		{
			POINT pt;
			GetCursorPos(&pt);
			//LOGF_DEBUG(_T("WM_MOUSEMOVE  x=%d y=%d"), pt.x, pt.y);
			if (bDrag && ((pt.x != ptDrag.x) || (pt.y != ptDrag.y)))
			{
				RECT rect;
				::GetWindowRect(hWnd, &rect);
				::MoveWindow(hWnd,
					rect.left + pt.x - ptDrag.x,
					rect.top + pt.y - ptDrag.y,
					rect.right - rect.left,
					rect.bottom - rect.top,
					TRUE);
				ptDrag = pt;
			}
		}
		break;
	case WM_MOUSELEAVE:
		{
			LOG_DEBUG(_T("WM_MOUSELEAVE"));
			bDrag = false;
			HCURSOR hcsr = ::LoadCursor(NULL, IDC_ARROW);
			::SetCursor(hcsr);
		}
		break;
	case WM_RBUTTONUP:
		LOG_DEBUG(_T("WM_RBUTTONUP"));
		PostQuitMessage(0);
		break;
	case WM_DESTROY:
		LOG_DEBUG(_T("WM_DESTROY"));
		PostQuitMessage(0);
        break;
    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

BOOL CALLBACK TimerProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	DrawClock();
	::InvalidateRect(hWnd, NULL, FALSE);
	return TRUE;
}

// v`揈
void DrawClock()
{
	static const int MinSec = 60;
	static const int HourMin = 60;
	static const int DayHour = 24;
	static const int NumHour = HourMin * MinSec;
	static const int NumDay = DayHour * NumHour;
	double r[3];
	double x[3], y[3];
	SYSTEMTIME st;
	::GetLocalTime(&st);
	//{
	//	st.wHour = 8;
	//	st.wMinute = 8;
	//	st.wSecond = 18;
	//}
	int num = st.wHour * NumHour + st.wMinute * MinSec + st.wSecond;

	//	
	dibHand.Merge(dibFace);
	//	
	dibHand.DrawDotS(VIEW_SIZE / 2.0, VIEW_SIZE / 2.0, 12.0, CDIBData::_RGB2DIB(colZiku));
	//	j
	r[0] = M_PI * 2 * (num) / NumDay;
	r[1] = M_PI * 2 * (num + 6 * NumHour) / NumDay;
	r[2] = M_PI * 2 * (num + 12 * NumHour) / NumDay;
	x[0] = cos(r[0]) * 3 + VIEW_SIZE / 2;
	y[0] = sin(r[0]) * 3 + VIEW_SIZE / 2;
	x[1] = cos(r[1]) * 95 + VIEW_SIZE / 2;
	y[1] = sin(r[1]) * 95 + VIEW_SIZE / 2;
	x[2] = cos(r[2]) * 3 + VIEW_SIZE / 2;
	y[2] = sin(r[2]) * 3 + VIEW_SIZE / 2;
	dibHand.DrawLineS(x[0], y[0], x[1], y[1], 2.0, CDIBData::_RGB2DIB(colHour));
	dibHand.DrawLineS(x[1], y[1], x[2], y[2], 2.0, CDIBData::_RGB2DIB(colHour));
	dibHand.DrawLineS(x[2], y[2], x[0], y[0], 2.0, CDIBData::_RGB2DIB(colHour));
	//	j
	r[0] = M_PI * 2 * (num) / NumHour;
	r[1] = M_PI * 2 * (num - 15 * MinSec) / NumHour;
	r[2] = M_PI * 2 * (num - 30 * MinSec) / NumHour;
	x[0] = cos(r[0]) * 3 + VIEW_SIZE / 2;
	y[0] = sin(r[0]) * 3 + VIEW_SIZE / 2;
	x[1] = cos(r[1]) * 120 + VIEW_SIZE / 2;
	y[1] = sin(r[1]) * 120 + VIEW_SIZE / 2;
	x[2] = cos(r[2]) * 3 + VIEW_SIZE / 2;
	y[2] = sin(r[2]) * 3 + VIEW_SIZE / 2;
	dibHand.DrawLineS(x[0], y[0], x[1], y[1], 2.0, CDIBData::_RGB2DIB(colMin));
	dibHand.DrawLineS(x[1], y[1], x[2], y[2], 2.0, CDIBData::_RGB2DIB(colMin));
	dibHand.DrawLineS(x[2], y[2], x[0], y[0], 2.0, CDIBData::_RGB2DIB(colMin));
	//	bj
	r[0] = M_PI * 2 * (num - 15) / MinSec;
	r[1] = M_PI * 2 * (num + 15) / MinSec;
	x[0] = cos(r[0]) * 140 + VIEW_SIZE / 2;
	y[0] = sin(r[0]) * 140 + VIEW_SIZE / 2;
	x[1] = cos(r[1]) * 40 + VIEW_SIZE / 2;
	y[1] = sin(r[1]) * 40 + VIEW_SIZE / 2;
	dibHand.DrawLineS(x[0], y[0], x[1], y[1], 2.0, CDIBData::_RGB2DIB(colSec));
	dibHand.DrawDotS(VIEW_SIZE / 2.0, VIEW_SIZE / 2.0, 6.0, CDIBData::_RGB2DIB(colSec));
}

// o[W{bNX̃bZ[W nh[łB
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    UNREFERENCED_PARAMETER(lParam);
    switch (message)
    {
    case WM_INITDIALOG:
        return (INT_PTR)TRUE;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
        {
            EndDialog(hDlg, LOWORD(wParam));
            return (INT_PTR)TRUE;
        }
        break;
    }
    return (INT_PTR)FALSE;
}
