/**
 * 
 */
package jp.sf.yf30.httpserver.openid;

import java.util.Map;

import junit.framework.TestCase;

import org.openid4java.util.HttpClientFactory;
import org.openid4java.util.ProxyProperties;

/**
 * @author fukuyama
 * 
 */
public class OpenidFacadeTest extends TestCase {
	private boolean skip_test = true;

	/**
	 * @param name
	 */
	public OpenidFacadeTest(String name) {
		super(name);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testYahoo() throws Exception {
		if (skip_test)
			return;
		OpenidFacade of = new OpenidFacade("yahoo.co.jp", "http://localhost/");
		String url = of.getDestinationUrl();
		assertEquals("https://open.login.yahooapis.jp/openid/op/auth", url);
		Map<?, ?> map = of.getParameterMap();
		for (Map.Entry<?, ?> entry : map.entrySet()) {
			String key = (String) entry.getKey();
			String value = (String) entry.getValue();
			System.out.println(key + "=" + value);
		}
	}

	public void testGoogle() throws OpenidFacadeException {
		if (skip_test)
			return;
		OpenidFacade of = new OpenidFacade("google.com/accounts/o8/id",
				"http://localhost/");
		String url = of.getDestinationUrl();
		assertEquals("https://www.google.com/accounts/o8/ud", url);
		Map<?, ?> map = of.getParameterMap();
		for (Map.Entry<?, ?> entry : map.entrySet()) {
			String key = (String) entry.getKey();
			String value = (String) entry.getValue();
			System.out.println(key + "=" + value);
		}
	}

	public void testSetupProxyAllNull() throws Exception {
		HttpClientFactory.setProxyProperties(null);
		ProxyProperties proxyProperties = null;
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNull(proxyProperties);
		System.getProperties().remove("openid.http.proxyHost");
		System.getProperties().remove("openid.http.proxyPort");
		System.getProperties().remove("http.proxyHost");
		System.getProperties().remove("http.proxyPort");
		OpenidFacade.setupProxy(null, 0, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNull(proxyProperties);
	}

	public void testSetupProxySystemProperties() throws Exception {
		testSetupProxyAllNull();
		ProxyProperties proxyProperties = null;
		System.setProperty("http.proxyHost", "host1");
		System.setProperty("http.proxyPort", "80");
		OpenidFacade.setupProxy(null, 0, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		String proxyHostName = proxyProperties.getProxyHostName();
		int proxyPort = proxyProperties.getProxyPort();
		assertEquals("host1", proxyHostName);
		assertEquals(80, proxyPort);
	}

	public void testSetupProxySystemPropertiesForce() throws Exception {
		testSetupProxyAllNull();
		ProxyProperties proxyProperties = null;
		System.setProperty("http.proxyHost", "host1");
		System.setProperty("http.proxyPort", "80");
		OpenidFacade.setupProxy(null, 0, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		String proxyHostName = proxyProperties.getProxyHostName();
		int proxyPort = proxyProperties.getProxyPort();
		assertEquals("host1", proxyHostName);
		assertEquals(80, proxyPort);

		System.setProperty("http.proxyHost", "host2");
		System.setProperty("http.proxyPort", "81");
		OpenidFacade.setupProxy(null, 0, true);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		proxyHostName = proxyProperties.getProxyHostName();
		proxyPort = proxyProperties.getProxyPort();
		assertEquals("host2", proxyHostName);
		assertEquals(81, proxyPort);

		System.setProperty("http.proxyHost", "host1");
		System.setProperty("http.proxyPort", "80");
		OpenidFacade.setupProxy(null, 0, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		proxyHostName = proxyProperties.getProxyHostName();
		proxyPort = proxyProperties.getProxyPort();
		assertEquals("host2", proxyHostName);
		assertEquals(81, proxyPort);
	}

	public void testSetupProxySystemPropertiesOpenId() throws Exception {
		testSetupProxyAllNull();
		ProxyProperties proxyProperties = null;
		System.setProperty("openid.http.proxyHost", "host1");
		System.setProperty("openid.http.proxyPort", "80");
		System.setProperty("http.proxyHost", "xxx");
		System.setProperty("http.proxyPort", "xx");
		OpenidFacade.setupProxy(null, 0, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		String proxyHostName = proxyProperties.getProxyHostName();
		int proxyPort = proxyProperties.getProxyPort();
		assertEquals("host1", proxyHostName);
		assertEquals(80, proxyPort);
	}

	public void testSetupProxySystemPropertiesOpenIdForce() throws Exception {
		testSetupProxyAllNull();
		ProxyProperties proxyProperties = null;
		System.setProperty("openid.http.proxyHost", "host1");
		System.setProperty("openid.http.proxyPort", "80");
		OpenidFacade.setupProxy(null, 0, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		String proxyHostName = proxyProperties.getProxyHostName();
		int proxyPort = proxyProperties.getProxyPort();
		assertEquals("host1", proxyHostName);
		assertEquals(80, proxyPort);

		System.setProperty("openid.http.proxyHost", "host2");
		System.setProperty("openid.http.proxyPort", "81");
		System.setProperty("http.proxyHost", "xx");
		System.setProperty("http.proxyPort", "xx");
		OpenidFacade.setupProxy(null, 0, true);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		proxyHostName = proxyProperties.getProxyHostName();
		proxyPort = proxyProperties.getProxyPort();
		assertEquals("host2", proxyHostName);
		assertEquals(81, proxyPort);

		System.setProperty("openid.http.proxyHost", "host1");
		System.setProperty("openid.http.proxyPort", "80");
		System.setProperty("http.proxyHost", "xx");
		System.setProperty("http.proxyPort", "xx");
		OpenidFacade.setupProxy(null, 0, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		proxyHostName = proxyProperties.getProxyHostName();
		proxyPort = proxyProperties.getProxyPort();
		assertEquals("host2", proxyHostName);
		assertEquals(81, proxyPort);
	}

	public void testSetupProxyParam() throws Exception {
		testSetupProxyAllNull();
		ProxyProperties proxyProperties = null;
		System.setProperty("openid.http.proxyHost", "xx");
		System.setProperty("openid.http.proxyPort", "xx");
		System.setProperty("http.proxyHost", "xx");
		System.setProperty("http.proxyPort", "xx");
		OpenidFacade.setupProxy("host1", 80, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		String proxyHostName = proxyProperties.getProxyHostName();
		int proxyPort = proxyProperties.getProxyPort();
		assertEquals("host1", proxyHostName);
		assertEquals(80, proxyPort);
	}

	public void testSetupProxyParamForce() throws Exception {
		testSetupProxyAllNull();
		ProxyProperties proxyProperties = null;
		System.setProperty("openid.http.proxyHost", "xx");
		System.setProperty("openid.http.proxyPort", "xx");
		System.setProperty("http.proxyHost", "xx");
		System.setProperty("http.proxyPort", "xx");
		OpenidFacade.setupProxy("host1", 80, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		String proxyHostName = proxyProperties.getProxyHostName();
		int proxyPort = proxyProperties.getProxyPort();
		assertEquals("host1", proxyHostName);
		assertEquals(80, proxyPort);
		System.setProperty("openid.http.proxyHost", "xx");
		System.setProperty("openid.http.proxyPort", "xx");
		System.setProperty("http.proxyHost", "xx");
		System.setProperty("http.proxyPort", "xx");
		OpenidFacade.setupProxy("host2", 81, true);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		proxyHostName = proxyProperties.getProxyHostName();
		proxyPort = proxyProperties.getProxyPort();
		assertEquals("host2", proxyHostName);
		assertEquals(81, proxyPort);
		System.setProperty("openid.http.proxyHost", "xx");
		System.setProperty("openid.http.proxyPort", "xx");
		System.setProperty("http.proxyHost", "xx");
		System.setProperty("http.proxyPort", "xx");
		OpenidFacade.setupProxy("host1", 80, false);
		proxyProperties = HttpClientFactory.getProxyProperties();
		assertNotNull(proxyProperties);
		proxyHostName = proxyProperties.getProxyHostName();
		proxyPort = proxyProperties.getProxyPort();
		assertEquals("host2", proxyHostName);
		assertEquals(81, proxyPort);
	}
}