package jp.co.opst.sms.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import com.google.appengine.api.datastore.Key;

import org.slim3.datastore.Attribute;
import org.slim3.datastore.Model;

@Model(schemaVersion = 1)
public class UserInformation implements Serializable {

    private static final long serialVersionUID = 1L;

    @Attribute(primaryKey = true)
    private Key key;
    @Attribute(version = true)
    private Long version;
    private String password;
    private String EMail;
    private String name;
    private String authority;
    private Date createDate;
    private Date lastUpdateDate;

    /**
     * Returns the eMail.
     *　キー
     * @return the eMail
     */
    public Key getKey() {
        return key;
    }
    
    /**
     * Sets the eMail.
     *　キー
     * @param string
     *            the eMail
     */
    public void setKey(Key key) {
        this.key = key;
    }
    
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getEMail() {
		return EMail;
	}

	public void setEMail(String eMail) {
		EMail = eMail;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAuthority() {
		return authority;
	}

	public void setAuthority(String authority) {
		this.authority = authority;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	public void insertCreateDate(Date createDate) {
		Calendar cal = Calendar.getInstance();
		this.createDate = cal.getTime();
	}

	public Date getLastUpdateDate() {
		return lastUpdateDate;
	}

	public void setLastUpdateDate(Date lastUpdateDate) {
		this.lastUpdateDate = lastUpdateDate;
	}
	
	public void insertLastUpdateDate(Date lastUpdateDate) {
		Calendar cal = Calendar.getInstance();
		this.lastUpdateDate = cal.getTime();
	}

	public String getLastUpdateUserID() {
		return lastUpdateUserID;
	}

	public void setLastUpdateUserID(String lastUpdateUserID) {
		this.lastUpdateUserID = lastUpdateUserID;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	private String lastUpdateUserID;
    
    /**
     * Returns the version.
     *
     * @return the version
     */
    public Long getVersion() {
        return version;
    }

    /**
     * Sets the version.
     *
     * @param version
     *            the version
     */
    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((key == null) ? 0 : key.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        UserInformation other = (UserInformation) obj;
        if (key == null) {
            if (other.key != null) {
                return false;
            }
        } else if (!key.equals(other.key)) {
            return false;
        }
        return true;
    }
}
