package jp.co.opst.sms.controller.masterTools.user;

import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;

import jp.co.opst.sms.dao.UserInformationDao;
import jp.co.opst.sms.model.UserInformation;

import org.slim3.controller.Controller;
import org.slim3.controller.Navigation;

public class InsertController extends Controller {
	private final Logger logger = Logger.getLogger("SMS Log");
	@Override
	public Navigation run() throws Exception {
		UserInformation userInformation = new UserInformation();
		userInformation.setEMail((String) request.getAttribute("EMail"));
		if(userInformation.getEMail() == null){
			logger.info("[Fail]:ユーザー登録失敗");
		}
		userInformation.setAuthority((String) request.getAttribute("authority"));
		if(userInformation.getAuthority() == null){
			logger.info("[Fail]:ユーザー登録失敗");
		}

		doInsertNewUser(userInformation);
		
		request.setAttribute("InsertedUser", userInformation);
		return forward("/member/admin/userMaster");
	}
	public void doInsertNewUser(UserInformation userInformation){
		Calendar cal = Calendar.getInstance();
		Date date = cal.getTime();
		userInformation.insertCreateDate(date);
		userInformation.insertLastUpdateDate(date);

		UserInformationDao userDao = new UserInformationDao();
		Key key = KeyFactory.createKey("UserInformation", userInformation.getEMail());
		if(userDao.exists(key)){
			logger.info("[Fail]:既に登録されているユーザーです。");
		}
		key = userDao.put(userInformation);
		userInformation = userDao.get(key);
		if(userInformation == null){
			logger.info("[Fail]:ユーザー登録失敗");
		}
		logger.info("[SUCCESS]:ユーザー登録完了");
	}
}
