package jp.co.opst.sms.controller.filter;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.co.opst.sms.logic.LoginLogic;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;

/**
 * 認証フィルター
 * 
 * @author y-kim
 * 
 */
public class LoginFilter implements Filter {

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {

	}

	@Override
	public void doFilter(ServletRequest req, ServletResponse res,
			FilterChain chain) throws IOException, ServletException {

		final Logger logger = Logger.getLogger("SMS Log");
		final HttpServletRequest request = (HttpServletRequest) req;
		final HttpServletResponse response = (HttpServletResponse) res;

		UserService us = UserServiceFactory.getUserService();
		User user = LoginLogic.checkLogin();

		if (user == null) {
			response.sendRedirect(us.createLoginURL(request.getRequestURI()));
			doFilter(req, res, chain);
		}

		HttpSession session = request.getSession();
		session.setAttribute("UserInformation", us.getCurrentUser());

		logger.log(Level.INFO, "[INFO]: URI: " + request.getRequestURI());
		chain.doFilter(req, res);
	}

	@Override
	public void destroy() {

	}

}
