/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.QueryOptionsChecker;
import com.google.appengine.api.search.query.QueryTreeBuilder;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import java.io.UnsupportedEncodingException;

public final class QueryChecker {
    public static final int MAXIMUM_QUERY_LENGTH = 2000;

    public static String checkQuery(String query) {
        int length;
        Preconditions.checkNotNull(query, "query cannot be null");
        try {
            length = query.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding UTF-8. Shouldn't  happen, ever!");
        }
        Preconditions.checkArgument(length <= 2000, String.format("query string must not be longer than %d bytes, was %d", 2000, length));
        try {
            new QueryTreeBuilder().parse(query);
        }
        catch (RecognitionException e) {
            throw new SearchQueryException("Unable to parse query: " + query);
        }
        return query;
    }

    public static SearchServicePb.SearchParams checkValid(SearchServicePb.SearchParams params) {
        IndexChecker.checkName(params.getIndexSpec().getName());
        QueryChecker.checkQuery(params.getQuery());
        QueryOptionsChecker.checkValid(params);
        return params;
    }
}

