/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base;

import com.google.appengine.repackaged.com.google.io.base.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class CoreMarshallers {
    public static final Marshaller<String> UTF8_MARSHALLER = new StringMarshaller("UTF-8");
    public static final Marshaller<String> ISO_8859_1_MARSHALLER = new Iso88591Marshaller();
    public static final Marshaller<String> US_ASCII_MARSHALLER = ISO_8859_1_MARSHALLER;
    public static final Marshaller<Integer> STRING_INTEGER_MARSHALLER = StringIntegerMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Long> STRING_LONG_MARSHALLER = StringLongMarshaller.SOLE_INSTANCE;
    private static final byte[] TENS_DIGITS = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] ONES_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    public static final Marshaller<Float> FLOAT_MARSHALLER = FloatMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Float> BIG_ENDIAN_FLOAT_MARSHALLER = BigEndianFloatMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Double> DOUBLE_MARSHALLER = DoubleMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Double> BIG_ENDIAN_DOUBLE_MARSHALLER = BigEndianDoubleMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Integer> INTEGER_MARSHALLER = IntegerMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Integer> BIG_ENDIAN_INTEGER_MARSHALLER = BigEndianIntegerMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Short> SHORT_MARSHALLER = ShortMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Short> BIG_ENDIAN_SHORT_MARSHALLER = BigEndianShortMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Long> LONG_MARSHALLER = LongMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Long> BIG_ENDIAN_LONG_MARSHALLER = BigEndianLongMarshaller.SOLE_INSTANCE;
    public static final Marshaller<Double> STRING_DOUBLE_MARSHALLER = StringDoubleMarshaller.SOLE_INSTANCE;
    public static final Marshaller<byte[]> BYTE_ARRAY_MARSHALLER = ByteArrayMarshaller.SOLE_INSTANCE;
    public static final Marshaller<byte[]> ALIASING_BYTE_ARRAY_MARSHALLER = AliasingByteArrayMarshaller.SOLE_INSTANCE;
    public static final Marshaller<ByteBuffer> BYTE_BUFFER_MARSHALLER = ByteBufferMarshaller.SOLE_INSTANCE;
    public static final Marshaller<ByteBuffer> ALIASING_BYTE_BUFFER_MARSHALLER = AliasingByteBufferMarshaller.SOLE_INSTANCE;

    CoreMarshallers() {
    }

    public static Marshaller<String> stringMarshaller(String encoding) {
        return new StringMarshaller(encoding);
    }

    public static <T extends Serializable> Marshaller<T> serializationMarshaller() {
        return SerializationMarshaller.SOLE_INSTANCE;
    }

    public static <T> Marshaller<T> nullMarshaller() {
        return NullMarshaller.SOLE_INSTANCE;
    }

    public static <T> byte[] toByteArray(Marshaller<T> marshaller, ByteOrder order, T object) {
        int max = marshaller.maxEncodingSize(object);
        byte[] result = new byte[max];
        ByteBuffer sink = ByteBuffer.wrap(result).order(order);
        marshaller.marshal(object, sink);
        int size = sink.position();
        if (size == max) {
            return result;
        }
        byte[] trimmed = new byte[size];
        System.arraycopy(result, 0, trimmed, 0, size);
        return trimmed;
    }

    public static <T> byte[] toByteArray(Marshaller<T> marshaller, T object) {
        return CoreMarshallers.toByteArray(marshaller, ByteOrder.LITTLE_ENDIAN, object);
    }

    private static class AliasingByteBufferMarshaller
    extends ByteBufferMarshaller {
        static final Marshaller<ByteBuffer> SOLE_INSTANCE = new AliasingByteBufferMarshaller();
        private static final long serialVersionUID = 724976L;

        private AliasingByteBufferMarshaller() {
        }

        @Override
        public ByteBuffer unmarshal(ByteBuffer source) {
            return source;
        }
    }

    private static class ByteBufferMarshaller
    extends VariableSizeMarshaller<ByteBuffer> {
        static final Marshaller<ByteBuffer> SOLE_INSTANCE = new ByteBufferMarshaller();
        private static final long serialVersionUID = 0xABACABL;

        private ByteBufferMarshaller() {
        }

        @Override
        public void marshal(ByteBuffer buffer, ByteBuffer sink) {
            sink.put(buffer);
        }

        @Override
        public ByteBuffer unmarshal(ByteBuffer source) {
            byte[] resultArray = new byte[source.remaining()];
            source.get(resultArray);
            return ByteBuffer.wrap(resultArray);
        }

        @Override
        public int maxEncodingSize(ByteBuffer buffer) {
            return buffer.remaining();
        }

        @Override
        public boolean isMaxEncodingSizeTight() {
            return true;
        }
    }

    private static class AliasingByteArrayMarshaller
    extends ByteArrayMarshaller {
        static final Marshaller<byte[]> SOLE_INSTANCE = new AliasingByteArrayMarshaller();
        private static final long serialVersionUID = 56026L;

        private AliasingByteArrayMarshaller() {
        }

        @Override
        public byte[] unmarshal(ByteBuffer source) {
            byte[] result;
            int resultLength = source.remaining();
            if (source.hasArray() && (result = source.array()).length == resultLength) {
                return result;
            }
            result = new byte[resultLength];
            source.get(result);
            return result;
        }
    }

    private static class ByteArrayMarshaller
    extends VariableSizeMarshaller<byte[]> {
        static final Marshaller<byte[]> SOLE_INSTANCE = new ByteArrayMarshaller();
        private static final long serialVersionUID = 10477109577251L;

        private ByteArrayMarshaller() {
        }

        @Override
        public void marshal(byte[] array, ByteBuffer sink) {
            sink.put(array);
        }

        @Override
        public byte[] unmarshal(ByteBuffer source) {
            byte[] result = new byte[source.remaining()];
            source.get(result);
            return result;
        }

        @Override
        public int maxEncodingSize(byte[] array) {
            return array.length;
        }

        @Override
        public boolean isMaxEncodingSizeTight() {
            return true;
        }
    }

    private static class NullMarshaller<T>
    extends ConstantSizeMarshaller<T> {
        static final Marshaller SOLE_INSTANCE = new NullMarshaller();
        private static final long serialVersionUID = 730583684826503L;

        private NullMarshaller() {
        }

        @Override
        public void marshal(T object, ByteBuffer sink) {
        }

        @Override
        public T unmarshal(ByteBuffer source) {
            return null;
        }

        @Override
        public int maxEncodingSize(T object) {
            return 0;
        }
    }

    private static class SerializationMarshaller<T extends Serializable>
    extends VariableSizeMarshaller<T> {
        private static final long serialVersionUID = 6731545518437765051L;
        static final Marshaller SOLE_INSTANCE = new SerializationMarshaller();

        private SerializationMarshaller() {
        }

        @Override
        public void marshal(T object, ByteBuffer sink) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream objectStream = new ObjectOutputStream(baos);
                objectStream.writeObject(object);
                byte[] bytes = baos.toByteArray();
                sink.put(bytes);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public T unmarshal(final ByteBuffer source) {
            try {
                return (T)((Serializable)new ObjectInputStream(new InputStream(){

                    @Override
                    public int read() {
                        return source.hasRemaining() ? source.get() & 0xFF : -1;
                    }
                }).readObject());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public int maxEncodingSize(T object) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream objectStream = new ObjectOutputStream(baos);
                objectStream.writeObject(object);
                byte[] bytes = baos.toByteArray();
                return bytes.length;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public boolean isUnmarshalRestrained() {
            return true;
        }

        @Override
        public boolean isMaxEncodingSizeTight() {
            return true;
        }
    }

    private static class StringDoubleMarshaller
    extends VariableSizeMarshaller<Double> {
        static final Marshaller<Double> SOLE_INSTANCE = new StringDoubleMarshaller();
        private static final long serialVersionUID = 433894675489L;

        private StringDoubleMarshaller() {
        }

        @Override
        public void marshal(Double object, ByteBuffer sink) {
            UTF8_MARSHALLER.marshal(object.toString(), sink);
        }

        @Override
        public Double unmarshal(ByteBuffer source) {
            return Double.parseDouble(ISO_8859_1_MARSHALLER.unmarshal(source));
        }

        @Override
        public int maxEncodingSize(Double d) {
            return 30;
        }
    }

    private static class BigEndianLongMarshaller
    extends ConstantSizeMarshaller<Long> {
        static final Marshaller<Long> SOLE_INSTANCE = new BigEndianLongMarshaller();
        private static final long serialVersionUID = 320272259453072L;

        private BigEndianLongMarshaller() {
        }

        @Override
        public void marshal(Long data, ByteBuffer sink) {
            sink.putLong(Long.reverseBytes(data));
        }

        @Override
        public Long unmarshal(ByteBuffer source) {
            return Long.reverseBytes(source.getLong());
        }

        @Override
        public int maxEncodingSize(Long x) {
            return 8;
        }
    }

    private static class LongMarshaller
    extends ConstantSizeMarshaller<Long> {
        static final Marshaller<Long> SOLE_INSTANCE = new LongMarshaller();
        private static final long serialVersionUID = 42787806651499928L;

        private LongMarshaller() {
        }

        @Override
        public void marshal(Long data, ByteBuffer sink) {
            sink.putLong(data);
        }

        @Override
        public Long unmarshal(ByteBuffer source) {
            return source.getLong();
        }

        @Override
        public int maxEncodingSize(Long x) {
            return 8;
        }
    }

    private static class BigEndianShortMarshaller
    extends ConstantSizeMarshaller<Short> {
        static final Marshaller<Short> SOLE_INSTANCE = new BigEndianShortMarshaller();
        private static final long serialVersionUID = 10192110587987L;

        private BigEndianShortMarshaller() {
        }

        @Override
        public void marshal(Short data, ByteBuffer sink) {
            sink.putShort(Short.reverseBytes(data));
        }

        @Override
        public Short unmarshal(ByteBuffer source) {
            return Short.reverseBytes(source.getShort());
        }

        @Override
        public int maxEncodingSize(Short i) {
            return 2;
        }
    }

    private static class ShortMarshaller
    extends ConstantSizeMarshaller<Short> {
        static final Marshaller<Short> SOLE_INSTANCE = new ShortMarshaller();
        private static final long serialVersionUID = 14735114479699201L;

        private ShortMarshaller() {
        }

        @Override
        public void marshal(Short data, ByteBuffer sink) {
            sink.putShort(data);
        }

        @Override
        public Short unmarshal(ByteBuffer source) {
            return source.getShort();
        }

        @Override
        public int maxEncodingSize(Short i) {
            return 2;
        }
    }

    private static class BigEndianIntegerMarshaller
    extends ConstantSizeMarshaller<Integer> {
        static final Marshaller<Integer> SOLE_INSTANCE = new BigEndianIntegerMarshaller();
        private static final long serialVersionUID = 10192110587988L;

        private BigEndianIntegerMarshaller() {
        }

        @Override
        public void marshal(Integer data, ByteBuffer sink) {
            sink.putInt(Integer.reverseBytes(data));
        }

        @Override
        public Integer unmarshal(ByteBuffer source) {
            return Integer.reverseBytes(source.getInt());
        }

        @Override
        public int maxEncodingSize(Integer i) {
            return 4;
        }
    }

    private static class IntegerMarshaller
    extends ConstantSizeMarshaller<Integer> {
        static final Marshaller<Integer> SOLE_INSTANCE = new IntegerMarshaller();
        private static final long serialVersionUID = 14735114479699202L;

        private IntegerMarshaller() {
        }

        @Override
        public void marshal(Integer data, ByteBuffer sink) {
            sink.putInt(data);
        }

        @Override
        public Integer unmarshal(ByteBuffer source) {
            return source.getInt();
        }

        @Override
        public int maxEncodingSize(Integer i) {
            return 4;
        }
    }

    private static class BigEndianDoubleMarshaller
    extends ConstantSizeMarshaller<Double> {
        private static final long serialVersionUID = 2774248703628886040L;
        static final Marshaller<Double> SOLE_INSTANCE = new BigEndianDoubleMarshaller();

        private BigEndianDoubleMarshaller() {
        }

        @Override
        public void marshal(Double data, ByteBuffer sink) {
            sink.putLong(Long.reverseBytes(Double.doubleToLongBits(data)));
        }

        @Override
        public Double unmarshal(ByteBuffer source) {
            return Double.longBitsToDouble(Long.reverseBytes(source.getLong()));
        }

        @Override
        public int maxEncodingSize(Double d) {
            return 8;
        }
    }

    private static class DoubleMarshaller
    extends ConstantSizeMarshaller<Double> {
        private static final long serialVersionUID = 4198721431645827080L;
        static final Marshaller<Double> SOLE_INSTANCE = new DoubleMarshaller();

        private DoubleMarshaller() {
        }

        @Override
        public void marshal(Double data, ByteBuffer sink) {
            sink.putDouble(data);
        }

        @Override
        public Double unmarshal(ByteBuffer source) {
            return source.getDouble();
        }

        @Override
        public int maxEncodingSize(Double d) {
            return 8;
        }
    }

    private static class BigEndianFloatMarshaller
    extends ConstantSizeMarshaller<Float> {
        private static final long serialVersionUID = 2999251983789197433L;
        static final Marshaller<Float> SOLE_INSTANCE = new BigEndianFloatMarshaller();

        private BigEndianFloatMarshaller() {
        }

        @Override
        public void marshal(Float data, ByteBuffer sink) {
            sink.putInt(Integer.reverseBytes(Float.floatToIntBits(data.floatValue())));
        }

        @Override
        public Float unmarshal(ByteBuffer source) {
            return Float.valueOf(Float.intBitsToFloat(Integer.reverseBytes(source.getInt())));
        }

        @Override
        public int maxEncodingSize(Float f) {
            return 4;
        }
    }

    private static class FloatMarshaller
    extends ConstantSizeMarshaller<Float> {
        private static final long serialVersionUID = -2839225061932157527L;
        static final Marshaller<Float> SOLE_INSTANCE = new FloatMarshaller();

        private FloatMarshaller() {
        }

        @Override
        public void marshal(Float data, ByteBuffer sink) {
            sink.putFloat(data.floatValue());
        }

        @Override
        public Float unmarshal(ByteBuffer source) {
            return Float.valueOf(source.getFloat());
        }

        @Override
        public int maxEncodingSize(Float f) {
            return 4;
        }
    }

    private static class StringLongMarshaller
    extends VariableSizeMarshaller<Long> {
        static final Marshaller<Long> SOLE_INSTANCE = new StringLongMarshaller();
        private static final byte[] LONG_MIN_VALUE = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
        private static final long serialVersionUID = 30516L;

        private StringLongMarshaller() {
        }

        @Override
        public void marshal(Long value, ByteBuffer sink) {
            int q;
            int digit;
            int cursor;
            byte[] result;
            int length;
            boolean negative;
            long val = value;
            boolean bl = negative = val < 0L;
            if (negative) {
                if (val == Long.MIN_VALUE) {
                    sink.put(LONG_MIN_VALUE);
                    return;
                }
                val = -val;
                length = 1;
            } else {
                if (val < 10L) {
                    sink.put((byte)(48L + val));
                    return;
                }
                length = 0;
            }
            length += StringLongMarshaller.numDigits(val);
            if (sink.hasArray()) {
                sink.position(sink.position() + length);
                result = sink.array();
                cursor = sink.arrayOffset() + sink.position();
            } else {
                result = new byte[length];
                cursor = length;
            }
            while (val > Integer.MAX_VALUE) {
                long q2 = val / 100L;
                digit = (int)(val - ((q2 << 6) + (q2 << 5) + (q2 << 2)));
                val = q2;
                result[--cursor] = ONES_DIGITS[digit];
                result[--cursor] = TENS_DIGITS[digit];
            }
            int v = (int)val;
            while (v >= 65536) {
                q = v / 100;
                digit = v - ((q << 6) + (q << 5) + (q << 2));
                v = q;
                result[--cursor] = ONES_DIGITS[digit];
                result[--cursor] = TENS_DIGITS[digit];
            }
            do {
                q = v * 52429 >>> 19;
                digit = v - ((q << 3) + (q << 1));
                v = q;
                result[--cursor] = (byte)(48 + digit);
            } while (v != 0);
            if (negative) {
                result[--cursor] = 45;
            }
            if (!sink.hasArray()) {
                sink.put(result);
            }
        }

        private static int numDigits(long j) {
            return j < 10L ? 1 : (j < 100L ? 2 : (j < 1000L ? 3 : (j < 10000L ? 4 : (j < 100000L ? 5 : (j < 1000000L ? 6 : (j < 10000000L ? 7 : (j < 100000000L ? 8 : (j < 1000000000L ? 9 : (j < 10000000000L ? 10 : (j < 100000000000L ? 11 : (j < 1000000000000L ? 12 : (j < 10000000000000L ? 13 : (j < 100000000000000L ? 14 : (j < 1000000000000000L ? 15 : (j < 10000000000000000L ? 16 : (j < 100000000000000000L ? 17 : (j < 1000000000000000000L ? 18 : 19)))))))))))))))));
        }

        @Override
        public Long unmarshal(ByteBuffer source) {
            int cursor;
            byte[] buf;
            int length = source.remaining();
            if (source.hasArray()) {
                buf = source.array();
                int position = source.position();
                cursor = source.arrayOffset() + position;
                source.position(position + length);
            } else {
                buf = new byte[length];
                source.get(buf);
                cursor = 0;
            }
            int limit = cursor + length;
            boolean negate = false;
            if (buf[cursor] == 45) {
                negate = true;
                ++cursor;
            }
            long result = buf[cursor] - 48;
            while (++cursor < limit) {
                result = (result << 3) + (result << 1) + (long)(buf[cursor] - 48);
            }
            return negate ? -result : result;
        }

        @Override
        public int maxEncodingSize(Long j) {
            return 20;
        }
    }

    private static class StringIntegerMarshaller
    extends VariableSizeMarshaller<Integer> {
        static final Marshaller<Integer> SOLE_INSTANCE = new StringIntegerMarshaller();
        private static final byte[] INT_MIN_VALUE = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
        private static final long serialVersionUID = 0x33333333L;

        private StringIntegerMarshaller() {
        }

        @Override
        public void marshal(Integer value, ByteBuffer sink) {
            int digit;
            int q;
            int cursor;
            byte[] result;
            int length;
            boolean negative;
            int val = value;
            boolean bl = negative = val < 0;
            if (negative) {
                if (val == Integer.MIN_VALUE) {
                    sink.put(INT_MIN_VALUE);
                    return;
                }
                val = -val;
                length = 1;
            } else {
                if (val < 10) {
                    sink.put((byte)(48 + val));
                    return;
                }
                length = 0;
            }
            length += StringIntegerMarshaller.numDigits(val);
            if (sink.hasArray()) {
                sink.position(sink.position() + length);
                result = sink.array();
                cursor = sink.arrayOffset() + sink.position();
            } else {
                result = new byte[length];
                cursor = length;
            }
            while (val >= 65536) {
                q = val / 100;
                digit = val - ((q << 6) + (q << 5) + (q << 2));
                val = q;
                result[--cursor] = ONES_DIGITS[digit];
                result[--cursor] = TENS_DIGITS[digit];
            }
            do {
                q = val * 52429 >>> 19;
                digit = val - ((q << 3) + (q << 1));
                val = q;
                result[--cursor] = (byte)(48 + digit);
            } while (val != 0);
            if (negative) {
                result[--cursor] = 45;
            }
            if (!sink.hasArray()) {
                sink.put(result);
            }
        }

        private static int numDigits(int i) {
            return i < 10 ? 1 : (i < 100 ? 2 : (i < 1000 ? 3 : (i < 10000 ? 4 : (i < 100000 ? 5 : (i < 1000000 ? 6 : (i < 10000000 ? 7 : (i < 100000000 ? 8 : (i < 1000000000 ? 9 : 10))))))));
        }

        @Override
        public Integer unmarshal(ByteBuffer source) {
            int cursor;
            byte[] buf;
            int length = source.remaining();
            if (source.hasArray()) {
                buf = source.array();
                int position = source.position();
                cursor = source.arrayOffset() + position;
                source.position(position + length);
            } else {
                buf = new byte[length];
                source.get(buf);
                cursor = 0;
            }
            int limit = cursor + length;
            boolean negate = false;
            if (buf[cursor] == 45) {
                negate = true;
                ++cursor;
            }
            int result = buf[cursor] - 48;
            while (++cursor < limit) {
                result = (result << 3) + (result << 1) + (buf[cursor] - 48);
            }
            return negate ? -result : result;
        }

        @Override
        public int maxEncodingSize(Integer i) {
            return 11;
        }
    }

    private static class Iso88591Marshaller
    extends VariableSizeMarshaller<String> {
        private static final long serialVersionUID = 708446853355555L;

        private Iso88591Marshaller() {
        }

        @Override
        public void marshal(String string, ByteBuffer sink) {
            int length = string.length();
            if (sink.hasArray()) {
                int position = sink.position();
                sink.position(position + length);
                string.getBytes(0, length, sink.array(), sink.arrayOffset() + position);
            } else {
                byte[] bytes = new byte[length];
                string.getBytes(0, length, bytes, 0);
                sink.put(bytes);
            }
        }

        @Override
        public String unmarshal(ByteBuffer source) {
            int length = source.remaining();
            if (source.hasArray()) {
                String result = new String(source.array(), 0, source.arrayOffset() + source.position(), length);
                source.position(source.limit());
                return result;
            }
            byte[] buf = new byte[length];
            source.get(buf);
            return new String(buf, 0);
        }

        @Override
        public int maxEncodingSize(String string) {
            return string.length();
        }

        @Override
        public boolean isMaxEncodingSizeTight() {
            return true;
        }
    }

    private static class StringMarshaller
    extends VariableSizeMarshaller<String> {
        private final String encoding;
        private transient ThreadLocal<CharsetEncoder> encoder;
        private transient ThreadLocal<CharsetDecoder> decoder;
        private static final long serialVersionUID = 855555582L;

        StringMarshaller(String encoding) {
            if (encoding == null) {
                throw new NullPointerException();
            }
            this.encoding = encoding;
            this.initCoders();
            this.encoder.get();
        }

        @Override
        public void marshal(String string, ByteBuffer sink) {
            CharsetEncoder enc = this.encoder.get();
            enc.reset();
            enc.encode(CharBuffer.wrap(string), sink, true);
            enc.flush(sink);
        }

        @Override
        public String unmarshal(ByteBuffer source) {
            try {
                return this.decoder.get().decode(source).toString();
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public int maxEncodingSize(String str) {
            return (int)Math.ceil(this.encoder.get().maxBytesPerChar() * (float)str.length());
        }

        private void initCoders() {
            this.encoder = new ThreadLocal<CharsetEncoder>(){

                @Override
                protected CharsetEncoder initialValue() {
                    return Charset.forName(StringMarshaller.this.encoding).newEncoder();
                }
            };
            this.decoder = new ThreadLocal<CharsetDecoder>(){

                @Override
                protected CharsetDecoder initialValue() {
                    return Charset.forName(StringMarshaller.this.encoding).newDecoder();
                }
            };
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            this.initCoders();
        }
    }

    public static abstract class DelegatingMarshaller<T>
    implements Marshaller<T> {
        protected final Marshaller<T> delegate;

        protected DelegatingMarshaller(Marshaller<T> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this.delegate = delegate;
        }

        @Override
        public void marshal(T object, ByteBuffer sink) {
            this.delegate.marshal(object, sink);
        }

        @Override
        public T unmarshal(ByteBuffer source) {
            return this.delegate.unmarshal(source);
        }

        @Override
        public int maxEncodingSize(T object) {
            return this.delegate.maxEncodingSize(object);
        }

        @Override
        public boolean isUnmarshalRestrained() {
            return this.delegate.isUnmarshalRestrained();
        }

        @Override
        public boolean isMaxEncodingSizeTight() {
            return this.delegate.isMaxEncodingSizeTight();
        }

        @Override
        public boolean isEncodingSizeConstant() {
            return this.delegate.isEncodingSizeConstant();
        }
    }

    public static abstract class VariableSizeMarshaller<T>
    extends VariableSizeLocalMarshaller<T>
    implements Serializable {
    }

    public static abstract class VariableSizeLocalMarshaller<T>
    implements Marshaller<T> {
        @Override
        public boolean isUnmarshalRestrained() {
            return false;
        }

        @Override
        public boolean isMaxEncodingSizeTight() {
            return false;
        }

        @Override
        public final boolean isEncodingSizeConstant() {
            return false;
        }
    }

    public static abstract class ConstantSizeMarshaller<T>
    extends ConstantSizeLocalMarshaller<T>
    implements Serializable {
    }

    public static abstract class ConstantSizeLocalMarshaller<T>
    implements Marshaller<T> {
        @Override
        public final boolean isUnmarshalRestrained() {
            return true;
        }

        @Override
        public final boolean isMaxEncodingSizeTight() {
            return true;
        }

        @Override
        public final boolean isEncodingSizeConstant() {
            return true;
        }
    }
}

