/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.io.Serializable;

@GoogleInternal
public final class DoubleArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] list;
    private int length;

    @Deprecated
    public DoubleArray() {
        this.list = new double[4];
        this.length = 0;
    }

    @Deprecated
    public DoubleArray(int capacity) {
        this.list = new double[capacity];
        this.length = 0;
    }

    public DoubleArray(double[] source, int start, int num) {
        X.assertTrue(num >= 0);
        this.list = new double[num];
        this.length = num;
        System.arraycopy(source, start, this.list, 0, num);
    }

    @Deprecated
    private DoubleArray(double[] array, int arrayLength) {
        this.list = array;
        this.length = arrayLength;
    }

    @Deprecated
    public static DoubleArray newInstance(double ... array) {
        Preconditions.checkNotNull(array);
        return new DoubleArray(array, array.length);
    }

    @Deprecated
    public static DoubleArray newInstance(double[] array, int length) {
        Preconditions.checkNotNull(array);
        Preconditions.checkArgument(length >= 0 && length <= array.length);
        return new DoubleArray(array, length);
    }

    public int size() {
        return this.length;
    }

    public double get(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        return this.list[i];
    }

    public void set(int i, double x) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = x;
    }

    public void add(double x) {
        if (this.length >= this.list.length) {
            this.ensureCapacity(this.length + 1);
        }
        this.list[this.length++] = x;
    }

    public void add(double[] source, int start, int num) {
        if (this.length + num > this.list.length) {
            this.ensureCapacity(this.length + num);
        }
        System.arraycopy(source, start, this.list, this.length, num);
        this.length += num;
    }

    public void addArray(DoubleArray other) {
        this.add(other.rep(), 0, other.size());
    }

    public void clear() {
        this.length = 0;
    }

    public void removeLast() {
        X.assertTrue(this.length > 0);
        --this.length;
    }

    public double pop() {
        X.assertTrue(this.length > 0);
        return this.list[--this.length];
    }

    public void removeFast(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = this.list[this.length - 1];
        this.removeLast();
    }

    public int indexOf(double element) {
        for (int i = 0; i < this.length; ++i) {
            if (this.list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int n) {
        if (this.list.length < n) {
            int newSize = this.list.length * 2;
            if (newSize < n) {
                newSize = n;
            }
            double[] copy = new double[newSize];
            System.arraycopy(this.list, 0, copy, 0, this.length);
            this.list = copy;
        }
    }

    public double[] rep() {
        return this.list;
    }

    public void resize(int n) {
        X.assertTrue(n >= 0);
        this.ensureCapacity(n);
        this.length = n;
    }

    public void trimToSize() {
        if (this.list.length != this.length) {
            this.list = this.toArray();
        }
    }

    public void swap(DoubleArray other) {
        int tmpLength = this.length;
        this.length = other.length;
        other.length = tmpLength;
        double[] tmpList = this.list;
        this.list = other.list;
        other.list = tmpList;
    }

    public double[] toArray() {
        double[] copy = new double[this.length];
        System.arraycopy(this.list, 0, copy, 0, this.length);
        return copy;
    }

    public double[] subArray(int start, int len) {
        X.assertTrue(start >= 0);
        X.assertTrue(start + len <= this.length);
        double[] copy = new double[len];
        System.arraycopy(this.list, start, copy, 0, len);
        return copy;
    }

    public void copy(double[] dest, int len, int srcPos, int destPos) {
        X.assertTrue(srcPos >= 0);
        X.assertTrue(destPos >= 0);
        X.assertTrue(len >= 0);
        X.assertTrue(srcPos + len <= this.length);
        X.assertTrue(destPos + len <= dest.length);
        System.arraycopy(this.list, srcPos, dest, destPos, len);
    }
}

