/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.google.common.primitives;

import com.google.appengine.labs.repackaged.com.google.common.annotations.GoogleInternal;
import java.io.Serializable;
import java.util.NoSuchElementException;

@GoogleInternal
public final class IntQueue
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7259425973867757295L;
    private int[] elements;
    private int size = 0;
    private int head = 0;
    private int tail = 0;
    private static final int MIN_INITIAL_CAPACITY = 8;

    public IntQueue(int expectedSize) {
        int initialCapacity = 8;
        if (expectedSize > initialCapacity) {
            initialCapacity = expectedSize - 1;
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        this.elements = new int[initialCapacity];
    }

    public IntQueue() {
        this.elements = new int[16];
    }

    public void add(int element) {
        if (this.head == this.tail && this.size != 0) {
            this.growAndAdd(element);
        } else {
            this.elements[this.tail] = element;
            this.tail = this.tail + 1 & this.elements.length - 1;
            ++this.size;
        }
    }

    public int remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int result = this.elements[this.head];
        this.head = this.head + 1 & this.elements.length - 1;
        --this.size;
        return result;
    }

    public int element() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[this.head];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    public int[] toArray() {
        int[] array = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = this.elements[this.head + i & this.elements.length - 1];
        }
        return array;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.size; ++i) {
            buf.append(this.elements[this.head + i & this.elements.length - 1]).append(", ");
        }
        if (this.size > 0) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(']');
        return buf.toString();
    }

    public IntQueue clone() {
        IntQueue clone;
        try {
            clone = (IntQueue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        clone.elements = (int[])this.elements.clone();
        return clone;
    }

    private void growAndAdd(int element) {
        this.doubleCapacity();
        this.elements[this.tail] = element;
        this.tail = this.tail + 1 & this.elements.length - 1;
        ++this.size;
    }

    private void doubleCapacity() {
        int oldCapacity = this.elements.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, queue too big");
        }
        int[] newElements = new int[newCapacity];
        System.arraycopy(this.elements, this.head, newElements, 0, oldCapacity - this.head);
        System.arraycopy(this.elements, 0, newElements, oldCapacity - this.head, this.head);
        this.head = 0;
        this.tail = oldCapacity;
        this.elements = newElements;
    }
}

