/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.message.MessageFormatter;
import org.slim3.gen.util.CloseableUtil;
import org.slim3.gen.util.StringUtil;
import org.xml.sax.InputSource;

public class WebConfig {
    protected final File warDir;

    public WebConfig(File warDir) {
        if (warDir == null) {
            throw new NullPointerException("The warDir parameter is null.");
        }
        this.warDir = warDir;
    }

    public String getRootPackageName() throws IOException, XPathExpressionException {
        String rootPackageName = this.evaluate("/javaee:web-app/javaee:context-param/javaee:param-name[text()='slim3.rootPackage']/../javaee:param-value", "/j2ee:web-app/j2ee:context-param/j2ee:param-name[text()='slim3.rootPackage']/../j2ee:param-value");
        if (rootPackageName != null) {
            return rootPackageName;
        }
        throw new RuntimeException(MessageFormatter.getMessage(MessageCode.SLIM3GEN0008, new Object[0]));
    }

    public boolean isGWTServiceServletDefined() throws IOException, XPathExpressionException {
        String servletName = this.evaluate("/javaee:web-app/javaee:servlet/javaee:servlet-name[text()='GWTServiceServlet']", "/j2ee:web-app/j2ee:servlet/j2ee:servlet-name[text()='GWTServiceServlet']");
        return servletName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String evaluate(String ... expressions) throws IOException, XPathExpressionException {
        XPath xpath = this.createXPath();
        for (String expression : expressions) {
            FileInputStream inputStream = new FileInputStream(this.createWebXml());
            try {
                String value = null;
                value = xpath.evaluate(expression, new InputSource(inputStream));
                if (StringUtil.isEmpty(value)) continue;
                String string = value;
                return string;
            }
            finally {
                CloseableUtil.close(inputStream);
            }
        }
        return null;
    }

    protected XPath createXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new NullPointerException("The parameter prefix is null.");
                }
                if ("javaee".equals(prefix)) {
                    return "http://java.sun.com/xml/ns/javaee";
                }
                if ("j2ee".equals(prefix)) {
                    return "http://java.sun.com/xml/ns/j2ee";
                }
                if ("xml".equals(prefix)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                return "";
            }

            @Override
            public String getPrefix(String uri) {
                throw new UnsupportedOperationException("getPrefix");
            }

            public Iterator<?> getPrefixes(String uri) {
                throw new UnsupportedOperationException("getPrefixes");
            }
        });
        return xpath;
    }

    protected File createWebXml() {
        return new File(new File(this.warDir, "WEB-INF"), "web.xml");
    }
}

