/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.processor;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.util.DeclarationFilter;
import java.util.Set;
import org.slim3.gen.desc.AttributeMetaDescFactory;
import org.slim3.gen.desc.ModelMetaDesc;
import org.slim3.gen.desc.ModelMetaDescFactory;
import org.slim3.gen.generator.ModelMetaGenerator;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.message.MessageFormatter;
import org.slim3.gen.processor.AptException;
import org.slim3.gen.processor.GenerateSupport;
import org.slim3.gen.processor.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelProcessor
implements AnnotationProcessor {
    protected final Set<AnnotationTypeDeclaration> annotationTypeDeclarations;
    protected final AnnotationProcessorEnvironment env;
    protected final GenerateSupport generateSupport;

    public ModelProcessor(Set<AnnotationTypeDeclaration> annotationTypeDeclarations, AnnotationProcessorEnvironment env) {
        if (annotationTypeDeclarations == null) {
            throw new NullPointerException("The annotationTypeDeclarations parameter is null.");
        }
        if (env == null) {
            throw new NullPointerException("The env parameter is null.");
        }
        this.annotationTypeDeclarations = annotationTypeDeclarations;
        this.env = env;
        this.generateSupport = new GenerateSupport(env);
    }

    public void process() {
        for (AnnotationTypeDeclaration annotation : this.annotationTypeDeclarations) {
            for (ClassDeclaration element : DeclarationFilter.getFilter(ClassDeclaration.class).filter(this.env.getDeclarationsAnnotatedWith(annotation), ClassDeclaration.class)) {
                try {
                    this.handleClassDeclaration(element);
                }
                catch (AptException e) {
                    e.sendError();
                }
                catch (RuntimeException e) {
                    Logger.error(this.env, element.getPosition(), MessageFormatter.getMessage(MessageCode.SLIM3GEN0001, annotation.getQualifiedName()));
                    throw e;
                }
            }
        }
    }

    protected void handleClassDeclaration(ClassDeclaration declaration) {
        AttributeMetaDescFactory attributeMetaDescFactory = this.createAttributeMetaDescFactory();
        ModelMetaDescFactory modelMetaDescFactory = this.createModelMetaDescFactory(attributeMetaDescFactory);
        ModelMetaDesc modelMetaDesc = modelMetaDescFactory.createModelMetaDesc(declaration);
        if (!modelMetaDesc.isError()) {
            ModelMetaGenerator modelMetaGenerator = this.createModelMetaGenerator(modelMetaDesc);
            this.generateSupport.generate(modelMetaGenerator, modelMetaDesc);
        }
    }

    protected AttributeMetaDescFactory createAttributeMetaDescFactory() {
        return new AttributeMetaDescFactory(this.env);
    }

    protected ModelMetaDescFactory createModelMetaDescFactory(AttributeMetaDescFactory attributeMetaDescFactory) {
        return new ModelMetaDescFactory(this.env, attributeMetaDescFactory);
    }

    protected ModelMetaGenerator createModelMetaGenerator(ModelMetaDesc modelMetaDesc) {
        return new ModelMetaGenerator(modelMetaDesc);
    }
}

