/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import org.slim3.gen.desc.ControllerDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.util.ClassUtil;

public class ControllerGenerator
implements Generator {
    protected final ControllerDesc controllerDesc;

    public ControllerGenerator(ControllerDesc controllerDesc) {
        if (controllerDesc == null) {
            throw new NullPointerException("The controllerDesc parameter is null.");
        }
        this.controllerDesc = controllerDesc;
    }

    public void generate(Printer p) {
        if (this.controllerDesc.getPackageName().length() != 0) {
            p.println("package %s;", this.controllerDesc.getPackageName());
            p.println();
        }
        p.println("import %s;", this.controllerDesc.getSuperclassName());
        p.println("import %s;", "org.slim3.controller.Navigation");
        p.println();
        p.println("public class %s extends %s {", this.controllerDesc.getSimpleName(), ClassUtil.getSimpleName(this.controllerDesc.getSuperclassName()));
        p.println();
        p.println("    @Override", new Object[0]);
        p.println("    public %s run() throws Exception {", ClassUtil.getSimpleName("org.slim3.controller.Navigation"));
        if (this.controllerDesc.isUseView()) {
            p.println("        return forward(\"%s\");", this.controllerDesc.getSimpleViewName());
        } else {
            p.println("        return null;", new Object[0]);
        }
        p.println("    }", new Object[0]);
        p.println("}", new Object[0]);
    }
}

