/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ oXg ]
 */

#include "header.h"
#include "bdlist.h"

/*
 * oXg
 * Xg
 */
void bdlist_init(BDLIST_ENTRY *bdlist)
{
    assert(NULL != bdlist);

    /*  */
    bdlist->bdlist_prev = NULL;
    bdlist->bdlist_next = NULL;
}

/*
 * oXg
 * Xg̐擪擾
 */
BDLIST_ENTRY* bdlist_get_head(BDLIST_ENTRY *bdlist)
{
    BDLIST_ENTRY *head;

    assert(NULL != bdlist);
    head = bdlist;

    /* prevɐi */
    while (head->bdlist_prev != NULL)
    {
        head = head->bdlist_next;
    }

    return head;
}

/*
 * oXg
 * Xg̏I[擾
 */
BDLIST_ENTRY* bdlist_get_tail(BDLIST_ENTRY *bdlist)
{
    BDLIST_ENTRY *tail;

    assert(NULL != bdlist);
    tail = bdlist;

    /* nextɐi */
    while (tail->bdlist_next != NULL)
    {
        tail = tail->bdlist_next;
    }

    return tail;
}

/*
* oXg
* Xg̐擪ɒǉ
*/
void bdlist_insert_head(BDLIST_ENTRY *bdlist, BDLIST_ENTRY *entry)
{
    BDLIST_ENTRY *head;

    assert(NULL != bdlist);
    assert(NULL != entry);

    /* Xg̐擪擾 */
    head = bdlist_get_head(bdlist);

    /* head̑Oentry */
    assert(NULL == head->bdlist_prev);
    head->bdlist_prev = entry;

    /* entry̎head */
    entry->bdlist_next = head;

    /* entry̑O͂Ȃ */
    entry->bdlist_prev = NULL;
}

/*
 * oXg
 * Xg̏I[ɒǉ
 */
void bdlist_insert_tail(BDLIST_ENTRY *bdlist, BDLIST_ENTRY *entry)
{
    BDLIST_ENTRY *tail;

    assert(NULL != bdlist);
    assert(NULL != entry);

    /* Xg̏I[擾 */
    tail = bdlist_get_tail(bdlist);

    /* tail̎entry */
    tail->bdlist_next = entry;

    /* entry̑Otail */
    entry->bdlist_prev = tail;

    /* entry̎͂Ȃ */
    entry->bdlist_next = NULL;
}

/*
 * oXg
 * XgO
 */
BDLIST_ENTRY* bdlist_remove(BDLIST_ENTRY *entry)
{
    BDLIST_ENTRY *prev;
    BDLIST_ENTRY *next;

    assert(NULL != entry);

    /* entryprevnext擾 */
    prev = entry->bdlist_prev;
    next = entry->bdlist_next;

    /* prev݂΁Aprev->nextݒ */
    if (NULL != prev)
    {
        prev->bdlist_next = next;
    }

    /* next݂΁Anext->prevݒ */
    if (NULL != next)
    {
        next->bdlist_prev = prev;
    }

    /* Gg */
    entry->bdlist_prev = NULL;
    entry->bdlist_next = NULL;

    /* prev܂nextŁANULLłȂ̂Ԃ */
    if (NULL != prev)
    {
        /* prev */
        return prev;
    }

    /* next݂͑邩ȂANULLȂ */
    return next;
}

