/*
 * Debug Monitor Framework
 * Author: Yasushi Tanaka
 *
 * [ ʐM|[g ]
 */

#pragma once

#include "bdlist.h"

/*
 * ʐM|[g
 */
typedef struct _COMM_PORT
{
    /* oXg */
    BDLIST_ENTRY bdlist;

    /* |[gl[(:"COM3") */
    wchar_t *port_name;

    /* |[gt@C(:"\\.\COM3") */
    wchar_t *port_file;

    /* thl[(:"USB Serial Port(COM3)) */
    wchar_t *friendly_name;

    /* |[gԍ (:3) */
    UINT port_number;

    /* t@Cnh */
    HANDLE file_handle;
} COMM_PORT;

/*
 * O[o֐
 */

/*  */
void comm_init(void);

/* I */
void comm_deinit(void);

/* |[g */
void comm_enum(void);

/* |[g擾 */
UINT comm_get_portnum(void);

/* I[v */
BOOL comm_open(UINT index);

/* N[Y */
void comm_close(UINT index);

/* MoCg̎擾 */
UINT comm_get_bytes(UINT index);

/* M */
UINT comm_recv(UINT index, BYTE *buf, UINT buflen);

/* M */
UINT comm_send(UINT index, const BYTE *buf, UINT buflen);
